/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.jade.JadeInternals;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxElement;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.MessageType;
import snownee.jade.api.ui.Rect2f;
import snownee.jade.api.ui.ResizeableElement;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.ui.TooltipAnimation;
import snownee.jade.gui.JadeLinearLayout;
import snownee.jade.gui.LayoutWithPadding;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.ResizeableLayout;
import snownee.jade.impl.Tooltip;
import snownee.jade.track.ProgressTrackInfo;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.ToFloatFunction;
import snownee.jade.util.WailaExceptionHandler;

public class BoxElementImpl
extends BoxElement
implements class_4069 {
    public LayoutWithPadding layout;
    private final Tooltip tooltip;
    private final BoxStyle style;
    private final List<class_4068> renderables;
    @Nullable
    private List<class_339> widgets;
    @Nullable
    private List<class_364> eventListeners;
    private Element icon;
    private float boxProgress;
    private MessageType boxProgressType;
    private ProgressTrackInfo track;

    public BoxElementImpl(Tooltip tooltip, BoxStyle style) {
        this.tooltip = Objects.requireNonNull(tooltip);
        this.style = Objects.requireNonNull(style);
        this.icon = tooltip.getIcon();
        this.renderables = Lists.newArrayListWithExpectedSize((int)(tooltip.size() + 1));
        this.updateSize();
    }

    @Override
    public void updateSize() {
        JadeLinearLayout linearLayout = JadeLinearLayout.vertical().alignItems(JadeLinearLayout.Align.STRETCH);
        for (Tooltip.Line line : this.tooltip.lines) {
            JadeLinearLayout lineLayout = JadeLinearLayout.horizontal();
            for (class_8021 element2 : line.elements()) {
                if (element2 instanceof ResizeableElement) {
                    ResizeableElement resizeableElement = (ResizeableElement)element2;
                    resizeableElement.updateSize();
                }
                lineLayout.addChild(element2, lineLayout.newChildLayoutSettings(element2), container -> {
                    class_8021 patt1$temp;
                    Element element0;
                    class_8021 patt0$temp = container.field_40752;
                    if (patt0$temp instanceof Element && (element0 = (Element)patt0$temp).getAlignSelf() != null) {
                        container.alignSelf = element0.getAlignSelf();
                    }
                    if ((patt1$temp = container.field_40752) instanceof ResizeableLayout) {
                        ResizeableLayout resizeableLayout = (ResizeableLayout)patt1$temp;
                        container.flexGrow = resizeableLayout.getFlexGrow();
                    }
                });
            }
            class_7847 lineSettings = linearLayout.newChildLayoutSettings(lineLayout);
            if (line.settings != null) {
                lineSettings = (class_7847)line.settings.apply(lineSettings);
            }
            linearLayout.addChild(lineLayout, lineSettings, container -> {
                container.headMargin = line.marginTop;
                container.tailMargin = line.marginBottom;
            });
        }
        if (this.icon != null) {
            JadeLinearLayout iconLayout = JadeLinearLayout.horizontal().alignItems(JadeLinearLayout.Align.START).spacing(3);
            if (IWailaConfig.get().overlay().getIconMode() == IWailaConfig.IconMode.CENTERED) {
                iconLayout.alignItems(JadeLinearLayout.Align.CENTER);
            }
            iconLayout.addChild(this.icon);
            iconLayout.addChild(linearLayout);
            linearLayout = iconLayout;
        }
        this.layout = new LayoutWithPadding(linearLayout, this.style.padding(ScreenDirection.LEFT), this.style.padding(ScreenDirection.UP), this.style.padding(ScreenDirection.RIGHT), this.style.padding(ScreenDirection.DOWN));
        this.layout.method_48222();
        this.width = this.layout.method_25368();
        this.height = this.layout.method_25364();
        this.renderables.clear();
        JadeUI.visitChildrenRecursive(this.layout, element -> {
            if (element instanceof class_4068) {
                class_4068 renderable = (class_4068)element;
                this.renderables.add(renderable);
            }
        });
    }

    @Override
    public void method_46421(int x) {
        super.method_46421(x);
        this.layout.method_46421(x);
    }

    @Override
    public void method_46419(int y) {
        super.method_46419(y);
        this.layout.method_46419(y);
    }

    private static void chase(TooltipAnimation animation, ToFloatFunction<Rect2f> getter, FloatConsumer setter, float progress) {
        if (IWailaConfig.get().overlay().getAnimation()) {
            float source = getter.applyAsFloat(animation.rect);
            float target = getter.applyAsFloat(animation.expectedRect);
            float diff = target - source;
            if (diff == 0.0f) {
                return;
            }
            if (progress >= 1.0f) {
                animation.startTime = -1L;
                setter.accept(target);
                return;
            }
            float startValue = getter.applyAsFloat(animation.startRect);
            float deltaValue = target - startValue;
            setter.accept(startValue + progress * deltaValue);
        } else {
            setter.accept(getter.applyAsFloat(animation.expectedRect));
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.tooltip.isEmpty()) {
            return;
        }
        float alpha = IDisplayHelper.get().backgroundOpacity();
        boolean root = JadeIds.ROOT.equals((Object)this.getTag());
        if (root) {
            alpha *= IWailaConfig.get().overlay().getAlpha();
        }
        if (alpha > 0.0f) {
            this.style.render(graphics, this, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), alpha);
        }
        graphics.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364());
        for (class_4068 renderable : this.renderables) {
            try {
                renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, null, null);
                IDisplayHelper.get().drawBorder(graphics, ((class_8021)renderable).method_48202(), 1, -1996554240, true);
            }
        }
        graphics.method_44380();
        if (root && this.tooltip.sneakyDetails) {
            IThemeHelper.get().theme().sneakyDetails.render(graphics, partialTicks, this);
        }
    }

    @Override
    public void renderDebug(class_332 graphics, int mouseX, int mouseY, float partialTicks, Element.RenderDebugContext context) {
        super.renderDebug(graphics, mouseX, mouseY, partialTicks, context);
        JadeUI.visitChildrenRecursive(this.layout, layoutElement -> {
            if (layoutElement instanceof Element) {
                Element element = (Element)layoutElement;
                element.renderDebug(graphics, mouseX, mouseY, partialTicks, context);
            } else if (layoutElement instanceof class_8133) {
                JadeInternals.getDisplayHelper().drawBorder(graphics, layoutElement.method_48202(), 1, -2013200640, true);
            }
        });
    }

    @Override
    public Tooltip getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setBoxProgress(MessageType type, float progress) {
        this.boxProgress = progress;
        this.boxProgressType = type;
    }

    @Override
    public float getBoxProgress() {
        return this.boxProgressType == null ? Float.NaN : this.boxProgress;
    }

    @Override
    public void clearBoxProgress() {
        this.boxProgress = 0.0f;
        this.boxProgressType = null;
    }

    @Override
    @Nullable
    public Element getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(@Nullable Element icon) {
        this.icon = icon;
    }

    public void updateExpectedRect(TooltipAnimation animation) {
        Rect2f bossBarRect;
        class_1041 window = class_310.method_1551().method_22683();
        IWailaConfig.Overlay overlay = IWailaConfig.get().overlay();
        IWailaConfig.Accessibility accessibility = IWailaConfig.get().accessibility();
        float x = (float)window.method_4486() * accessibility.tryFlip(overlay.getOverlayPosX());
        float y = (float)window.method_4502() * (1.0f - overlay.getOverlayPosY());
        float width = this.layout.method_25368();
        float height = this.layout.method_25364();
        animation.scale = overlay.getOverlayScale();
        float thresholdHeight = (float)window.method_4502() * overlay.getAutoScaleThreshold();
        if (!JadeUI.isPinned() && (float)this.layout.method_25364() * animation.scale > thresholdHeight) {
            animation.scale = Math.max(animation.scale * 0.5f, thresholdHeight / (float)this.layout.method_25364());
        }
        Rect2f expectedRect = animation.expectedRect;
        expectedRect.setWidth((int)(width * animation.scale));
        expectedRect.setHeight((int)(height * animation.scale));
        expectedRect.setX((int)(x - expectedRect.getWidth() * accessibility.tryFlip(overlay.getAnchorX())));
        expectedRect.setY((int)(y - expectedRect.getHeight() * overlay.getAnchorY()));
        if (PreviewOptionsScreen.isAdjustingPosition()) {
            return;
        }
        IWailaConfig.BossBarOverlapMode mode = IWailaConfig.get().general().getBossBarOverlapMode();
        if (mode == IWailaConfig.BossBarOverlapMode.PUSH_DOWN && (bossBarRect = ClientProxy.getBossBarRect()) != null && bossBarRect.intersects(expectedRect)) {
            expectedRect.setY(bossBarRect.getY() + bossBarRect.getHeight());
        }
    }

    public void updateRect(TooltipAnimation animation) {
        Rect2f src = animation.rect;
        Rect2f target = animation.expectedRect;
        if (src.getWidth() == 0.0f) {
            src.setX(target.getX());
            src.setY(target.getY());
            src.setWidth(target.getWidth());
            src.setHeight(target.getHeight());
            animation.alpha = animation.showHideAlpha;
        } else {
            Duration duration = Duration.ofMillis(75L);
            long deltaTime = System.currentTimeMillis() - animation.startTime;
            long durationMillis = duration.toMillis();
            float progress = (float)deltaTime / (float)durationMillis;
            animation.alpha = Math.min(animation.showHideAlpha, Math.max(progress, 0.55f));
            BoxElementImpl.chase(animation, Rect2f::getX, src::setX, progress);
            BoxElementImpl.chase(animation, Rect2f::getY, src::setY, progress);
            BoxElementImpl.chase(animation, Rect2f::getWidth, it -> {
                src.setWidth(it);
                this.width = (int)(it / animation.scale);
            }, progress);
            BoxElementImpl.chase(animation, Rect2f::getHeight, it -> {
                src.setHeight(it);
                this.height = (int)(it / animation.scale);
            }, progress);
        }
    }

    @Override
    public BoxStyle getStyle() {
        return this.style;
    }

    @Override
    @Nullable
    public class_2561 getNarration() {
        if (this.tooltip.isEmpty()) {
            return null;
        }
        String narration = this.tooltip.getNarration();
        if (narration.isEmpty()) {
            return null;
        }
        return class_2561.method_43470((String)narration);
    }

    @Override
    public void setFreeSpace(int width, int height) {
        this.layout.setFreeSpace(width, height);
        this.width = this.layout.method_25368();
        this.height = this.layout.method_25364();
    }

    @Override
    public void method_48206(Consumer<class_339> consumer) {
        this.layout.method_48206(consumer);
    }

    public void setWidgetAlpha(float alpha) {
        if (this.widgets == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.method_48206(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.widgets = builder.build();
        }
        for (class_339 widget : this.widgets) {
            widget.method_25350(alpha);
        }
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        if (this.eventListeners == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (class_4068 renderable : this.renderables) {
                if (!(renderable instanceof class_364)) continue;
                class_364 listener = (class_364)renderable;
                builder.add((Object)listener);
            }
            this.eventListeners = builder.build();
        }
        return this.eventListeners;
    }

    public boolean method_25397() {
        return false;
    }

    public void method_25398(boolean bl) {
    }

    @Nullable
    public class_364 method_25399() {
        return null;
    }

    public void method_25395(@Nullable class_364 guiEventListener) {
    }
}

