/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9848;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.Rect2f;
import snownee.jade.overlay.FloatBlitRenderState;
import snownee.jade.overlay.FloatColoredRectangleRenderState;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.JadeFont;

public class DisplayHelper
implements IDisplayHelper {
    public static final DisplayHelper INSTANCE = new DisplayHelper();
    private static final int MIN_FLUID_HEIGHT = 1;
    private static final Pattern STRIP_COLOR = Pattern.compile("(?i)\u00a7[0-9A-F]");
    public static DecimalFormat dfCommas = new DecimalFormat("0.##");
    public static final DecimalFormat[] dfCommasArray = new DecimalFormat[]{dfCommas, new DecimalFormat("0.#"), new DecimalFormat("0")};
    private static final Supplier<JadeFont> FONT = Suppliers.memoize(() -> new JadeFont(class_310.method_1551().field_1772));

    private static void renderGuiItemDecorations(class_332 graphics, class_327 font, class_1799 stack, int i, int j, @Nullable String text) {
        if (stack.method_7960()) {
            return;
        }
        graphics.method_51448().pushMatrix();
        graphics.method_64860(stack, i, j);
        if (stack.method_7947() != 1 || text != null) {
            String s = text == null ? INSTANCE.humanReadableNumber(stack.method_7947(), "", false, null) : text;
            boolean smaller = s.length() > 3;
            float scale = smaller ? 0.5f : 0.75f;
            int x = smaller ? 32 : 22;
            int y = smaller ? 23 : 13;
            graphics.method_51448().pushMatrix();
            graphics.method_51448().scale(scale);
            int color = IThemeHelper.get().theme().text.itemAmountColor();
            graphics.method_51433(font, s, i + x - font.method_1727(s), j + y, color, true);
            graphics.method_51448().popMatrix();
        }
        graphics.method_51448().popMatrix();
        ClientProxy.renderItemDecorationsExtra(graphics, font, stack, i, j, text);
    }

    public static void fill(class_332 graphics, float minX, float minY, float maxX, float maxY, int color) {
        DisplayHelper.fill(graphics, class_10799.field_56879, minX, minY, maxX, maxY, color);
    }

    public static void fill(class_332 graphics, RenderPipeline renderPipeline, float minX, float minY, float maxX, float maxY, int color) {
        graphics.field_59826.method_70919((class_11244)new FloatColoredRectangleRenderState(renderPipeline, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), minX, minY, maxX, maxY, color, color, graphics.field_44659.method_70863()));
    }

    @Override
    public void drawItem(class_332 graphics, float x, float y, class_1799 stack, float scale, @Nullable String text) {
        if (this.opacity() < 0.5f) {
            return;
        }
        graphics.method_51448().pushMatrix();
        graphics.method_51448().translate(x, y);
        graphics.method_51448().scale(scale);
        graphics.method_51445(stack, 0, 0);
        DisplayHelper.renderGuiItemDecorations(graphics, DisplayHelper.font(), stack, 0, 0, text);
        graphics.method_51448().popMatrix();
    }

    @Override
    public void drawBorder(class_332 graphics, Rect2f rectangle, int width, int color, boolean corner) {
        float minX = rectangle.getX();
        float minY = rectangle.getY();
        float maxX = rectangle.getRight();
        float maxY = rectangle.getBottom();
        DisplayHelper.fill(graphics, minX + (float)width, minY, maxX - (float)width, minY + (float)width, color);
        DisplayHelper.fill(graphics, minX + (float)width, maxY - (float)width, maxX - (float)width, maxY, color);
        if (corner) {
            DisplayHelper.fill(graphics, minX, minY, minX + (float)width, maxY, color);
            DisplayHelper.fill(graphics, maxX - (float)width, minY, maxX, maxY, color);
        } else {
            DisplayHelper.fill(graphics, minX, minY + (float)width, minX + (float)width, maxY - (float)width, color);
            DisplayHelper.fill(graphics, maxX - (float)width, minY + (float)width, maxX, maxY - (float)width, color);
        }
    }

    public void drawFluid(class_332 graphics, float xPosition, float yPosition, JadeFluidObject fluid, float width, float height, long capacityMb) {
        if (fluid.isEmpty()) {
            return;
        }
        long amount = JadeFluidObject.bucketVolume();
        MutableFloat scaledAmount = new MutableFloat((float)amount * height / (float)capacityMb);
        if (amount > 0L && scaledAmount.floatValue() < 1.0f) {
            scaledAmount.setValue(1.0f);
        }
        if (scaledAmount.floatValue() > height) {
            scaledAmount.setValue(height);
        }
        ClientProxy.getFluidSpriteAndColor(fluid, (sprite, color) -> {
            if (sprite == null) {
                float maxY = yPosition + height;
                if (color == -1) {
                    color = -1431655766;
                }
                DisplayHelper.fill(graphics, xPosition, maxY - scaledAmount.floatValue(), xPosition + width, maxY, color);
            } else {
                color = IWailaConfig.Overlay.applyAlpha(color, this.opacity());
                this.blitTiledSprite(graphics, class_10799.field_56883, (class_1058)sprite, xPosition, yPosition, width, height, 0.0f, 0.0f, 16, 16, 16, 16, (int)color);
            }
        });
    }

    public void blitSprite(class_332 graphics, RenderPipeline renderPipeline, class_1058 textureAtlasSprite, float spriteWidth, float spriteHeight, float uStart, float vStart, float uSize, float vSize, float x, float y, float width, float height, int color) {
        if (width == 0.0f || height == 0.0f) {
            return;
        }
        color = IWailaConfig.Overlay.applyAlpha(color, this.opacity());
        this.innerBlit(graphics, renderPipeline, textureAtlasSprite.method_45852(), x, x + width, y, y + height, textureAtlasSprite.method_4580(uStart / spriteWidth), textureAtlasSprite.method_4580((uStart + uSize) / spriteWidth), textureAtlasSprite.method_4570(vStart / spriteHeight), textureAtlasSprite.method_4570((vStart + vSize) / spriteHeight), color);
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli) {
        return this.humanReadableNumber(number, unit, milli, dfCommas);
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli, @Nullable Format formatter) {
        int exp;
        boolean n;
        if (class_3532.method_20390((double)number, (double)0.0)) {
            return "0" + unit;
        }
        StringBuilder sb = new StringBuilder();
        boolean bl = n = number < 0.0;
        if (n) {
            number = -number;
            sb.append('-');
        }
        if (milli && number >= 1000.0) {
            number /= 1000.0;
            milli = false;
        }
        int n2 = exp = formatter == null && number < 10000.0 ? 0 : (int)Math.log10(number) / 3;
        if (exp > 7) {
            exp = 7;
        }
        if (exp > 0) {
            number /= Math.pow(1000.0, exp);
        }
        if (formatter == null) {
            formatter = number < 10.0 ? dfCommasArray[0] : (number < 100.0 ? dfCommasArray[1] : dfCommasArray[2]);
        }
        if (formatter instanceof NumberFormat) {
            NumberFormat numberFormat = (NumberFormat)formatter;
            sb.append(numberFormat.format(number));
        } else {
            sb.append(formatter.format(new Object[]{number}));
        }
        if (exp == 0) {
            if (milli) {
                sb.append('m');
            }
        } else {
            char pre = "kMGTPEZ".charAt(exp - 1);
            sb.append(pre);
        }
        sb.append(unit);
        return sb.toString();
    }

    @Override
    public void drawText(class_332 graphics, String text, float x, float y, int color) {
        this.drawText(graphics, (class_5348)class_2561.method_43470((String)text), x, y, color);
    }

    @Override
    public void drawText(class_332 graphics, class_5348 text, float x, float y, int color) {
        class_5481 sequence;
        if (text instanceof class_2561) {
            class_2561 component = (class_2561)text;
            sequence = component.method_30937();
        } else {
            sequence = class_2477.method_10517().method_30934(text);
        }
        this.drawText(graphics, sequence, x, y, color);
    }

    @Override
    public void drawText(class_332 graphics, class_5481 text, float x, float y, int color) {
        boolean shadow = IWailaConfig.get().overlay().getTheme().text.shadow();
        color = IWailaConfig.Overlay.applyAlpha(color, this.opacity());
        graphics.method_51430(DisplayHelper.font(), text, (int)x, (int)y, color, shadow);
    }

    @Override
    public class_5250 stripColor(class_2561 component) {
        class_5250 mutableComponent = class_2561.method_43473();
        component.method_27658((style, string) -> {
            if (!string.isEmpty()) {
                class_5250 literal = class_2561.method_43470((String)STRIP_COLOR.matcher(string).replaceAll(""));
                literal.method_27696(style.method_27703((class_5251)null));
                mutableComponent.method_10852((class_2561)literal);
            }
            return Optional.empty();
        }, class_2583.field_24360);
        return mutableComponent;
    }

    @Override
    public void blitSprite(class_332 graphics, RenderPipeline renderPipeline, class_2960 sprite, int i, int j, int k, int l) {
        sprite = IThemeHelper.get().theme().mapSprite(sprite);
        graphics.method_52707(renderPipeline, sprite, i, j, k, l, class_9848.method_61317((float)this.opacity()));
    }

    @Override
    public void blitSprite(class_332 graphics, RenderPipeline renderPipeline, class_2960 sprite, int i, int j, int k, int l, int color) {
        color = IWailaConfig.Overlay.applyAlpha(color, this.opacity());
        sprite = IThemeHelper.get().theme().mapSprite(sprite);
        graphics.method_52707(renderPipeline, sprite, i, j, k, l, color);
    }

    @Override
    public void blitSprite(class_332 graphics, RenderPipeline renderPipeline, class_2960 sprite, int spriteWidth, int spriteHeight, int uStart, int vStart, int x, int y, int width, int height) {
        sprite = IThemeHelper.get().theme().mapSprite(sprite);
        graphics.method_70846(renderPipeline, sprite, spriteWidth, spriteHeight, uStart, vStart, x, y, width, height);
    }

    @Override
    public void blitSprite(class_332 graphics, RenderPipeline renderPipeline, class_2960 sprite, int spriteWidth, int spriteHeight, int uStart, int vStart, int x, int y, int width, int height, int color) {
        sprite = IThemeHelper.get().theme().mapSprite(sprite);
        color = IWailaConfig.Overlay.applyAlpha(color, this.opacity());
        graphics.method_52708(renderPipeline, sprite, spriteWidth, spriteHeight, uStart, vStart, x, y, width, height, color);
    }

    public void blitTiledSprite(class_332 graphics, RenderPipeline renderPipeline, class_1058 textureAtlasSprite, float x, float y, float width, float height, float uStart, float vStart, int tileWidth, int tileHeight, int spriteWidth, int spriteHeight, int color) {
        if (width <= 0.0f || height <= 0.0f) {
            return;
        }
        if (tileWidth <= 0 || tileHeight <= 0) {
            throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + tileWidth + "x" + tileHeight);
        }
        int i = 0;
        while ((float)i < width) {
            float u = Math.min((float)tileWidth, width - (float)i);
            int j = 0;
            while ((float)j < height) {
                float w = Math.min((float)tileHeight, height - (float)j);
                this.blitSprite(graphics, renderPipeline, textureAtlasSprite, spriteWidth, spriteHeight, uStart, vStart, u, w, x + (float)i, y + (float)j, u, w, color);
                j += tileHeight;
            }
            i += tileWidth;
        }
    }

    public void blit(class_332 graphics, RenderPipeline renderPipeline, class_2960 resourceLocation, int i, int j, float f, float g, int k, int l, int m, int n, int o) {
        this.blit(graphics, renderPipeline, resourceLocation, i, j, f, g, k, l, k, l, m, n, o);
    }

    public void blit(class_332 graphics, RenderPipeline renderPipeline, class_2960 resourceLocation, int i, int j, float f, float g, int k, int l, int m, int n) {
        this.blit(graphics, renderPipeline, resourceLocation, i, j, f, g, k, l, k, l, m, n);
    }

    public void blit(class_332 graphics, RenderPipeline renderPipeline, class_2960 resourceLocation, int i, int j, float f, float g, int k, int l, int m, int n, int o, int p) {
        this.blit(graphics, renderPipeline, resourceLocation, i, j, f, g, k, l, m, n, o, p, -1);
    }

    public void blit(class_332 graphics, RenderPipeline renderPipeline, class_2960 resourceLocation, int i, int j, float f, float g, int k, int l, int m, int n, int o, int p, int q) {
        this.innerBlit(graphics, renderPipeline, resourceLocation, i, i + k, j, j + l, (f + 0.0f) / (float)o, (f + (float)m) / (float)o, (g + 0.0f) / (float)p, (g + (float)n) / (float)p, q);
    }

    public void blit(class_332 graphics, class_2960 resourceLocation, int i, int j, int k, int l, float f, float g, float h, float m) {
        this.innerBlit(graphics, class_10799.field_56883, resourceLocation, i, k, j, l, f, g, h, m, -1);
    }

    private void innerBlit(class_332 graphics, RenderPipeline renderPipeline, class_2960 sprite, float x0, float x1, float y0, float y1, float u0, float v0, float u1, float v1, int color) {
        GpuTextureView gpuTextureView = class_310.method_1551().method_1531().method_4619(sprite).method_71659();
        this.submitBlit(graphics, renderPipeline, gpuTextureView, x0, y0, x1, y1, u0, v0, u1, v1, color);
    }

    private void submitBlit(class_332 graphics, RenderPipeline renderPipeline, GpuTextureView gpuTextureView, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, int color) {
        graphics.field_59826.method_70919((class_11244)new FloatBlitRenderState(renderPipeline, class_11231.method_70900((GpuTextureView)gpuTextureView), new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), x0, y0, x1, y1, u0, v0, u1, v1, color, graphics.field_44659.method_70863()));
    }

    @Override
    public float opacity() {
        return OverlayRenderer.animation.alpha;
    }

    @Override
    public float backgroundOpacity() {
        return OverlayRenderer.animation.showHideAlpha;
    }

    public static class_327 font() {
        return FONT.get();
    }

    public void blitSprite(class_332 graphics, RenderPipeline renderPipeline, class_2960 sprite, int spriteWidth, int spriteHeight, int u0, int v0, float x, float y, float width, float height, int color) {
        if (width == 0.0f || height == 0.0f) {
            return;
        }
        color = IWailaConfig.Overlay.applyAlpha(color, this.opacity());
        sprite = IThemeHelper.get().theme().mapSprite(sprite);
        class_1058 textureAtlasSprite = class_310.method_1551().method_52699().method_18667(sprite);
        this.blitSprite(graphics, renderPipeline, textureAtlasSprite, spriteWidth, spriteHeight, u0, v0, width, height, x, y, width, height, color);
    }

    static {
        for (DecimalFormat format : dfCommasArray) {
            format.setRoundingMode(RoundingMode.DOWN);
        }
    }
}

