/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.animation;

import com.zurrtum.create.client.catnip.animation.Force;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class PhysicalFloat {
    float previousValue;
    float value;
    float previousSpeed;
    float speed;
    float limit = Float.NaN;
    float mass;
    private final ArrayList<Force> forces = new ArrayList();

    public static PhysicalFloat create() {
        return new PhysicalFloat(1.0f);
    }

    public static PhysicalFloat create(float mass) {
        return new PhysicalFloat(mass);
    }

    public PhysicalFloat(float mass) {
        this.mass = mass;
    }

    public PhysicalFloat startAt(double value) {
        this.previousValue = this.value = (float)value;
        return this;
    }

    public PhysicalFloat withDrag(double drag) {
        return this.addForce(new Force.Drag((float)drag));
    }

    public PhysicalFloat zeroing(double g) {
        return this.addForce(new Force.Zeroing((float)g));
    }

    public PhysicalFloat withLimit(float limit) {
        this.limit = limit;
        return this;
    }

    public void tick() {
        this.previousSpeed = this.speed;
        this.previousValue = this.value;
        float totalImpulse = 0.0f;
        for (Force force : this.forces) {
            totalImpulse += force.get(this.mass, this.value, this.speed) / this.mass;
        }
        this.speed += totalImpulse;
        this.forces.removeIf(Force::finished);
        if (Float.isFinite(this.limit)) {
            this.speed = class_3532.method_15363((float)this.speed, (float)(-this.limit), (float)this.limit);
        }
        this.value += this.speed;
    }

    public PhysicalFloat addForce(Force f) {
        this.forces.add(f);
        return this;
    }

    public PhysicalFloat bump(double force) {
        return this.addForce(new Force.Impulse((float)force));
    }

    public PhysicalFloat bump(int time, double force) {
        return this.addForce(new Force.OverTime(time, (float)force));
    }

    public float getValue() {
        return this.getValue(1.0f);
    }

    public float getValue(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.previousValue, (float)this.value);
    }
}

