/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.gui.render.ItemTransformRenderState;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class ItemTransformElementRenderer
extends class_11239<ItemTransformRenderState> {
    private static final Map<Object, GpuTexture> TEXTURES = new HashMap<Object, GpuTexture>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public ItemTransformElementRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(Object key) {
        GpuTexture texture = TEXTURES.remove(key);
        if (texture != null) {
            texture.close();
        }
    }

    public void render(ItemTransformRenderState item, class_11246 state, int windowScaleFactor) {
        boolean draw;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        float size = item.size() * (float)windowScaleFactor;
        Object key = item.getKey();
        GpuTexture texture = TEXTURES.get(key);
        if (texture == null) {
            texture = GpuTexture.create((int)size);
            TEXTURES.put(key, texture);
            draw = true;
        } else {
            draw = item.state().method_70948();
        }
        if (draw) {
            RenderSystem.setProjectionMatrix((GpuBufferSlice)this.field_60042.method_71092(size, size), (class_10366)class_10366.field_54954);
            texture.prepare();
            this.matrices.method_22903();
            this.matrices.method_46416(size / 2.0f, size / 2.0f, 0.0f);
            if (item.padding() != 0) {
                size -= (float)(item.padding() * windowScaleFactor);
            }
            this.matrices.method_22905(size, -size, size);
            if (item.zRot() != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(item.zRot()));
            }
            if (item.xRot() != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(item.xRot()));
            }
            if (item.yRot() != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(item.yRot()));
            }
            boolean blockLight = item.state().method_65608();
            class_308 lighting = class_310.method_1551().field_1773.method_71114();
            if (blockLight) {
                lighting.method_71034(class_308.class_11274.field_60027);
            } else {
                lighting.method_71034(class_308.class_11274.field_60026);
            }
            item.state().method_65604(this.matrices, (class_4597)this.field_59933, 0xF000F0, class_4608.field_21444);
            this.field_59933.method_22993();
            this.matrices.method_22909();
            texture.clear();
        }
        state.method_71996(new class_11241(class_10799.field_59968, class_11231.method_70900((GpuTextureView)texture.textureView()), item.method_72127(), item.comp_4122(), item.comp_4123(), item.comp_4124(), item.comp_4125(), 0.0f, 1.0f, 1.0f, 0.0f, -1, item.scissor(), null));
    }

    protected void render(ItemTransformRenderState item, class_4587 matrices) {
    }

    protected String method_70906() {
        return "Item Transform";
    }

    public Class<ItemTransformRenderState> method_70903() {
        return ItemTransformRenderState.class;
    }
}

