/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.steamEngine;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SteamEngineRenderer
extends SafeBlockEntityRenderer<SteamEngineBlockEntity> {
    public SteamEngineRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(SteamEngineBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            return;
        }
        Float angle = SteamEngineRenderer.getTargetAngle(be);
        if (angle == null) {
            return;
        }
        class_2680 blockState = be.method_11010();
        class_2350 facing = SteamEngineBlock.getFacing(blockState);
        class_2350.class_2351 facingAxis = facing.method_10166();
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        PoweredShaftBlockEntity shaft = be.getShaft();
        if (shaft != null) {
            axis = KineticBlockEntityRenderer.getRotationAxisOf(shaft);
        }
        boolean roll90 = facingAxis.method_10179() && axis == class_2350.class_2351.field_11052 || facingAxis.method_10178() && axis == class_2350.class_2351.field_11051;
        float piston = 0.375f * class_3532.method_15374((float)angle.floatValue()) - class_3532.method_15355((float)(class_3532.method_27285((float)0.875f) - class_3532.method_27285((float)0.375f) * class_3532.method_27285((float)class_3532.method_15362((float)angle.floatValue()))));
        float distance = class_3532.method_15355((float)class_3532.method_27285((float)(piston - 0.375f * class_3532.method_15374((float)angle.floatValue()))));
        float angle2 = (float)Math.acos(distance / 0.875f) * (class_3532.method_15362((float)angle.floatValue()) >= 0.0f ? 1.0f : -1.0f);
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        ((SuperByteBuffer)this.transformed(AllPartialModels.ENGINE_PISTON, blockState, facing, roll90).translate(0.0f, piston + 1.25f, 0.0f)).light(light).renderInto(ms, vb);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.transformed(AllPartialModels.ENGINE_LINKAGE, blockState, facing, roll90).center()).translate(0.0f, 1.0f, 0.0f)).uncenter()).translate(0.0f, piston + 1.25f, 0.0f)).translate(0.0f, 0.25f, 0.5f)).rotateX(angle2)).translate(0.0f, -0.25f, -0.5f)).light(light).renderInto(ms, vb);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.transformed(AllPartialModels.ENGINE_CONNECTOR, blockState, facing, roll90).translate(0.0f, 2.0f, 0.0f)).center()).rotateX(-(angle.floatValue() + 1.5707964f))).uncenter()).light(light).renderInto(ms, vb);
    }

    private SuperByteBuffer transformed(PartialModel model, class_2680 blockState, class_2350 facing, boolean roll90) {
        return (SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial(model, blockState).center()).rotateYDegrees(AngleHelper.horizontalAngle(facing))).rotateXDegrees(AngleHelper.verticalAngle(facing) + 90.0f)).rotateYDegrees(roll90 ? -90.0f : 0.0f)).uncenter();
    }

    public int method_33893() {
        return 128;
    }

    @Nullable
    public static Float getTargetAngle(SteamEngineBlockEntity be) {
        class_2680 blockState = be.method_11010();
        if (!blockState.method_27852((class_2248)AllBlocks.STEAM_ENGINE)) {
            return null;
        }
        class_2350 facing = SteamEngineBlock.getFacing(blockState);
        PoweredShaftBlockEntity shaft = be.getShaft();
        class_2350.class_2351 facingAxis = facing.method_10166();
        if (shaft == null) {
            return null;
        }
        class_2350.class_2351 axis = KineticBlockEntityRenderer.getRotationAxisOf(shaft);
        float angle = KineticBlockEntityRenderer.getAngleForBe(shaft, shaft.method_11016(), axis);
        if (axis == facingAxis) {
            return null;
        }
        if (axis.method_10179() && facingAxis == class_2350.class_2351.field_11048 ^ facing.method_10171() == class_2350.class_2352.field_11056) {
            angle *= -1.0f;
        }
        if (axis == class_2350.class_2351.field_11048 && facing == class_2350.field_11033) {
            angle *= -1.0f;
        }
        return Float.valueOf(angle);
    }
}

