/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.indirect;

import com.zurrtum.create.client.flywheel.backend.engine.AbstractArena;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.ResizableStorageBuffer;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.StagingBuffer;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import java.util.Arrays;
import java.util.BitSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class ObjectStorage
extends AbstractArena {
    public static final int LOG_2_PAGE_SIZE = 5;
    public static final int PAGE_SIZE = 32;
    public static final int PAGE_MASK = 31;
    public static final int INVALID_PAGE = -1;
    public static final int INITIAL_PAGES_ALLOCATED = 4;
    public static final int DESCRIPTOR_SIZE_BYTES = 8;
    private final BitSet changedFrames = new BitSet();
    public final ResizableStorageBuffer objectBuffer = new ResizableStorageBuffer();
    public final ResizableStorageBuffer frameDescriptorBuffer = new ResizableStorageBuffer();
    private MemoryBlock frameDescriptors;

    public ObjectStorage(long objectSizeBytes) {
        super(32L * objectSizeBytes);
        this.objectBuffer.ensureCapacity(4L * this.elementSizeBytes);
        this.frameDescriptorBuffer.ensureCapacity(32L);
        this.frameDescriptors = MemoryBlock.malloc(32L);
    }

    public Mapping createMapping() {
        return new Mapping();
    }

    @Override
    public long byteCapacity() {
        return this.objectBuffer.capacity();
    }

    @Override
    public void free(int i) {
        if (i == -1) {
            return;
        }
        super.free(i);
        long ptr = this.ptrForPage(i);
        MemoryUtil.memPutInt((long)ptr, (int)0);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)0);
        this.changedFrames.set(i);
    }

    private void set(int i, int modelIndex, int validBits) {
        long ptr = this.ptrForPage(i);
        MemoryUtil.memPutInt((long)ptr, (int)modelIndex);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)validBits);
        this.changedFrames.set(i);
    }

    @Override
    protected void grow() {
        this.objectBuffer.ensureCapacity(this.objectBuffer.capacity() * 2L);
        this.frameDescriptorBuffer.ensureCapacity(this.frameDescriptorBuffer.capacity() * 2L);
        this.frameDescriptors = this.frameDescriptors.realloc(this.frameDescriptors.size() * 2L);
    }

    public void uploadDescriptors(StagingBuffer stagingBuffer) {
        if (this.changedFrames.isEmpty()) {
            return;
        }
        long ptr = this.frameDescriptors.ptr();
        int i = this.changedFrames.nextSetBit(0);
        while (i >= 0 && i < this.capacity()) {
            long offset = (long)i * 8L;
            stagingBuffer.enqueueCopy(ptr + offset, 8L, this.frameDescriptorBuffer.handle(), offset);
            i = this.changedFrames.nextSetBit(i + 1);
        }
        this.changedFrames.clear();
    }

    public void delete() {
        this.objectBuffer.delete();
        this.frameDescriptorBuffer.delete();
        this.frameDescriptors.free();
    }

    private long ptrForPage(int page) {
        return this.frameDescriptors.ptr() + (long)page * 8L;
    }

    public static int objectIndex2PageIndex(int objectIndex) {
        return objectIndex >> 5;
    }

    public static int pageIndex2ObjectIndex(int pageIndex) {
        return pageIndex << 5;
    }

    @Environment(value=EnvType.CLIENT)
    public class Mapping {
        private static final int[] EMPTY_ALLOCATION = new int[0];
        private int[] pages = EMPTY_ALLOCATION;

        public void updatePage(int index, int modelIndex, int validBits) {
            if (validBits == 0) {
                this.holePunch(index);
                return;
            }
            int frame = this.pages[index];
            if (frame == -1) {
                frame = this.unHolePunch(index);
            }
            ObjectStorage.this.set(frame, modelIndex, validBits);
        }

        public void holePunch(int index) {
            ObjectStorage.this.free(this.pages[index]);
            this.pages[index] = -1;
        }

        private int unHolePunch(int index) {
            int page;
            this.pages[index] = page = ObjectStorage.this.alloc();
            return page;
        }

        public void updateCount(int newLength) {
            int oldLength = this.pages.length;
            if (oldLength > newLength) {
                this.shrink(oldLength, newLength);
            } else if (oldLength < newLength) {
                this.grow(newLength, oldLength);
            }
        }

        public int pageCount() {
            return this.pages.length;
        }

        public long page2ByteOffset(int index) {
            return ObjectStorage.this.byteOffsetOf(this.pages[index]);
        }

        public void delete() {
            for (int page : this.pages) {
                ObjectStorage.this.free(page);
            }
            this.pages = EMPTY_ALLOCATION;
        }

        private void grow(int neededPages, int oldLength) {
            this.pages = Arrays.copyOf(this.pages, neededPages);
            for (int i = oldLength; i < neededPages; ++i) {
                int page;
                this.pages[i] = page = ObjectStorage.this.alloc();
            }
        }

        private void shrink(int oldLength, int neededPages) {
            for (int i = oldLength - 1; i >= neededPages; --i) {
                int page = this.pages[i];
                ObjectStorage.this.free(page);
            }
            this.pages = Arrays.copyOf(this.pages, neededPages);
        }

        public int objectIndex2GlobalIndex(int objectIndex) {
            return (this.pages[ObjectStorage.objectIndex2PageIndex(objectIndex)] << 5) + (objectIndex & 0x1F);
        }
    }
}

