/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.steamEngine;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class SteamEngineBlockEntity
extends SmartBlockEntity {
    protected ServerScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public WeakReference<PoweredShaftBlockEntity> target;
    public WeakReference<FluidTankBlockEntity> source = new WeakReference<Object>(null);
    public float prevAngle = 0.0f;

    public SteamEngineBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.STEAM_ENGINE, pos, state);
        this.target = new WeakReference<Object>(null);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.movementDirection = new ServerScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection>(WindmillBearingBlockEntity.RotationDirection.class, this);
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add(this.movementDirection);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.STEAM_ENGINE);
    }

    private void onDirectionChanged() {
    }

    @Override
    public void tick() {
        int conveyedSpeedLevel;
        float efficiency;
        super.tick();
        FluidTankBlockEntity tank = this.getTank();
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (tank == null || shaft == null || !this.isValid()) {
            if (this.field_11863.method_8608()) {
                return;
            }
            if (shaft == null) {
                return;
            }
            if (!shaft.method_11016().method_10059((class_2382)this.field_11867).equals((Object)shaft.enginePos)) {
                return;
            }
            if (shaft.engineEfficiency == 0.0f) {
                return;
            }
            class_2350 facing = SteamEngineBlock.getFacing(this.method_11010());
            if (this.field_11863.method_8477(this.field_11867.method_10093(facing.method_10153()))) {
                shaft.update(this.field_11867, 0, 0.0f);
            }
            return;
        }
        class_2680 shaftState = shaft.method_11010();
        class_2350.class_2351 targetAxis = class_2350.class_2351.field_11048;
        class_2248 class_22482 = shaftState.method_26204();
        if (class_22482 instanceof IRotate) {
            IRotate ir = (IRotate)class_22482;
            targetAxis = ir.getRotationAxis(shaftState);
        }
        boolean verticalTarget = targetAxis == class_2350.class_2351.field_11052;
        class_2680 blockState = this.method_11010();
        if (!blockState.method_27852((class_2248)AllBlocks.STEAM_ENGINE)) {
            return;
        }
        class_2350 facing = SteamEngineBlock.getFacing(blockState);
        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            facing = (class_2350)blockState.method_11654((class_2769)SteamEngineBlock.field_11177);
        }
        if ((efficiency = class_3532.method_15363((float)tank.boiler.getEngineEfficiency(tank.getTotalTankSize()), (float)0.0f, (float)1.0f)) > 0.0f) {
            this.award(AllAdvancements.STEAM_ENGINE);
        }
        int n = efficiency == 0.0f ? 1 : (conveyedSpeedLevel = verticalTarget ? 1 : (int)GeneratingKineticBlockEntity.convertToDirection(1.0f, facing));
        if (targetAxis == class_2350.class_2351.field_11051) {
            conveyedSpeedLevel *= -1;
        }
        if (this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.COUNTER_CLOCKWISE) {
            conveyedSpeedLevel *= -1;
        }
        float shaftSpeed = shaft.getTheoreticalSpeed();
        if (shaft.hasSource() && shaftSpeed != 0.0f && conveyedSpeedLevel != 0 && shaftSpeed > 0.0f != conveyedSpeedLevel > 0) {
            this.movementDirection.setValue(1 - this.movementDirection.get().ordinal());
            conveyedSpeedLevel *= -1;
        }
        shaft.update(this.field_11867, conveyedSpeedLevel, efficiency);
        if (!this.field_11863.field_9236) {
            return;
        }
        AllClientHandle.INSTANCE.spawnSteamEngineParticles(this);
    }

    @Override
    public void remove() {
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (shaft != null) {
            shaft.remove(this.field_11867);
        }
        super.remove();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(2.0);
    }

    public PoweredShaftBlockEntity getShaft() {
        PoweredShaftBlockEntity shaft = (PoweredShaftBlockEntity)this.target.get();
        if (shaft == null || shaft.method_11015() || !shaft.canBePoweredBy(this.field_11867)) {
            PoweredShaftBlockEntity ps;
            class_2350 facing;
            class_2586 anyShaftAt;
            if (shaft != null) {
                this.target = new WeakReference<Object>(null);
            }
            if ((anyShaftAt = this.field_11863.method_8321(this.field_11867.method_10079(facing = SteamEngineBlock.getFacing(this.method_11010()), 2))) instanceof PoweredShaftBlockEntity && (ps = (PoweredShaftBlockEntity)anyShaftAt).canBePoweredBy(this.field_11867)) {
                shaft = ps;
                this.target = new WeakReference<PoweredShaftBlockEntity>(shaft);
            }
        }
        return shaft;
    }

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.source.get();
        if (tank == null || tank.method_11015()) {
            class_2350 facing;
            class_2586 be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.field_11863.method_8321(this.field_11867.method_10093((facing = SteamEngineBlock.getFacing(this.method_11010())).method_10153()))) instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tankBe;
                tank = tankBe = (FluidTankBlockEntity)be;
                this.source = new WeakReference<FluidTankBlockEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerBE();
    }

    public boolean isValid() {
        class_2350 dir = SteamEngineBlock.getConnectedDirection(this.method_11010()).method_10153();
        class_1937 level = this.method_10997();
        if (level == null) {
            return false;
        }
        return level.method_8320(this.method_11016().method_10093(dir)).method_27852((class_2248)AllBlocks.FLUID_TANK);
    }
}

