/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.item.filter.attribute.attributes;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItemAttributeTypes;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public record BookCopyAttribute(int generation) implements ItemAttribute
{
    public static final MapCodec<BookCopyAttribute> CODEC = class_5699.field_33441.xmap(BookCopyAttribute::new, BookCopyAttribute::generation).fieldOf("value");
    public static final class_9139<ByteBuf, BookCopyAttribute> PACKET_CODEC = class_9135.field_49675.method_56432(BookCopyAttribute::new, BookCopyAttribute::generation);

    private static int extractGeneration(class_1799 stack) {
        if (stack.method_57826(class_9334.field_49606)) {
            return ((class_9302)stack.method_58694(class_9334.field_49606)).comp_2421();
        }
        return -1;
    }

    @Override
    public boolean appliesTo(class_1799 itemStack, class_1937 level) {
        return BookCopyAttribute.extractGeneration(itemStack) == this.generation;
    }

    @Override
    public String getTranslationKey() {
        return switch (this.generation) {
            case 0 -> "book_copy_original";
            case 1 -> "book_copy_first";
            case 2 -> "book_copy_second";
            default -> "book_copy_tattered";
        };
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.BOOK_COPY;
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new BookCopyAttribute(-1);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            int generation = BookCopyAttribute.extractGeneration(stack);
            if (generation >= 0) {
                list.add(new BookCopyAttribute(generation));
            }
            return list;
        }

        @Override
        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        @Override
        public class_9139<? super class_9129, ? extends ItemAttribute> packetCodec() {
            return PACKET_CODEC;
        }
    }
}

