/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packagerLink;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class RequestPromiseQueue {
    public static final Codec<RequestPromiseQueue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(RequestPromise.CODEC).fieldOf("List").forGetter(i -> i.flatten(false))).apply((Applicative)instance, RequestPromiseQueue::new));
    private final Map<class_1792, List<RequestPromise>> promisesByItem = new IdentityHashMap<class_1792, List<RequestPromise>>();
    private Runnable onChanged;

    public RequestPromiseQueue(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    private RequestPromiseQueue(List<RequestPromise> list) {
        this((Runnable)null);
        list.forEach(promise -> this.promisesByItem.computeIfAbsent(promise.promisedStack.stack.method_7909(), $ -> new LinkedList()).add(promise));
    }

    public void add(RequestPromise promise) {
        this.promisesByItem.computeIfAbsent(promise.promisedStack.stack.method_7909(), $ -> new LinkedList()).add(promise);
        this.onChanged.run();
    }

    public void setOnChanged(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    public int getTotalPromisedAndRemoveExpired(class_1799 stack, int expiryTime) {
        int promised = 0;
        List<RequestPromise> list = this.promisesByItem.get(stack.method_7909());
        if (list == null) {
            return promised;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = iterator.next();
            if (!class_1799.method_31577((class_1799)promise.promisedStack.stack, (class_1799)stack)) continue;
            if (expiryTime != -1 && promise.ticksExisted >= expiryTime) {
                iterator.remove();
                this.onChanged.run();
                continue;
            }
            promised += promise.promisedStack.count;
        }
        return promised;
    }

    public void forceClear(class_1799 stack) {
        List<RequestPromise> list = this.promisesByItem.get(stack.method_7909());
        if (list == null) {
            return;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = iterator.next();
            if (!class_1799.method_31577((class_1799)promise.promisedStack.stack, (class_1799)stack)) continue;
            iterator.remove();
            this.onChanged.run();
        }
        if (list.isEmpty()) {
            this.promisesByItem.remove(stack.method_7909());
        }
    }

    public void itemEnteredSystem(class_1799 stack, int amount) {
        List<RequestPromise> list = this.promisesByItem.get(stack.method_7909());
        if (list == null) {
            return;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise requestPromise = iterator.next();
            if (!class_1799.method_31577((class_1799)requestPromise.promisedStack.stack, (class_1799)stack)) continue;
            int toSubtract = Math.min(amount, requestPromise.promisedStack.count);
            amount -= toSubtract;
            requestPromise.promisedStack.count -= toSubtract;
            if (requestPromise.promisedStack.count <= 0) {
                iterator.remove();
                this.onChanged.run();
            }
            if (amount > 0) continue;
            break;
        }
        if (list.isEmpty()) {
            this.promisesByItem.remove(stack.method_7909());
        }
    }

    public List<RequestPromise> flatten(boolean sorted) {
        ArrayList<RequestPromise> all = new ArrayList<RequestPromise>();
        this.promisesByItem.forEach((key, list) -> all.addAll((Collection<RequestPromise>)list));
        if (sorted) {
            all.sort(RequestPromise.ageComparator());
        }
        return all;
    }

    public void tick() {
        this.promisesByItem.forEach((key, list) -> list.forEach(RequestPromise::tick));
    }

    public boolean isEmpty() {
        return this.promisesByItem.isEmpty();
    }
}

