/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.tunnel;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.levelWrappers.WrappedLevel;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelShapes;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import java.util.Locale;
import net.minecraft.class_10225;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class BeltTunnelBlock
extends class_2248
implements IBE<BeltTunnelBlockEntity>,
ItemInventoryProvider<BeltTunnelBlockEntity>,
NeighborUpdateListeningBlock,
IWrenchable {
    public static final class_2754<Shape> SHAPE = class_2754.method_11850((String)"shape", Shape.class);
    public static final class_2754<class_2350.class_2351> HORIZONTAL_AXIS = class_2741.field_12529;

    public BeltTunnelBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)this.method_9564().method_11657(SHAPE, (Comparable)((Object)Shape.STRAIGHT)));
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, BeltTunnelBlockEntity blockEntity, class_2350 context) {
        class_1263 capBelow;
        class_2586 beBelow;
        class_2680 downState;
        if (blockEntity.cap == null && (downState = world.method_8320(pos.method_10074())).method_27852((class_2248)AllBlocks.BELT) && (beBelow = world.method_8321(pos.method_10074())) != null && (capBelow = AllBlocks.BELT.getInventory(world, pos.method_10074(), downState, (BeltBlockEntity)beBelow, class_2350.field_11036)) != null) {
            blockEntity.cap = capBelow;
        }
        return blockEntity.cap;
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return BeltTunnelShapes.getShape(state);
    }

    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        class_2680 blockState = worldIn.method_8320(pos.method_10074());
        if (!this.isValidPositionForPlacement(state, worldIn, pos)) {
            return false;
        }
        return (Boolean)blockState.method_11654((class_2769)BeltBlock.CASING);
    }

    public boolean isValidPositionForPlacement(class_2680 state, class_4538 worldIn, class_2338 pos) {
        class_2680 blockState = worldIn.method_8320(pos.method_10074());
        if (!blockState.method_27852((class_2248)AllBlocks.BELT)) {
            return false;
        }
        return blockState.method_11654(BeltBlock.SLOPE) == BeltSlope.HORIZONTAL;
    }

    public static boolean hasWindow(class_2680 state) {
        return state.method_11654(SHAPE) == Shape.WINDOW || state.method_11654(SHAPE) == Shape.CLOSED;
    }

    public static boolean isStraight(class_2680 state) {
        return BeltTunnelBlock.hasWindow(state) || state.method_11654(SHAPE) == Shape.STRAIGHT;
    }

    public static boolean isJunction(class_2680 state) {
        Shape shape = (Shape)((Object)state.method_11654(SHAPE));
        return shape == Shape.CROSS || shape == Shape.T_LEFT || shape == Shape.T_RIGHT;
    }

    public class_2680 method_9605(class_1750 context) {
        return this.getTunnelState((class_1922)context.method_8045(), context.method_8037());
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 p_220082_4_, boolean p_220082_5_) {
        if (!(world instanceof WrappedLevel) && !world.method_8608()) {
            this.withBlockEntityDo((class_1922)world, pos, BeltTunnelBlockEntity::updateTunnelConnections);
        }
    }

    public class_2680 method_9559(class_2680 state, class_4538 worldIn, class_10225 tickView, class_2338 currentPos, class_2350 facing, class_2338 facingPos, class_2680 facingState, class_5819 random) {
        class_2680 tunnelState;
        if (facing.method_10166().method_10178()) {
            return state;
        }
        if (!(worldIn instanceof WrappedLevel) && !worldIn.method_8608()) {
            this.withBlockEntityDo((class_1922)worldIn, currentPos, BeltTunnelBlockEntity::updateTunnelConnections);
        }
        if ((tunnelState = this.getTunnelState((class_1922)worldIn, currentPos)).method_11654(HORIZONTAL_AXIS) == state.method_11654(HORIZONTAL_AXIS) && BeltTunnelBlock.hasWindow(tunnelState) == BeltTunnelBlock.hasWindow(state)) {
            return state;
        }
        return tunnelState;
    }

    public void updateTunnel(class_1936 world, class_2338 pos) {
        class_2680 newTunnel;
        class_2680 tunnel = world.method_8320(pos);
        if (tunnel != (newTunnel = this.getTunnelState((class_1922)world, pos)) && !world.method_8608()) {
            world.method_8652(pos, newTunnel, 3);
            class_2586 be = world.method_8321(pos);
            if (be instanceof BeltTunnelBlockEntity) {
                ((BeltTunnelBlockEntity)be).updateTunnelConnections();
            }
        }
    }

    private class_2680 getTunnelState(class_1922 reader, class_2338 pos) {
        boolean canHaveWindow;
        class_2680 state = this.method_9564();
        class_2680 belt = reader.method_8320(pos.method_10074());
        if (belt.method_27852((class_2248)AllBlocks.BELT)) {
            state = (class_2680)state.method_11657(HORIZONTAL_AXIS, (Comparable)((class_2350)belt.method_11654((class_2769)BeltBlock.HORIZONTAL_FACING)).method_10166());
        }
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(HORIZONTAL_AXIS);
        class_2350 left = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis).method_10170();
        boolean onLeft = this.hasValidOutput(reader, pos.method_10074(), left);
        boolean onRight = this.hasValidOutput(reader, pos.method_10074(), left.method_10153());
        if (onLeft && onRight) {
            state = (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.CROSS));
        } else if (onLeft) {
            state = (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.T_LEFT));
        } else if (onRight) {
            state = (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.T_RIGHT));
        }
        if (state.method_11654(SHAPE) == Shape.STRAIGHT && (canHaveWindow = this.canHaveWindow(reader, pos, axis))) {
            state = (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.WINDOW));
        }
        return state;
    }

    protected boolean canHaveWindow(class_1922 reader, class_2338 pos, class_2350.class_2351 axis) {
        class_2350 fw = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        class_2680 blockState1 = reader.method_8320(pos.method_10093(fw));
        class_2680 blockState2 = reader.method_8320(pos.method_10093(fw.method_10153()));
        boolean funnel1 = blockState1.method_26204() instanceof BeltFunnelBlock && blockState1.method_11654(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && blockState1.method_11654((class_2769)BeltFunnelBlock.HORIZONTAL_FACING) == fw.method_10153();
        boolean funnel2 = blockState2.method_26204() instanceof BeltFunnelBlock && blockState2.method_11654(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && blockState2.method_11654((class_2769)BeltFunnelBlock.HORIZONTAL_FACING) == fw;
        boolean valid1 = blockState1.method_26204() instanceof BeltTunnelBlock || funnel1;
        boolean valid2 = blockState2.method_26204() instanceof BeltTunnelBlock || funnel2;
        boolean canHaveWindow = valid1 && valid2 && (!funnel1 || !funnel2);
        return canHaveWindow;
    }

    private boolean hasValidOutput(class_1922 world, class_2338 pos, class_2350 side) {
        class_2680 blockState = world.method_8320(pos.method_10093(side));
        if (blockState.method_27852((class_2248)AllBlocks.BELT)) {
            return ((class_2350)blockState.method_11654((class_2769)BeltBlock.HORIZONTAL_FACING)).method_10166() == side.method_10166();
        }
        DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get(world, pos.method_10093(side), DirectBeltInputBehaviour.TYPE);
        return behaviour != null && behaviour.canInsertFromSide(side);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (!BeltTunnelBlock.hasWindow(state)) {
            return class_1269.field_5811;
        }
        Shape shape = (Shape)((Object)state.method_11654(SHAPE));
        shape = shape == Shape.CLOSED ? Shape.WINDOW : Shape.CLOSED;
        class_1937 world = context.method_8045();
        if (!world.field_9236) {
            world.method_8652(context.method_8037(), (class_2680)state.method_11657(SHAPE, (Comparable)((Object)shape)), 2);
        }
        return class_1269.field_5812;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        class_2350 fromAxis = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)((class_2350.class_2351)state.method_11654(HORIZONTAL_AXIS)));
        class_2350 rotated = rotation.method_10503(fromAxis);
        return (class_2680)state.method_11657(HORIZONTAL_AXIS, (Comparable)rotated.method_10166());
    }

    @Override
    public void neighborUpdate(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 sourceBlock, class_2338 fromPos, boolean isMoving) {
        if (worldIn.field_9236) {
            return;
        }
        if (fromPos.equals((Object)pos.method_10074()) && !this.method_9558(state, (class_4538)worldIn, pos)) {
            worldIn.method_22352(pos, true);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HORIZONTAL_AXIS, SHAPE});
        super.method_9515(builder);
    }

    @Override
    public Class<BeltTunnelBlockEntity> getBlockEntityClass() {
        return BeltTunnelBlockEntity.class;
    }

    @Override
    public class_2591<? extends BeltTunnelBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ANDESITE_TUNNEL;
    }

    public static enum Shape implements class_3542
    {
        STRAIGHT,
        WINDOW,
        CLOSED,
        T_LEFT,
        T_RIGHT,
        CROSS;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

