/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.tunnel;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import com.zurrtum.create.content.logistics.tunnel.BrassTunnelBlock;
import com.zurrtum.create.content.logistics.tunnel.BrassTunnelItemHandler;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerSidedFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class BrassTunnelBlockEntity
extends BeltTunnelBlockEntity {
    ServerSidedFilteringBehaviour filtering;
    boolean connectedLeft;
    boolean connectedRight;
    class_1799 stackToDistribute;
    class_2350 stackEnteredFrom = null;
    float distributionProgress;
    int distributionDistanceLeft;
    int distributionDistanceRight;
    int previousOutputIndex = 0;
    Couple<List<Pair<class_2338, class_2350>>> distributionTargets = Couple.create(ArrayList::new);
    private boolean newItemArrived;
    private boolean syncedOutputActive = false;
    private Set<BrassTunnelBlockEntity> syncSet = new HashSet<BrassTunnelBlockEntity>();
    protected ServerScrollOptionBehaviour<SelectionMode> selectionMode;
    private class_1263 beltCapability = null;
    public class_1263 tunnelCapability;
    private static Map<Pair<BrassTunnelBlockEntity, class_2350>, class_1799> distributed = new IdentityHashMap<Pair<BrassTunnelBlockEntity, class_2350>, class_1799>();
    private static Set<Pair<BrassTunnelBlockEntity, class_2350>> full = new HashSet<Pair<BrassTunnelBlockEntity, class_2350>>();

    public BrassTunnelBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.BRASS_TUNNEL, pos, state);
        this.stackToDistribute = class_1799.field_8037;
        this.tunnelCapability = new BrassTunnelItemHandler(this);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ServerScrollOptionBehaviour<SelectionMode>(SelectionMode.class, this);
        behaviours.add(this.selectionMode);
        this.selectionMode.withCallback(setting -> {
            for (boolean side : Iterate.trueAndFalse) {
                BrassTunnelBlockEntity adjacent;
                if (!this.isConnected(side) || (adjacent = this.getAdjacent(side)) == null) continue;
                adjacent.selectionMode.setValue((int)setting);
            }
        });
    }

    @Override
    public void tick() {
        super.tick();
        BeltBlockEntity beltBelow = BeltHelper.getSegmentBE((class_1936)this.field_11863, this.field_11867.method_10074());
        if (this.distributionProgress > 0.0f) {
            this.distributionProgress -= 1.0f;
        }
        if (beltBelow == null || beltBelow.getSpeed() == 0.0f) {
            return;
        }
        if (this.stackToDistribute.method_7960() && !this.syncedOutputActive) {
            return;
        }
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (this.distributionProgress == -1.0f) {
            this.distributionTargets.forEach(List::clear);
            this.distributionDistanceLeft = 0;
            this.distributionDistanceRight = 0;
            this.syncSet.clear();
            List<Pair<BrassTunnelBlockEntity, class_2350>> validOutputs = this.gatherValidOutputs();
            if (this.selectionMode.get() == SelectionMode.SYNCHRONIZE) {
                boolean notifySyncedOut;
                boolean allEmpty = true;
                boolean allFull = true;
                for (BrassTunnelBlockEntity be2 : this.syncSet) {
                    boolean hasStack = !be2.stackToDistribute.method_7960();
                    allEmpty &= !hasStack;
                    allFull &= hasStack;
                }
                boolean bl = notifySyncedOut = !allEmpty;
                if (allFull || allEmpty) {
                    this.syncSet.forEach(be -> {
                        be.syncedOutputActive = notifySyncedOut;
                    });
                }
            }
            if (validOutputs == null) {
                return;
            }
            if (this.stackToDistribute.method_7960()) {
                return;
            }
            for (Pair<BrassTunnelBlockEntity, class_2350> pair : validOutputs) {
                class_2350 output;
                BrassTunnelBlockEntity tunnel = pair.getFirst();
                if (this.insertIntoTunnel(tunnel, output = pair.getSecond(), this.stackToDistribute, true) == null) continue;
                this.distributionTargets.get(!tunnel.flapFilterEmpty(output)).add(Pair.of(tunnel.field_11867, output));
                int distance = tunnel.field_11867.method_10263() + tunnel.field_11867.method_10260() - this.field_11867.method_10263() - this.field_11867.method_10260();
                if (distance < 0) {
                    this.distributionDistanceLeft = Math.max(this.distributionDistanceLeft, -distance);
                    continue;
                }
                this.distributionDistanceRight = Math.max(this.distributionDistanceRight, distance);
            }
            if (((List)this.distributionTargets.getFirst()).isEmpty() && ((List)this.distributionTargets.getSecond()).isEmpty()) {
                return;
            }
            if (this.newItemArrived) {
                this.newItemArrived = false;
                this.distributionProgress = 2.0f;
            } else {
                if (this.selectionMode.get() != SelectionMode.SYNCHRONIZE || this.syncedOutputActive) {
                    this.distributionProgress = ((Integer)AllConfigs.server().logistics.brassTunnelTimer.get()).intValue();
                    this.sendData();
                }
                return;
            }
        }
        if (this.distributionProgress != 0.0f) {
            return;
        }
        this.distributionTargets.forEach(list -> {
            if (this.stackToDistribute.method_7960()) {
                return;
            }
            ArrayList<Pair<BrassTunnelBlockEntity, class_2350>> validTargets = new ArrayList<Pair<BrassTunnelBlockEntity, class_2350>>();
            for (Pair pair : list) {
                class_2586 be;
                class_2338 tunnelPos = (class_2338)pair.getFirst();
                class_2350 output = (class_2350)pair.getSecond();
                if (tunnelPos.equals((Object)this.field_11867) && output == this.stackEnteredFrom || !((be = this.field_11863.method_8321(tunnelPos)) instanceof BrassTunnelBlockEntity)) continue;
                validTargets.add(Pair.of((BrassTunnelBlockEntity)be, output));
            }
            this.distribute(validTargets);
            this.distributionProgress = -1.0f;
        });
    }

    private void distribute(List<Pair<BrassTunnelBlockEntity, class_2350>> validTargets) {
        boolean robin;
        int amountTargets = validTargets.size();
        if (amountTargets == 0) {
            return;
        }
        distributed.clear();
        full.clear();
        int indexStart = this.previousOutputIndex % amountTargets;
        SelectionMode mode = this.selectionMode.get();
        boolean force = mode == SelectionMode.FORCED_ROUND_ROBIN || mode == SelectionMode.FORCED_SPLIT;
        boolean split = mode == SelectionMode.FORCED_SPLIT || mode == SelectionMode.SPLIT;
        boolean bl = robin = mode == SelectionMode.FORCED_ROUND_ROBIN || mode == SelectionMode.ROUND_ROBIN;
        if (mode == SelectionMode.RANDOMIZE) {
            indexStart = this.field_11863.field_9229.method_43048(amountTargets);
        }
        if (mode == SelectionMode.PREFER_NEAREST || mode == SelectionMode.SYNCHRONIZE) {
            indexStart = 0;
        }
        class_1799 toDistribute = this.stackToDistribute.method_7972();
        for (boolean distributeAgain : Iterate.trueAndFalse) {
            class_1799 toDistributeThisCycle = null;
            int remainingOutputs = amountTargets;
            int leftovers = 0;
            block1: for (boolean simulate : Iterate.trueAndFalse) {
                if (remainingOutputs == 0) break;
                leftovers = 0;
                int index = indexStart;
                int stackSize = toDistribute.method_7947();
                int splitStackSize = stackSize / remainingOutputs;
                int splitRemainder = stackSize % remainingOutputs;
                int visited = 0;
                toDistributeThisCycle = toDistribute.method_7972();
                if (!force && !split && simulate) continue;
                while (visited < amountTargets) {
                    class_1799 remainder;
                    int increasedCount;
                    Pair<BrassTunnelBlockEntity, class_2350> pair = validTargets.get(index);
                    BrassTunnelBlockEntity tunnel = pair.getFirst();
                    class_2350 side = pair.getSecond();
                    index = (index + 1) % amountTargets;
                    ++visited;
                    if (full.contains(pair)) {
                        if (!split || !simulate) continue;
                        --remainingOutputs;
                        continue;
                    }
                    int count = split ? splitStackSize + (splitRemainder > 0 ? 1 : 0) : stackSize;
                    class_1799 toOutput = toDistributeThisCycle.method_46651(count);
                    boolean testWithIncreasedCount = distributed.containsKey(pair);
                    int n = increasedCount = testWithIncreasedCount ? distributed.get(pair).method_7947() : 0;
                    if (testWithIncreasedCount) {
                        toOutput.method_7933(increasedCount);
                    }
                    if ((remainder = this.insertIntoTunnel(tunnel, side, toOutput, true)) == null || remainder.method_7947() == (testWithIncreasedCount ? count + 1 : count)) {
                        if (force) {
                            return;
                        }
                        if (split && simulate) {
                            --remainingOutputs;
                        }
                        if (!simulate) {
                            full.add(pair);
                        }
                        if (!robin) continue;
                        continue block1;
                    }
                    if (!remainder.method_7960() && !simulate) {
                        full.add(pair);
                    }
                    if (!simulate) {
                        toOutput.method_7934(remainder.method_7947());
                        distributed.put(pair, toOutput);
                    }
                    leftovers += remainder.method_7947();
                    toDistributeThisCycle.method_7934(count);
                    if (toDistributeThisCycle.method_7960()) continue block1;
                    --splitRemainder;
                    if (split) continue;
                    continue block1;
                }
            }
            toDistribute.method_7939(toDistributeThisCycle.method_7947() + leftovers);
            if (leftovers == 0 && distributeAgain || !split) break;
        }
        int failedTransferrals = 0;
        for (Map.Entry<Pair<BrassTunnelBlockEntity, class_2350>, class_1799> entry : distributed.entrySet()) {
            Pair<BrassTunnelBlockEntity, class_2350> pair = entry.getKey();
            failedTransferrals += this.insertIntoTunnel(pair.getFirst(), pair.getSecond(), entry.getValue(), false).method_7947();
        }
        toDistribute.method_7933(failedTransferrals);
        this.stackToDistribute = this.stackToDistribute.method_46651(toDistribute.method_7947());
        if (this.stackToDistribute.method_7960()) {
            this.stackEnteredFrom = null;
        }
        ++this.previousOutputIndex;
        this.previousOutputIndex %= amountTargets;
        this.notifyUpdate();
    }

    public void setStackToDistribute(class_1799 stack, @Nullable class_2350 enteredFrom) {
        this.stackToDistribute = stack;
        this.stackEnteredFrom = enteredFrom;
        this.distributionProgress = -1.0f;
        if (!stack.method_7960()) {
            this.newItemArrived = true;
        }
        this.sendData();
        this.method_5431();
    }

    public class_1799 getStackToDistribute() {
        return this.stackToDistribute;
    }

    public List<class_1799> grabAllStacksOfGroup(boolean simulate) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        class_1799 own = this.getStackToDistribute();
        if (!own.method_7960()) {
            list.add(own);
            if (!simulate) {
                this.setStackToDistribute(class_1799.field_8037, null);
            }
        }
        for (boolean left : Iterate.trueAndFalse) {
            BrassTunnelBlockEntity adjacent = this;
            while (adjacent != null) {
                class_1799 other;
                if (!this.field_11863.method_8477(adjacent.method_11016())) {
                    return null;
                }
                if ((adjacent = adjacent.getAdjacent(left)) == null || (other = adjacent.getStackToDistribute()).method_7960()) continue;
                list.add(other);
                if (simulate) continue;
                adjacent.setStackToDistribute(class_1799.field_8037, null);
            }
        }
        return list;
    }

    @Nullable
    protected class_1799 insertIntoTunnel(BrassTunnelBlockEntity tunnel, class_2350 side, class_1799 stack, boolean simulate) {
        if (stack.method_7960()) {
            return stack;
        }
        if (!tunnel.testFlapFilter(side, stack)) {
            return null;
        }
        BeltBlockEntity below = BeltHelper.getSegmentBE((class_1936)this.field_11863, tunnel.field_11867.method_10074());
        if (below == null) {
            return null;
        }
        class_2338 offset = tunnel.method_11016().method_10074().method_10093(side);
        DirectBeltInputBehaviour sideOutput = BlockEntityBehaviour.get((class_1922)this.field_11863, offset, DirectBeltInputBehaviour.TYPE);
        if (sideOutput != null) {
            if (!sideOutput.canInsertFromSide(side)) {
                return null;
            }
            class_1799 result = sideOutput.handleInsertion(stack, side, simulate);
            if (result.method_7960() && !simulate) {
                tunnel.flap(side, false);
            }
            return result;
        }
        class_2350 movementFacing = below.getMovementFacing();
        if (side == movementFacing && !BlockHelper.hasBlockSolidSide(this.field_11863.method_8320(offset), (class_1922)this.field_11863, offset, side.method_10153())) {
            BeltBlockEntity controllerBE = below.getControllerBE();
            if (controllerBE == null) {
                return null;
            }
            if (!simulate) {
                tunnel.flap(side, true);
                class_1799 ejected = stack;
                float beltMovementSpeed = below.getDirectionAwareBeltMovementSpeed();
                float movementSpeed = Math.max(Math.abs(beltMovementSpeed), 0.125f);
                int additionalOffset = beltMovementSpeed > 0.0f ? 1 : 0;
                class_243 outPos = BeltHelper.getVectorForOffset(controllerBE, below.index + additionalOffset);
                class_243 outMotion = class_243.method_24954((class_2382)side.method_62675()).method_1021((double)movementSpeed).method_1031(0.0, 0.125, 0.0);
                outPos.method_1019(outMotion.method_1029());
                class_1542 entity = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351 + 0.375, outPos.field_1350, ejected);
                entity.method_18799(outMotion);
                entity.method_6988();
                entity.field_6037 = true;
                this.field_11863.method_8649((class_1297)entity);
            }
            return class_1799.field_8037;
        }
        return null;
    }

    public boolean testFlapFilter(class_2350 side, class_1799 stack) {
        if (this.filtering == null) {
            return false;
        }
        if (this.filtering.get(side) == null) {
            ServerFilteringBehaviour adjacentFilter = BlockEntityBehaviour.get((class_1922)this.field_11863, this.field_11867.method_10093(side), ServerFilteringBehaviour.TYPE);
            if (adjacentFilter == null) {
                return true;
            }
            return adjacentFilter.test(stack);
        }
        return this.filtering.test(side, stack);
    }

    public boolean flapFilterEmpty(class_2350 side) {
        if (this.filtering == null) {
            return false;
        }
        if (this.filtering.get(side) == null) {
            ServerFilteringBehaviour adjacentFilter = BlockEntityBehaviour.get((class_1922)this.field_11863, this.field_11867.method_10093(side), ServerFilteringBehaviour.TYPE);
            if (adjacentFilter == null) {
                return true;
            }
            return adjacentFilter.getFilter().method_7960();
        }
        return this.filtering.getFilter(side).method_7960();
    }

    @Override
    public void initialize() {
        if (this.filtering == null) {
            this.filtering = this.createSidedFilter();
            this.attachBehaviourLate(this.filtering);
        }
        super.initialize();
    }

    public boolean canInsert(class_2350 side, class_1799 stack) {
        if (this.filtering != null && !this.filtering.test(side, stack)) {
            return false;
        }
        if (!this.hasDistributionBehaviour()) {
            return true;
        }
        return this.stackToDistribute.method_7960();
    }

    public boolean hasDistributionBehaviour() {
        if (this.flaps.isEmpty()) {
            return false;
        }
        if (this.connectedLeft || this.connectedRight) {
            return true;
        }
        class_2680 blockState = this.method_11010();
        if (!blockState.method_27852((class_2248)AllBlocks.BRASS_TUNNEL)) {
            return false;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)blockState.method_11654((class_2769)BrassTunnelBlock.HORIZONTAL_AXIS);
        for (class_2350 direction : this.flaps.keySet()) {
            if (direction.method_10166() == axis) continue;
            return true;
        }
        return false;
    }

    private List<Pair<BrassTunnelBlockEntity, class_2350>> gatherValidOutputs() {
        ArrayList<Pair<BrassTunnelBlockEntity, class_2350>> validOutputs = new ArrayList<Pair<BrassTunnelBlockEntity, class_2350>>();
        boolean synchronize = this.selectionMode.get() == SelectionMode.SYNCHRONIZE;
        this.addValidOutputsOf(this, validOutputs);
        for (boolean left : Iterate.trueAndFalse) {
            BrassTunnelBlockEntity adjacent = this;
            while (adjacent != null) {
                if (!this.field_11863.method_8477(adjacent.method_11016())) {
                    return null;
                }
                if ((adjacent = adjacent.getAdjacent(left)) == null) continue;
                this.addValidOutputsOf(adjacent, validOutputs);
            }
        }
        if (!this.syncedOutputActive && synchronize) {
            return null;
        }
        return validOutputs;
    }

    private void addValidOutputsOf(BrassTunnelBlockEntity tunnelBE, List<Pair<BrassTunnelBlockEntity, class_2350>> validOutputs) {
        this.syncSet.add(tunnelBE);
        BeltBlockEntity below = BeltHelper.getSegmentBE((class_1936)this.field_11863, tunnelBE.field_11867.method_10074());
        if (below == null) {
            return;
        }
        class_2350 movementFacing = below.getMovementFacing();
        class_2680 blockState = this.method_11010();
        if (!blockState.method_27852((class_2248)AllBlocks.BRASS_TUNNEL)) {
            return;
        }
        boolean prioritizeSides = tunnelBE == this;
        for (boolean sidePass : Iterate.trueAndFalse) {
            if (!prioritizeSides && sidePass) continue;
            for (class_2350 direction : Iterate.horizontalDirections) {
                class_2338 offset;
                class_2680 potentialFunnel;
                if (direction == movementFacing && below.getSpeed() == 0.0f || prioritizeSides && sidePass == (direction.method_10166() == movementFacing.method_10166()) || direction == movementFacing.method_10153() || !tunnelBE.sides.contains(direction) || (potentialFunnel = this.field_11863.method_8320((offset = tunnelBE.field_11867.method_10074().method_10093(direction)).method_10084())).method_26204() instanceof BeltFunnelBlock && potentialFunnel.method_11654(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.PULLING && FunnelBlock.getFunnelFacing(potentialFunnel) == direction) continue;
                DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get((class_1922)this.field_11863, offset, DirectBeltInputBehaviour.TYPE);
                if (inputBehaviour == null) {
                    if (direction != movementFacing || BlockHelper.hasBlockSolidSide(this.field_11863.method_8320(offset), (class_1922)this.field_11863, offset, direction.method_10153())) continue;
                    validOutputs.add(Pair.of(tunnelBE, direction));
                    continue;
                }
                if (!inputBehaviour.canInsertFromSide(direction)) continue;
                validOutputs.add(Pair.of(tunnelBE, direction));
            }
        }
    }

    @Override
    public void addBehavioursDeferred(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehavioursDeferred(behaviours);
        this.filtering = this.createSidedFilter();
        behaviours.add(this.filtering);
    }

    protected ServerSidedFilteringBehaviour createSidedFilter() {
        return new ServerSidedFilteringBehaviour(this, this::makeFilter, this::isValidFaceForFilter);
    }

    private ServerFilteringBehaviour makeFilter(class_2350 side, ServerFilteringBehaviour filter) {
        return filter;
    }

    private boolean isValidFaceForFilter(class_2350 side) {
        return this.sides.contains(side);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71472("SyncedOutput", this.syncedOutputActive);
        view.method_71472("ConnectedLeft", this.connectedLeft);
        view.method_71472("ConnectedRight", this.connectedRight);
        if (!this.stackToDistribute.method_7960()) {
            view.method_71468("StackToDistribute", class_1799.field_24671, (Object)this.stackToDistribute);
        }
        if (this.stackEnteredFrom != null) {
            view.method_71468("StackEnteredFrom", (Codec)class_2350.field_29502, (Object)this.stackEnteredFrom);
        }
        view.method_71464("DistributionProgress", this.distributionProgress);
        view.method_71465("PreviousIndex", this.previousOutputIndex);
        view.method_71465("DistanceLeft", this.distributionDistanceLeft);
        view.method_71465("DistanceRight", this.distributionDistanceRight);
        view.method_71468("FilteredTargets", CreateCodecs.BLOCK_POS_DIRECTION_LIST_CODEC, (Object)((List)this.distributionTargets.getFirst()));
        view.method_71468("Targets", CreateCodecs.BLOCK_POS_DIRECTION_LIST_CODEC, (Object)((List)this.distributionTargets.getSecond()));
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        boolean wasConnectedLeft = this.connectedLeft;
        boolean wasConnectedRight = this.connectedRight;
        this.syncedOutputActive = view.method_71433("SyncedOutput", false);
        this.connectedLeft = view.method_71433("ConnectedLeft", false);
        this.connectedRight = view.method_71433("ConnectedRight", false);
        this.stackToDistribute = view.method_71426("StackToDistribute", class_1799.field_24671).orElse(class_1799.field_8037);
        this.stackEnteredFrom = view.method_71426("StackEnteredFrom", (Codec)class_2350.field_29502).orElse(null);
        this.distributionProgress = view.method_71423("DistributionProgress", 0.0f);
        this.previousOutputIndex = view.method_71424("PreviousIndex", 0);
        this.distributionDistanceLeft = view.method_71424("DistanceLeft", 0);
        this.distributionDistanceRight = view.method_71424("DistanceRight", 0);
        ((List)this.distributionTargets.getFirst()).clear();
        view.method_71426("FilteredTargets", CreateCodecs.BLOCK_POS_DIRECTION_LIST_CODEC).ifPresent(targets -> ((List)this.distributionTargets.getFirst()).addAll(targets));
        ((List)this.distributionTargets.getSecond()).clear();
        view.method_71426("Targets", CreateCodecs.BLOCK_POS_DIRECTION_LIST_CODEC).ifPresent(targets -> ((List)this.distributionTargets.getSecond()).addAll(targets));
        super.read(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        if ((wasConnectedLeft != this.connectedLeft || wasConnectedRight != this.connectedRight) && this.method_11002()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
        }
        this.filtering.updateFilterPresence();
    }

    public boolean isConnected(boolean leftSide) {
        return leftSide ? this.connectedLeft : this.connectedRight;
    }

    @Override
    public void updateTunnelConnections() {
        BrassTunnelBlockEntity adjacent;
        super.updateTunnelConnections();
        boolean connectivityChanged = false;
        boolean nowConnectedLeft = this.determineIfConnected(true);
        boolean nowConnectedRight = this.determineIfConnected(false);
        if (this.connectedLeft != nowConnectedLeft) {
            this.connectedLeft = nowConnectedLeft;
            connectivityChanged = true;
            adjacent = this.getAdjacent(true);
            if (adjacent != null && !this.field_11863.field_9236) {
                adjacent.updateTunnelConnections();
                adjacent.selectionMode.setValue(this.selectionMode.getValue());
            }
        }
        if (this.connectedRight != nowConnectedRight) {
            this.connectedRight = nowConnectedRight;
            connectivityChanged = true;
            adjacent = this.getAdjacent(false);
            if (adjacent != null && !this.field_11863.field_9236) {
                adjacent.updateTunnelConnections();
                adjacent.selectionMode.setValue(this.selectionMode.getValue());
            }
        }
        if (this.filtering != null) {
            this.filtering.updateFilterPresence();
        }
        if (connectivityChanged) {
            this.sendData();
        }
    }

    protected boolean determineIfConnected(boolean leftSide) {
        if (this.flaps.isEmpty()) {
            return false;
        }
        BrassTunnelBlockEntity adjacentTunnelBE = this.getAdjacent(leftSide);
        return adjacentTunnelBE != null && !adjacentTunnelBE.flaps.isEmpty();
    }

    @Nullable
    protected BrassTunnelBlockEntity getAdjacent(boolean leftSide) {
        if (!this.method_11002()) {
            return null;
        }
        class_2680 blockState = this.method_11010();
        if (!blockState.method_27852((class_2248)AllBlocks.BRASS_TUNNEL)) {
            return null;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)blockState.method_11654((class_2769)BrassTunnelBlock.HORIZONTAL_AXIS);
        class_2350 baseDirection = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        class_2350 direction = leftSide ? baseDirection.method_10160() : baseDirection.method_10170();
        class_2338 adjacentPos = this.field_11867.method_10093(direction);
        class_2680 adjacentBlockState = this.field_11863.method_8320(adjacentPos);
        if (!adjacentBlockState.method_27852((class_2248)AllBlocks.BRASS_TUNNEL)) {
            return null;
        }
        if (adjacentBlockState.method_11654((class_2769)BrassTunnelBlock.HORIZONTAL_AXIS) != axis) {
            return null;
        }
        class_2586 adjacentBE = this.field_11863.method_8321(adjacentPos);
        if (adjacentBE.method_11015()) {
            return null;
        }
        if (!(adjacentBE instanceof BrassTunnelBlockEntity)) {
            return null;
        }
        return (BrassTunnelBlockEntity)adjacentBE;
    }

    @Override
    public void destroy() {
        super.destroy();
        class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)this.stackToDistribute);
        this.stackEnteredFrom = null;
    }

    public class_1263 getBeltCapability() {
        class_2338 down;
        class_2586 blockEntity;
        if (this.beltCapability == null && (blockEntity = this.field_11863.method_8321(down = this.field_11867.method_10074())) != null) {
            this.beltCapability = ItemHelper.getInventory(this.field_11863, down, null, blockEntity, class_2350.field_11036);
        }
        return this.beltCapability;
    }

    public boolean canTakeItems() {
        return this.stackToDistribute.method_7960() && !this.syncedOutputActive;
    }

    public static enum SelectionMode {
        SPLIT,
        FORCED_SPLIT,
        ROUND_ROBIN,
        FORCED_ROUND_ROBIN,
        PREFER_NEAREST,
        RANDOMIZE,
        SYNCHRONIZE;

    }
}

