/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.serialization.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CodecUtil {
    public static final Codec<class_2248> BLOCK_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(class_7923.field_41175);
    public static final Codec<class_1291> MOB_EFFECT = CodecUtil.createLoggedExceptionRegistryCodec(class_7923.field_41174);
    public static final Codec<class_1299<?>> ENTITY_TYPE = CodecUtil.createLoggedExceptionRegistryCodec(class_7923.field_41177);
    public static final Codec<class_1299<?>> ENTITY_TYPE_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(class_7923.field_41177);
    public static final Codec<class_1320> ATTRIBUTE_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(class_7923.field_41190);
    public static final Codec<class_1792> ITEM_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(class_7923.field_41178);
    public static final Codec<class_1291> EFFECT_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(class_7923.field_41174);
    public static final Codec<class_5321<class_1959>> BIOME_CODEC = class_2960.field_25139.comapFlatMap(resourceLocation -> DataResult.success((Object)class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)resourceLocation)), class_5321::method_29177);
    public static final Codec<class_1304> EQUIPMENT_SLOT_CODEC = Codec.STRING.comapFlatMap(s -> {
        class_1304 equipmentSlotType = class_1304.method_5924((String)s.toLowerCase());
        if (equipmentSlotType == null) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid equipmentSlotType. Valid equipmentSlotTypes: %s", s, Arrays.toString(Arrays.stream(class_1304.values()).map(class_1304::method_5923).toArray())));
        }
        return DataResult.success((Object)equipmentSlotType);
    }, class_1304::method_5923);
    public static final Codec<class_1267> DIFFICULTY_CODEC = Codec.STRING.comapFlatMap(s -> {
        class_1267 difficulty = class_1267.method_16691((String)s.toLowerCase());
        if (difficulty == null) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid difficulty. Valid difficulties: %s", s, Arrays.toString(Arrays.stream(class_1267.values()).map(class_1267::method_5460).toArray())));
        }
        return DataResult.success((Object)difficulty);
    }, class_1267::method_5460);
    public static Codec<Integer> COLOR_FROM_HEX = Codec.STRING.comapFlatMap(CodecUtil.validateColorHex(), Integer::toHexString);
    public static final Codec<Integer> INTEGER_KEY_CODEC = Codec.STRING.comapFlatMap(s -> DataResult.success((Object)Integer.valueOf(s)), Object::toString);

    public static Function<String, DataResult<Integer>> validateColorHex() {
        return input -> {
            if (input.isEmpty()) {
                return DataResult.success((Object)class_124.field_1068.method_532());
            }
            try {
                return DataResult.success((Object)((int)Long.parseLong(input.replace("#", "").replace("0x", ""), 16)));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return DataResult.error(e::getMessage);
            }
        };
    }

    public static Codec<Integer> intKeyRangeCodec(int min, int max) {
        Function check = Codec.checkRange((Number)min, (Number)max);
        return INTEGER_KEY_CODEC.flatXmap(check, check);
    }

    public static <T> Codec<T> createLoggedExceptionRegistryCodec(class_2378<T> registry) {
        return class_2960.field_25139.comapFlatMap(location -> {
            Optional result = registry.method_17966(location);
            if (result.isEmpty()) {
                StringBuilder registryElements = new StringBuilder();
                for (int i = 0; i < registry.method_29722().size(); ++i) {
                    Object object = registry.method_10200(i);
                    registryElements.append(i).append(". \"").append(registry.method_10221(object).toString()).append("\"\n");
                }
                return DataResult.error(() -> String.format("\"%s\" is not a valid id in registry: %s.\nCurrent Registry Values:\n\n%s\n", location.toString(), registry, registryElements));
            }
            return DataResult.success(result.get());
        }, arg_0 -> registry.method_10221(arg_0));
    }

    public static <T> Codec<WrapForSerialization<T>> wrapCodecForCollectionSerializing(Codec<T> codec) {
        return RecordCodecBuilder.create(builder -> builder.group((App)codec.fieldOf("value").forGetter(tWrapForSerialization -> tWrapForSerialization.value)).apply((Applicative)builder, WrapForSerialization::new));
    }

    public static <T> WrapForSerialization<T> wrap(T toWrap) {
        return new WrapForSerialization<T>(toWrap);
    }

    public record WrapForSerialization<T>(T value) {
    }

    public record LazyCodec<TYPE>(Supplier<Codec<TYPE>> delegate) implements Codec<TYPE>
    {
        public <T> DataResult<T> encode(TYPE input, DynamicOps<T> ops, T prefix) {
            return this.delegate().get().encode(input, ops, prefix);
        }

        public <T> DataResult<Pair<TYPE, T>> decode(DynamicOps<T> ops, T input) {
            return this.delegate().get().decode(ops, input);
        }
    }
}

