/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiControlDistHandler;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.util.type.itr.ConsecutiveIterator;

public class GuiControls
implements Iterable<GuiControl> {
    protected final List<GuiControl> controls = new CopyOnWriteArrayList<GuiControl>();
    protected final List<GuiControlDistHandler> distControls = new CopyOnWriteArrayList<GuiControlDistHandler>();
    protected final List<GuiControl> hoverControls = new CopyOnWriteArrayList<GuiControl>();
    protected final List<GuiControlDistHandler> distHoverControls = new CopyOnWriteArrayList<GuiControlDistHandler>();

    public GuiControl get(int index) {
        return this.controls.get(index);
    }

    public GuiControl remove(int index) {
        this.distControls.remove(index);
        return this.controls.remove(index);
    }

    public <T extends GuiControl> T get(String name) {
        GuiControl result = this.get(name, this.controls);
        if (result != null) {
            return (T)result;
        }
        return (T)this.get(name, this.hoverControls);
    }

    private GuiControl get(String name, List<GuiControl> collection) {
        for (int i = 0; i < collection.size(); ++i) {
            GuiControl control = collection.get(i);
            if (control.name.equalsIgnoreCase(name)) {
                return control;
            }
            if (!(control instanceof GuiParent)) continue;
            GuiParent parent = (GuiParent)control;
            if (control.name.isBlank()) {
                Object result = parent.get(name);
                if (result == null) continue;
                return result;
            }
            if (!name.startsWith(control.name + ".")) continue;
            return parent.get(name.substring(control.name.length() + 1));
        }
        return null;
    }

    public <T extends GuiControl> T insertControlBefore(GuiControl reference, T toInsert) {
        int index = this.controls.indexOf(reference);
        if (index == -1) {
            return null;
        }
        this.controls.add(index, toInsert);
        this.distControls.add(index, toInsert.dist());
        return toInsert;
    }

    public <T extends GuiControl> T insertControlAfter(GuiControl reference, T toInsert) {
        int index = this.controls.indexOf(reference);
        if (index == -1) {
            return null;
        }
        if (++index == this.controls.size()) {
            this.controls.add(toInsert);
            this.distControls.add(toInsert.dist());
        } else {
            this.controls.add(index, toInsert);
            this.distControls.add(index, toInsert.dist());
        }
        return toInsert;
    }

    public void add(GuiControl control) {
        this.controls.add(control);
        this.distControls.add(control.dist());
    }

    public void addHover(GuiControl control) {
        this.hoverControls.add(control);
        this.distHoverControls.add(control.dist());
    }

    public boolean remove(GuiControl control) {
        int index = this.controls.indexOf(control);
        if (index != -1) {
            this.controls.remove(index);
            this.distControls.remove(index);
            return true;
        }
        index = this.hoverControls.indexOf(control);
        if (index != -1) {
            this.hoverControls.remove(index);
            this.distHoverControls.remove(index);
            return true;
        }
        return false;
    }

    public boolean replace(GuiControl oldControl, GuiControl newControl) {
        int i;
        for (i = 0; i < this.controls.size(); ++i) {
            if (this.controls.get(i) != oldControl) continue;
            this.controls.set(i, newControl);
            this.distControls.set(i, newControl.dist());
            return true;
        }
        for (i = 0; i < this.hoverControls.size(); ++i) {
            if (this.hoverControls.get(i) != oldControl) continue;
            this.hoverControls.set(i, newControl);
            this.distHoverControls.set(i, newControl.dist());
            return true;
        }
        return false;
    }

    public void remove(String ... include) {
        int i = 0;
        while (i < this.controls.size()) {
            if (ArrayUtils.contains((Object[])include, (Object)this.controls.get((int)i).name)) {
                this.controls.remove(i);
                this.distControls.remove(i);
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < this.hoverControls.size()) {
            if (ArrayUtils.contains((Object[])include, (Object)this.hoverControls.get((int)i).name)) {
                this.hoverControls.remove(i);
                this.distHoverControls.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void removeExclude(String ... exclude) {
        int i = 0;
        while (i < this.controls.size()) {
            if (!ArrayUtils.contains((Object[])exclude, (Object)this.controls.get((int)i).name)) {
                this.controls.remove(i);
                this.distControls.remove(i);
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < this.hoverControls.size()) {
            if (!ArrayUtils.contains((Object[])exclude, (Object)this.hoverControls.get((int)i).name)) {
                this.hoverControls.remove(i);
                this.distHoverControls.remove(i);
                continue;
            }
            ++i;
        }
    }

    public boolean isEmpty() {
        return this.controls.isEmpty() && this.hoverControls.isEmpty();
    }

    public void clear() {
        this.controls.clear();
        this.distControls.clear();
        this.hoverControls.clear();
        this.distHoverControls.clear();
    }

    public int controlSize() {
        return this.controls.size();
    }

    public int hoverSize() {
        return this.hoverControls.size();
    }

    public int totalSize() {
        return this.controls.size() + this.hoverControls.size();
    }

    @Override
    public Iterator<GuiControl> iterator() {
        if (this.hoverControls.isEmpty()) {
            return this.controls.iterator();
        }
        return new ConsecutiveIterator<GuiControl>(this.hoverControls, this.controls);
    }

    public Iterable<GuiControlDistHandler> distControls() {
        return this.distControls;
    }

    public Iterable<GuiControlDistHandler> distHoverControls() {
        return this.distHoverControls;
    }

    public Iterable<GuiControlDistHandler> distAll() {
        return new ConsecutiveIterator<GuiControlDistHandler>(this.distHoverControls, this.distControls);
    }

    public Stream<GuiControlDistHandler> streamDistControls() {
        return this.distControls.stream();
    }

    public Stream<GuiControlDistHandler> streamDistHoverControls() {
        return this.distHoverControls.stream();
    }

    public ListIterator<GuiControlDistHandler> distListControls(int index) {
        return this.distControls.listIterator(index);
    }

    public ListIterator<GuiControlDistHandler> distHoverListControls(int index) {
        return this.distHoverControls.listIterator(index);
    }
}

