/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.core.v1.ServiceProviderHelper;
import fuzs.puzzleslib.impl.core.ModContext;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_3222;

public interface ModLoaderEnvironment {
    public static final ModLoaderEnvironment INSTANCE = ServiceProviderHelper.load(ModLoaderEnvironment.class);

    public ModLoader getModLoader();

    public boolean isClient();

    public boolean isServer();

    public Path getGameDirectory();

    public Path getModsDirectory();

    public Path getConfigDirectory();

    public String getCurrentMappingsNamespace();

    public boolean isDevelopmentEnvironment();

    public boolean isDataGeneration();

    default public boolean isDevelopmentEnvironmentWithoutDataGeneration(String modId) {
        if (this.isDataGeneration()) {
            return false;
        }
        return this.isDevelopmentEnvironment(modId);
    }

    default public boolean isDevelopmentEnvironment(String modId) {
        if (!INSTANCE.isDevelopmentEnvironment()) {
            return false;
        }
        return Boolean.getBoolean(modId + ".isDevelopmentEnvironment");
    }

    public Map<String, ModContainer> getModList();

    default public boolean isModLoaded(String modId) {
        return this.getModList().containsKey(modId);
    }

    default public Optional<ModContainer> getModContainer(String modId) {
        return Optional.ofNullable(this.getModList().get(modId));
    }

    default public boolean isModPresentServerside(String modId) {
        return ModContext.getModContexts().containsKey(modId) && ModContext.getModContexts().get(modId).isPresentServerside();
    }

    default public boolean isModPresentClientside(class_3222 serverPlayer, String modId) {
        return ModContext.getModContexts().containsKey(modId) && ModContext.getModContexts().get(modId).isPresentClientside(serverPlayer);
    }
}

