/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Map;
import java.util.stream.Stream;

public class JsonMapCodec
extends MapCodec<JsonObject> {
    public static final MapCodec<JsonObject> INSTANCE = new JsonMapCodec();

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        throw new UnsupportedOperationException("Not implemented yet! Should not be necessary for regular JSON serialization.");
    }

    public <T> DataResult<JsonObject> decode(DynamicOps<T> ops, MapLike<T> input) {
        JsonElement converted = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, ops.createMap(input.entries()));
        if (converted.isJsonObject()) {
            return DataResult.success((Object)converted.getAsJsonObject());
        }
        return DataResult.error(() -> "Not a json object: " + String.valueOf(converted));
    }

    public <T> RecordBuilder<T> encode(JsonObject input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        for (Map.Entry entry : input.entrySet()) {
            Object convertedValue = JsonOps.INSTANCE.convertTo(ops, (JsonElement)entry.getValue());
            prefix.add((String)entry.getKey(), convertedValue);
        }
        return prefix;
    }
}

