/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.misc.world;

import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import reborncore.common.misc.world.ChunkEventListener;
import reborncore.common.misc.world.ChunkPosMultiMap;

public class ChunkEventListeners {
    public static ChunkPosMultiMap<ChunkEventListener> listeners = new ChunkPosMultiMap();

    public static void init() {
        ServerLifecycleEvents.SERVER_STOPPED.register(minecraftServer -> ChunkEventListeners.serverStopCleanup());
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            Set<ChunkEventListener> cels;
            if (!world.method_8608() && (cels = listeners.get((class_1937)world, chunk.method_12004())) != null) {
                for (ChunkEventListener cel : cels) {
                    cel.onLoadChunk();
                }
            }
        });
        ServerChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            Set<ChunkEventListener> cels;
            if (!world.method_8608() && (cels = listeners.get((class_1937)world, chunk.method_12004())) != null) {
                for (ChunkEventListener cel : cels) {
                    cel.onUnloadChunk();
                }
            }
        });
    }

    public static void onBlockStateChange(class_1937 world, class_1923 chunkPos, class_2338 pos) {
        Set<ChunkEventListener> cels;
        if (!world.method_8608() && (cels = listeners.get(world, chunkPos)) != null) {
            for (ChunkEventListener cel : cels) {
                cel.onBlockUpdate(pos);
            }
        }
    }

    private static void serverStopCleanup() {
        if (listeners.size() != 0) {
            listeners = new ChunkPosMultiMap();
        }
    }
}

