/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.worldgen.structures;

import com.jtorleonstudios.libraryferret.conf.Configuration;
import com.jtorleonstudios.libraryferret.conf.Props;
import com.mojang.datafixers.util.Function4;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AwesomeStructureConfiguration {
    private final Props enabled;
    private final Props separation;
    private final Props spacing;
    private final Props salt;

    public AwesomeStructureConfiguration(Props enabled, Props separation, Props spacing, Props salt) {
        this.enabled = enabled;
        this.separation = separation;
        this.spacing = spacing;
        this.salt = salt;
    }

    @NotNull
    public static <T extends AwesomeStructureConfiguration> T createStructureSetDefault(String uniqueStructureGroupIdentifier, int spacing, int separation, int salt, @NotNull Function4<Props, Props, Props, Props, T> configurationCreator) {
        return (T)((AwesomeStructureConfiguration)configurationCreator.apply((Object)Props.create(uniqueStructureGroupIdentifier, "enable", ""), (Object)Props.create(uniqueStructureGroupIdentifier, "separation", separation), (Object)Props.create(uniqueStructureGroupIdentifier, "spacing", spacing), (Object)Props.create(uniqueStructureGroupIdentifier, "salt", salt)));
    }

    @NotNull
    public static <T extends AwesomeStructureConfiguration> T createStructureDefault(String uniqueStructureGroupIdentifier, @NotNull Function4<Props, Props, Props, Props, T> configurationCreator) {
        return (T)((AwesomeStructureConfiguration)configurationCreator.apply((Object)Props.create(uniqueStructureGroupIdentifier, "enable", true), (Object)Props.create(uniqueStructureGroupIdentifier, "separation", ""), (Object)Props.create(uniqueStructureGroupIdentifier, "spacing", ""), (Object)Props.create(uniqueStructureGroupIdentifier, "salt", "")));
    }

    @NotNull
    public static <T extends AwesomeStructureConfiguration> T createDefault(String uniqueStructureGroupIdentifier, int spacing, int separation, int salt, @NotNull Function4<Props, Props, Props, Props, T> configurationCreator) {
        return (T)((AwesomeStructureConfiguration)configurationCreator.apply((Object)Props.create(uniqueStructureGroupIdentifier, "enable", true), (Object)Props.create(uniqueStructureGroupIdentifier, "separation", separation), (Object)Props.create(uniqueStructureGroupIdentifier, "spacing", spacing), (Object)Props.create(uniqueStructureGroupIdentifier, "salt", salt)));
    }

    @Contract(value=" -> new", pure=true)
    public Props @NotNull [] getForRegistration() {
        if (this.separation.getDefaultValue().isEmpty() && this.spacing.getDefaultValue().isEmpty() && this.salt.getDefaultValue().isEmpty()) {
            return new Props[]{this.enabled};
        }
        if (this.enabled.getDefaultValue().isEmpty()) {
            return new Props[]{this.separation, this.spacing, this.salt};
        }
        return new Props[]{this.enabled, this.separation, this.spacing, this.salt};
    }

    public boolean isEnabled() {
        return this.getConfigurationManager().getBoolOrDefault(this.enabled);
    }

    public int getSeparation() {
        return this.getConfigurationManager().getIntOrDefault(this.separation);
    }

    public int getSpacing() {
        return this.getConfigurationManager().getIntOrDefault(this.spacing);
    }

    public int getSalt() {
        return this.getConfigurationManager().getIntOrDefault(this.salt);
    }

    @NotNull
    public static <T extends AwesomeStructureConfiguration> T getConfigurationOrNullPointer(@Nullable Configuration configurationManager, Map<String, T> mapStructureConfig, String uniqueStructureGroupIdentifier) {
        if (configurationManager == null) {
            throw new NullPointerException("Instance configuration manager null");
        }
        if (mapStructureConfig.isEmpty()) {
            throw new NullPointerException("Map structures configuration empty, If you apply changes to the configuration or with a datapack, cancel/undo your last changes.");
        }
        if (!mapStructureConfig.containsKey(uniqueStructureGroupIdentifier)) {
            throw new NullPointerException("Impossible to found configuration for `uniqueStructureGroupIdentifier`: " + uniqueStructureGroupIdentifier + ", If you apply changes to the configuration or with a datapack, cancel/undo your last changes.");
        }
        return (T)((AwesomeStructureConfiguration)mapStructureConfig.get(uniqueStructureGroupIdentifier));
    }

    public static <T extends AwesomeStructureConfiguration> Props[] mapValuesToArray(@NotNull Map<String, T> allStructureProps) {
        Object[] propsForRegistration = new Props[]{};
        for (AwesomeStructureConfiguration config : allStructureProps.values()) {
            Object[] old = propsForRegistration;
            propsForRegistration = (Props[])ArrayUtils.addAll((Object[])old, (Object[])config.getForRegistration());
        }
        return propsForRegistration;
    }

    public abstract Configuration getConfigurationManager();
}

