/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.container;

import java.util.Arrays;
import java.util.HashSet;
import net.blay09.mods.balm.api.container.EmptyContainer;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class CombinedContainer
implements class_1263,
class_1278 {
    private final class_1263[] containers;
    private final int[] baseIndex;
    private final int totalSlots;

    public CombinedContainer(class_1263 ... containers) {
        this.containers = containers;
        this.baseIndex = new int[containers.length];
        int index = 0;
        for (int i = 0; i < containers.length; ++i) {
            this.baseIndex[i] = index += containers[i].method_5439();
        }
        this.totalSlots = index;
    }

    private int getContainerIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    private class_1263 getContainerFromIndex(int index) {
        return index >= 0 && index < this.containers.length ? this.containers[index] : EmptyContainer.INSTANCE;
    }

    private int getInnerSlotFromIndex(int slot, int index) {
        return index > 0 && index < this.baseIndex.length ? slot - this.baseIndex[index - 1] : slot;
    }

    private int getOuterSlotFromIndex(int slot, int index) {
        return index < this.baseIndex.length ? slot - this.baseIndex[index] : slot;
    }

    public int method_5439() {
        return this.totalSlots;
    }

    public boolean method_5442() {
        return Arrays.stream(this.containers).allMatch(class_1263::method_5442);
    }

    public class_1799 method_5438(int slot) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 container = this.getContainerFromIndex(containerIndex);
        return container.method_5438(this.getInnerSlotFromIndex(slot, containerIndex));
    }

    public class_1799 method_5434(int slot, int amount) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 container = this.getContainerFromIndex(containerIndex);
        return container.method_5434(this.getInnerSlotFromIndex(slot, containerIndex), amount);
    }

    public class_1799 method_5441(int slot) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 container = this.getContainerFromIndex(containerIndex);
        return container.method_5441(this.getInnerSlotFromIndex(slot, containerIndex));
    }

    public void method_5447(int slot, class_1799 itemStack) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 container = this.getContainerFromIndex(containerIndex);
        container.method_5447(this.getInnerSlotFromIndex(slot, containerIndex), itemStack);
    }

    public void method_5431() {
        for (class_1263 container : this.containers) {
            container.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        return Arrays.stream(this.containers).allMatch(container -> container.method_5443(player));
    }

    public void method_5448() {
        for (class_1263 container : this.containers) {
            container.method_5448();
        }
    }

    public void method_5435(class_1657 player) {
        for (class_1263 container : this.containers) {
            container.method_5435(player);
        }
    }

    public void method_5432(class_1657 player) {
        for (class_1263 container : this.containers) {
            container.method_5432(player);
        }
    }

    public boolean method_5437(int slot, class_1799 itemStack) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 container = this.getContainerFromIndex(containerIndex);
        return container.method_5437(this.getInnerSlotFromIndex(slot, containerIndex), itemStack);
    }

    public boolean method_49104(class_1263 container, int slot, class_1799 itemStack) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 subContainer = this.getContainerFromIndex(containerIndex);
        return container.method_49104(subContainer, this.getInnerSlotFromIndex(slot, containerIndex), itemStack);
    }

    public int[] method_5494(class_2350 direction) {
        HashSet<Integer> slots = new HashSet<Integer>();
        for (int index = 0; index < this.containers.length; ++index) {
            class_1263 container = this.containers[index];
            if (container instanceof class_1278) {
                class_1278 worldlyContainer = (class_1278)container;
                for (int i2 : worldlyContainer.method_5494(direction)) {
                    slots.add(i2);
                }
                continue;
            }
            for (int i3 = 0; i3 < container.method_5439(); ++i3) {
                slots.add(this.getOuterSlotFromIndex(i3, index));
            }
        }
        return slots.stream().mapToInt(i -> i).toArray();
    }

    public boolean method_5492(int slot, class_1799 itemStack, @Nullable class_2350 direction) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 container = this.getContainerFromIndex(containerIndex);
        if (container instanceof class_1278) {
            class_1278 worldlyContainer = (class_1278)container;
            return worldlyContainer.method_5492(this.getInnerSlotFromIndex(slot, containerIndex), itemStack, direction);
        }
        return this.method_5437(slot, itemStack);
    }

    public boolean method_5493(int slot, class_1799 itemStack, class_2350 direction) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 container = this.getContainerFromIndex(containerIndex);
        if (container instanceof class_1278) {
            class_1278 worldlyContainer = (class_1278)container;
            return worldlyContainer.method_5493(slot, itemStack, direction);
        }
        return this.method_49104(this, slot, itemStack);
    }
}

