/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.requirement;

import java.util.List;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class SoftCooldownRequirement
implements WarpRequirement {
    private class_2960 key;
    private int seconds;

    public SoftCooldownRequirement(class_2960 key, int seconds) {
        this.key = key;
        this.seconds = seconds;
    }

    @Override
    public boolean canAfford(class_1657 player) {
        return true;
    }

    @Override
    public void consume(class_1657 player) {
        if (this.seconds > 0) {
            PlayerWaystoneManager.setCooldownUntil(player, this.key, System.currentTimeMillis() + (long)this.seconds * 1000L);
            WaystoneSyncManager.sendWaystoneCooldowns(player);
        }
    }

    @Override
    public void rollback(class_1657 player) {
        PlayerWaystoneManager.setCooldownUntil(player, this.key, 0L);
    }

    @Override
    public void appendHoverText(class_1657 player, List<class_2561> tooltip) {
        long millisLeft = this.getCooldownMillisLeft(player);
        if (millisLeft > 0L) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.waystones.cooldown_left", (Object[])new Object[]{millisLeft / 1000L}).method_27692(class_124.field_1065));
        }
    }

    public long getCooldownMillisLeft(class_1657 player) {
        return PlayerWaystoneManager.getCooldownMillisLeft(player, this.key);
    }

    @Override
    public boolean isEmpty() {
        return this.seconds <= 0;
    }

    public void setCooldown(class_2960 key, int seconds) {
        this.key = key;
        this.seconds = seconds;
    }

    public class_2960 getCooldownKey() {
        return this.key;
    }

    public int getCooldownSeconds() {
        return this.seconds;
    }
}

