/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipe;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_8957;
import org.jetbrains.annotations.Nullable;

public class ShapedBackpackRecipeBuilder
implements class_5797 {
    private final class_7871<class_1792> items;
    private final class_7800 category;
    private final class_1792 result;
    private final int count;
    private final class_1799 resultStack;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private final Map<String, class_175<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private boolean showNotification = true;

    private ShapedBackpackRecipeBuilder(class_7871<class_1792> items, class_7800 category, class_1935 result, int count) {
        this(items, category, new class_1799(result, count));
    }

    private ShapedBackpackRecipeBuilder(class_7871<class_1792> p_365072_, class_7800 p_249996_, class_1799 result) {
        this.items = p_365072_;
        this.category = p_249996_;
        this.result = result.method_7909();
        this.count = result.method_7947();
        this.resultStack = result;
    }

    public static ShapedBackpackRecipeBuilder shaped(class_7871<class_1792> items, class_7800 category, class_1935 result) {
        return ShapedBackpackRecipeBuilder.shaped(items, category, result, 1);
    }

    public static ShapedBackpackRecipeBuilder shaped(class_7871<class_1792> items, class_7800 category, class_1935 result, int count) {
        return new ShapedBackpackRecipeBuilder(items, category, result, count);
    }

    public static ShapedBackpackRecipeBuilder shaped(class_7871<class_1792> p_365019_, class_7800 p_251325_, class_1799 result) {
        return new ShapedBackpackRecipeBuilder(p_365019_, p_251325_, result);
    }

    public ShapedBackpackRecipeBuilder define(Character symbol, class_6862<class_1792> tag) {
        return this.define(symbol, class_1856.method_8106((class_6885)this.items.method_46735(tag)));
    }

    public ShapedBackpackRecipeBuilder define(Character symbol, class_1935 item) {
        return this.define(symbol, class_1856.method_8101((class_1935)item));
    }

    public ShapedBackpackRecipeBuilder define(Character symbol, class_1856 ingredient) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredient);
        return this;
    }

    public ShapedBackpackRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public ShapedBackpackRecipeBuilder unlockedBy(String p_126133_, class_175<?> p_301126_) {
        this.criteria.put(p_126133_, p_301126_);
        return this;
    }

    public ShapedBackpackRecipeBuilder group(@Nullable String p_126146_) {
        this.group = p_126146_;
        return this;
    }

    public ShapedBackpackRecipeBuilder showNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public void method_17972(class_8790 p_301098_, class_5321<class_1860<?>> p_380072_) {
        class_8957 shapedrecipepattern = this.ensureValid(p_380072_);
        class_161.class_162 advancement$builder = p_301098_.method_53818().method_705("has_the_recipe", class_2119.method_27847(p_380072_)).method_703(class_170.class_171.method_753(p_380072_)).method_704(class_8782.class_8797.field_1257);
        this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)advancement$builder).method_705(arg_0, arg_1));
        ShapedBackpackRecipe shapedrecipe = new ShapedBackpackRecipe(Objects.requireNonNullElse(this.group, ""), class_5797.method_55308((class_7800)this.category), shapedrecipepattern, this.resultStack, this.showNotification);
        p_301098_.method_53819(p_380072_, (class_1860)shapedrecipe, advancement$builder.method_695(p_380072_.method_29177().method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private class_8957 ensureValid(class_5321<class_1860<?>> recipe) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipe.method_29177()));
        }
        return class_8957.method_55085(this.key, this.rows);
    }
}

