/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fuzs.illagerinvasion.init.ModEntityTypes;
import fuzs.illagerinvasion.mixin.accessor.VillagerHostilesSensorAccessor;
import fuzs.illagerinvasion.world.entity.monster.Alchemist;
import fuzs.illagerinvasion.world.entity.monster.Archivist;
import fuzs.illagerinvasion.world.entity.monster.Basher;
import fuzs.illagerinvasion.world.entity.monster.Firecaller;
import fuzs.illagerinvasion.world.entity.monster.Inquisitor;
import fuzs.illagerinvasion.world.entity.monster.Invoker;
import fuzs.illagerinvasion.world.entity.monster.Marauder;
import fuzs.illagerinvasion.world.entity.monster.Necromancer;
import fuzs.illagerinvasion.world.entity.monster.Provoker;
import fuzs.illagerinvasion.world.entity.monster.Sorcerer;
import fuzs.illagerinvasion.world.entity.monster.Surrendered;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1352;
import net.minecraft.class_3218;
import net.minecraft.class_3988;

public class VillagerGoalHandler {
    private static final List<AvoidVillagerEnemy<?>> VILLAGER_ENEMIES = ImmutableList.builder().add(new AvoidVillagerEnemy<Alchemist>(Alchemist.class, () -> ModEntityTypes.ALCHEMIST_ENTITY_TYPE.comp_349(), 12.0f)).add(new AvoidVillagerEnemy<Archivist>(Archivist.class, () -> ModEntityTypes.ARCHIVIST_ENTITY_TYPE.comp_349(), 12.0f)).add(new AvoidVillagerEnemy<Basher>(Basher.class, () -> ModEntityTypes.BASHER_ENTITY_TYPE.comp_349(), 8.0f)).add(new AvoidVillagerEnemy<Firecaller>(Firecaller.class, () -> ModEntityTypes.FIRECALLER_ENTITY_TYPE.comp_349(), 12.0f)).add(new AvoidVillagerEnemy<Inquisitor>(Inquisitor.class, () -> ModEntityTypes.INQUISITOR_ENTITY_TYPE.comp_349(), 15.0f)).add(new AvoidVillagerEnemy<Invoker>(Invoker.class, () -> ModEntityTypes.INVOKER_ENTITY_TYPE.comp_349(), 15.0f)).add(new AvoidVillagerEnemy<Marauder>(Marauder.class, () -> ModEntityTypes.MARAUDER_ENTITY_TYPE.comp_349(), 12.0f)).add(new AvoidVillagerEnemy<Necromancer>(Necromancer.class, () -> ModEntityTypes.NECROMANCER_ENTITY_TYPE.comp_349(), 15.0f)).add(new AvoidVillagerEnemy<Provoker>(Provoker.class, () -> ModEntityTypes.PROVOKER_ENTITY_TYPE.comp_349(), 12.0f)).add(new AvoidVillagerEnemy<Sorcerer>(Sorcerer.class, () -> ModEntityTypes.SORCERER_ENTITY_TYPE.comp_349(), 12.0f)).add(new AvoidVillagerEnemy<Surrendered>(Surrendered.class, () -> ModEntityTypes.SURRENDERED_ENTITY_TYPE.comp_349(), 8.0f)).build();

    public static EventResult onEntityLoad(class_1297 entity, class_3218 serverLevel, boolean isNewlySpawned) {
        if (entity.method_5864() == class_1299.field_17713) {
            for (AvoidVillagerEnemy<?> villagerEnemy : VILLAGER_ENEMIES) {
                villagerEnemy.addGoal((class_3988)entity);
            }
        }
        return EventResult.PASS;
    }

    public static void init() {
        IdentityHashMap map = new IdentityHashMap((Map<class_1299<?>, Float>)VillagerHostilesSensorAccessor.illagerinvasion$getAcceptableDistanceFromHostiles());
        for (AvoidVillagerEnemy<?> villagerEnemy : VILLAGER_ENEMIES) {
            villagerEnemy.addAcceptableDistance(map::put);
        }
        VillagerHostilesSensorAccessor.illagerinvasion$setAcceptableDistanceFromHostiles(ImmutableMap.copyOf(map));
    }

    private record AvoidVillagerEnemy<T extends class_1309>(Class<T> clazz, Supplier<class_1299<T>> type, float acceptableDistance) {
        public void addGoal(class_3988 abstractVillager) {
            abstractVillager.field_6201.method_6277(1, this.makeGoal(abstractVillager));
        }

        private class_1352 makeGoal(class_3988 abstractVillager) {
            return new class_1338((class_1314)abstractVillager, this.clazz, this.acceptableDistance, 0.5, 0.5);
        }

        public void addAcceptableDistance(BiConsumer<class_1299<?>, Float> consumer) {
            consumer.accept(this.type.get(), Float.valueOf(this.acceptableDistance));
        }
    }
}

