/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.api;

import com.nenio.blockenchants.BlockEnchantData;
import com.nenio.blockenchants.BlockEnchantState;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public final class BlockEnchantLookup {
    private static final String ENCHANT_PATH = "honey_overflow";

    private BlockEnchantLookup() {
    }

    public static int getHoneyReserveLevel(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return 0;
        }
        class_3218 sw = (class_3218)world;
        BlockEnchantData data = BlockEnchantState.get(sw).get(pos);
        if (data == null || data.levels == null || data.levels.isEmpty()) {
            return 0;
        }
        int lvl = 0;
        for (Map.Entry<class_2960, Integer> e : data.levels.entrySet()) {
            class_2960 id = e.getKey();
            Integer v = e.getValue();
            if (id == null || !ENCHANT_PATH.equals(id.method_12832()) || v == null || v <= lvl) continue;
            lvl = v;
        }
        if (lvl < 0) {
            lvl = 0;
        }
        if (lvl > 5) {
            lvl = 5;
        }
        return lvl;
    }

    public static int getExtraCap(class_1937 world, class_2338 pos) {
        int lvl = BlockEnchantLookup.getHoneyReserveLevel(world, pos);
        int cap = lvl * 5;
        if (cap > 25) {
            cap = 25;
        }
        return cap;
    }
}

