/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture;

import java.util.function.Consumer;

public class ByteCollector {
    private final Consumer<byte[]> callback;
    private byte[] bytes = null;
    private int offset = 0;

    public ByteCollector(Consumer<byte[]> callback) {
        this.callback = callback;
    }

    public int getCurrentLength() {
        return this.offset;
    }

    public boolean push(byte[] bytes, int bytesLeft) {
        if (this.bytes == null) {
            this.bytes = new byte[bytes.length + bytesLeft];
        }
        if (this.offset + bytes.length + bytesLeft != this.bytes.length) {
            return false;
        }
        System.arraycopy(bytes, 0, this.bytes, this.offset, bytes.length);
        this.offset += bytes.length;
        if (bytesLeft == 0) {
            this.callback.accept(this.bytes);
        }
        return true;
    }

    public static void split(byte[] bytes, int sectionSize, SectionConsumer callback) {
        int size;
        int offset = 0;
        for (int bytesLeft = bytes.length; bytesLeft > 0; bytesLeft -= size) {
            size = Math.min(sectionSize, bytesLeft);
            byte[] section = new byte[size];
            System.arraycopy(bytes, offset, section, 0, size);
            callback.accept(section, bytesLeft - size);
            offset += size;
        }
    }

    public static interface SectionConsumer {
        public void accept(byte[] var1, int var2);
    }
}

