/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanCloneLayer;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanDeathLayer;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanEyesLayer;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanHeldBlocksLayer;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanScreamLayer;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanTeleportLayer;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantEndermanRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_4048;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_927;
import org.jetbrains.annotations.Nullable;

public class MutantEndermanRenderer
extends class_927<MutantEnderman, MutantEndermanRenderState, MutantEndermanModel> {
    public static final class_2960 TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_enderman/mutant_enderman.png");
    private final MutantEndermanTeleportLayer teleportLayer;

    public MutantEndermanRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new MutantEndermanModel(context.method_32167(ModelLayerLocations.MUTANT_ENDERMAN)), 0.8f);
        this.method_4046(new MutantEndermanDeathLayer((class_3883<MutantEndermanRenderState, MutantEndermanModel>)this));
        this.method_4046(new MutantEndermanEyesLayer((class_3883<MutantEndermanRenderState, MutantEndermanModel>)this));
        this.method_4046(new MutantEndermanCloneLayer((class_3883<MutantEndermanRenderState, MutantEndermanModel>)this, context.method_32170()));
        this.teleportLayer = new MutantEndermanTeleportLayer((class_3883<MutantEndermanRenderState, MutantEndermanModel>)this);
        this.method_4046(this.teleportLayer);
        this.method_4046(new MutantEndermanScreamLayer((class_3883<MutantEndermanRenderState, MutantEndermanModel>)this));
        this.method_4046(new MutantEndermanHeldBlocksLayer((class_3883<MutantEndermanRenderState, MutantEndermanModel>)this, context.method_43337()));
    }

    public boolean shouldRender(MutantEnderman mutantEnderman, class_4604 camera, double camX, double camY, double camZ) {
        if (super.method_3933((class_1297)mutantEnderman, camera, camX, camY, camZ)) {
            return true;
        }
        if (mutantEnderman.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
            return mutantEnderman.getTeleportPosition().map(class_243::method_24955).map(arg_0 -> ((class_4048)mutantEnderman.method_5864().method_18386()).method_30757(arg_0)).filter(arg_0 -> ((class_4604)camera).method_23093(arg_0)).isPresent();
        }
        return false;
    }

    public void render(MutantEndermanRenderState renderState, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        if (renderState.isClone) {
            this.field_4673 = 0.5f;
            this.field_4672 = 0.5f;
        } else {
            this.field_4673 = 0.8f;
            this.field_4672 = renderState.field_53449 > 80.0f ? 1.0f - MutantEndermanRenderer.getDeathProgress((class_10042)renderState) : 1.0f;
        }
        super.method_4054((class_10042)renderState, poseStack, bufferSource, packedLight);
        if (renderState.animation == MutantEnderman.TELEPORT_ANIMATION && renderState.teleportPosition != null) {
            poseStack.method_22903();
            poseStack.method_22904((double)renderState.teleportPosition.method_10263() + 0.5 - renderState.field_53325, (double)renderState.teleportPosition.method_10264() - renderState.field_53326, (double)renderState.teleportPosition.method_10260() + 0.5 - renderState.field_53327);
            this.teleportLayer.setShrinking(true);
            super.method_4054((class_10042)renderState, poseStack, bufferSource, packedLight);
            this.teleportLayer.setShrinking(false);
            poseStack.method_22909();
        }
    }

    public static float getDeathProgress(class_10042 renderState) {
        return (renderState.field_53449 - 80.0f) / ((float)MutantEnderman.DEATH_ANIMATION.duration() - 80.0f);
    }

    public class_243 getRenderOffset(MutantEndermanRenderState renderState) {
        return renderState.renderOffset != null ? renderState.renderOffset : super.method_23169((class_10017)renderState);
    }

    public void extractRenderState(MutantEnderman mutantEnderman, MutantEndermanRenderState reusedState, float partialTick) {
        super.method_62355((class_1309)mutantEnderman, (class_10042)reusedState, partialTick);
        reusedState.field_53460 = mutantEnderman.field_6235 > 0;
        reusedState.field_53322 = mutantEnderman.method_6510();
        reusedState.animationTime = mutantEnderman.getAnimationTick() > 0 ? (float)mutantEnderman.getAnimationTick() + partialTick : (float)mutantEnderman.getAnimationTick();
        reusedState.animation = mutantEnderman.getAnimation();
        reusedState.armScale = mutantEnderman.getArmScale(partialTick);
        reusedState.isClone = mutantEnderman.isClone();
        for (int i = 0; i < reusedState.heldBlocks.length; ++i) {
            reusedState.heldBlocks[i] = mutantEnderman.getHeldBlock(i).orElse(null);
        }
        reusedState.activeArm = mutantEnderman.getActiveArm();
        boolean hasTarget = mutantEnderman.hasTargetTicks > 0;
        for (int i = 0; i < mutantEnderman.heldBlockTicks.length; ++i) {
            reusedState.heldBlockTicks[i] = (float)mutantEnderman.heldBlockTicks[i] + (mutantEnderman.heldBlockTicks[i] > 0 ? (hasTarget ? partialTick : -partialTick) : 0.0f);
        }
        reusedState.teleportPosition = mutantEnderman.getTeleportPosition().orElse(null);
        reusedState.renderOffset = this.getRenderOffset(mutantEnderman);
    }

    @Nullable
    private class_243 getRenderOffset(MutantEnderman mutantEnderman) {
        boolean death;
        boolean stare = mutantEnderman.getAnimation() == MutantEnderman.STARE_ANIMATION;
        boolean scream = mutantEnderman.getAnimation() == MutantEnderman.SCREAM_ANIMATION;
        boolean clone = mutantEnderman.isClone() && mutantEnderman.method_6510();
        boolean telesmash = mutantEnderman.getAnimation() == MutantEnderman.TELESMASH_ANIMATION && (float)mutantEnderman.getAnimationTick() < 18.0f;
        boolean bl = death = mutantEnderman.getAnimation() == MutantEnderman.DEATH_ANIMATION;
        if (stare || scream || clone || telesmash || death) {
            double shake = 0.03;
            if (clone) {
                shake = 0.02;
            } else if (death) {
                shake = (float)mutantEnderman.getAnimationTick() < 80.0f ? 0.02 : 0.05;
            } else if ((float)mutantEnderman.getAnimationTick() >= 40.0f) {
                shake *= 0.5;
            }
            return new class_243(mutantEnderman.method_59922().method_43059() * shake, 0.0, mutantEnderman.method_59922().method_43059() * shake);
        }
        return null;
    }

    public MutantEndermanRenderState createRenderState() {
        return new MutantEndermanRenderState();
    }

    public class_2960 getTextureLocation(MutantEndermanRenderState renderState) {
        return TEXTURE_LOCATION;
    }

    public class_1921 getRenderType(MutantEndermanRenderState renderState, boolean bodyVisible, boolean translucent, boolean glowing) {
        if (renderState.isClone || renderState.field_53449 > 80.0f) {
            return null;
        }
        return super.method_24302((class_10042)renderState, bodyVisible, translucent, glowing);
    }

    protected float method_3919() {
        return 0.0f;
    }

    protected class_238 getBoundingBoxForCulling(MutantEnderman mutantEnderman) {
        return super.method_62463((class_1309)mutantEnderman).method_1014(3.0);
    }
}

