/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FreezerBlock;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.FridgeBlockEntity;
import com.mrcrayfish.furniture.refurbished.data.DropWithName;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier,
DropWithName {
    private static final MapCodec<FridgeBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)MetalType.CODEC.fieldOf("metal_type").forGetter(block -> block.type), (App)FridgeBlock.method_54096()).apply((Applicative)builder, FridgeBlock::new));
    protected final MetalType type;

    public FridgeBlock(MetalType type, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)DIRECTION, (Comparable)class_2350.field_11043)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public boolean isFreezer() {
        return false;
    }

    public MetalType getMetalType() {
        return this.type;
    }

    protected MapCodec<FridgeBlock> method_53969() {
        return CODEC;
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 closedShape = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        class_265 openShape = class_2248.method_9541((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (class_2680 state : states) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)DIRECTION);
            boolean open = (Boolean)state.method_11654((class_2769)OPEN);
            ArrayList<class_265> shapes = new ArrayList<class_265>();
            shapes.add(VoxelShapeHelper.rotateHorizontally(open ? openShape : closedShape, direction));
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    public class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 result) {
        if (((class_2350)state.method_11654((class_2769)DIRECTION)).method_10153() == result.method_17780()) {
            class_2586 class_25862;
            if (!level.method_8608() && (class_25862 = level.method_8321(pos)) instanceof FridgeBlockEntity) {
                FridgeBlockEntity fridge = (FridgeBlockEntity)class_25862;
                player.method_17355((class_3908)fridge);
                return class_1269.field_21466;
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 belowPos;
        class_2680 belowState;
        if (!this.isFreezer() && !level.method_8608() && (belowState = level.method_8320(belowPos = pos.method_10074())).method_26204() instanceof FreezerBlock) {
            level.method_8652(belowPos, class_2246.field_10124.method_9564(), 35);
            level.method_8444(null, 2001, belowPos, class_2248.method_9507((class_2680)belowState));
        }
        return super.method_9576(level, pos, state, player);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{OPEN});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FridgeBlockEntity(pos, state);
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BasicLootBlockEntity) {
            BasicLootBlockEntity entity = (BasicLootBlockEntity)class_25862;
            entity.updateOpenerCount();
        }
    }

    @Override
    public List<class_6862<class_2248>> getTags() {
        return List.of(class_3481.field_33715, class_3481.field_33719);
    }
}

