/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.RangeHoodBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlipAnimation;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2802;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class GrillBlockEntity
extends class_2586
implements class_1278 {
    public static final int[] ALL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final int[] GRILL_SLOTS = new int[]{9, 10, 11, 12};
    private final class_2371<class_1799> fuel = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private final class_2371<class_1799> cooking = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private final ImmutableList<CookingSpace> spaces;
    protected final class_1863.class_7266<class_9696, ? extends ProcessingRecipe> recipeCache;
    protected final class_1863.class_7266<class_9696, ? extends class_1874> campfireCookingCache;
    private int remainingFuel;
    private float storedExperience;

    public GrillBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.GRILL.get(), pos, state, (class_3956<? extends ProcessingRecipe.Item>)((class_3956)ModRecipeTypes.GRILL_COOKING.get()));
    }

    protected GrillBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, class_3956<? extends ProcessingRecipe.Item> recipeType) {
        super(type, pos, state);
        this.recipeCache = class_1863.method_42302(recipeType);
        this.campfireCookingCache = class_1863.method_42302((class_3956)class_3956.field_17549);
        this.spaces = (ImmutableList)class_156.method_656(() -> {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.cooking.size());
            IntStream.range(0, this.cooking.size()).forEach(i -> builder.add((Object)new CookingSpace(i, this)));
            return builder.build();
        });
    }

    public CookingSpace getCookingSpace(int position) {
        return (CookingSpace)this.spaces.get(position);
    }

    public class_2371<class_1799> getCookingItems() {
        return this.cooking;
    }

    public class_2371<class_1799> getFuelItems() {
        return this.fuel;
    }

    public boolean addCookingItem(class_1799 stack, int position, int rotation) {
        Optional<? extends ProcessingRecipe> optional;
        if (((class_1799)this.cooking.get(position)).method_7960() && (optional = this.getRecipe(stack)).isPresent()) {
            ProcessingRecipe recipe = optional.get();
            class_1799 copy = stack.method_7972();
            copy.method_7939(1);
            this.cooking.set(position, (Object)copy);
            ((CookingSpace)this.spaces.get(position)).update(recipe.getTime(), 0.0f, rotation);
            this.syncCookingSpace(position);
            this.playPlaceSound((CookingSpace)this.spaces.get(position), false, 0.85f);
            this.method_5431();
            return true;
        }
        return false;
    }

    public boolean addFuel(class_1799 stack) {
        if (stack.method_7909() == class_1802.field_8665) {
            for (int i = 0; i < this.fuel.size(); ++i) {
                if (!((class_1799)this.fuel.get(i)).method_7960()) continue;
                class_1799 fuel = stack.method_7972();
                fuel.method_7939(1);
                this.fuel.set(i, (Object)fuel);
                this.syncFuel();
                this.method_5431();
                return true;
            }
        }
        return false;
    }

    public void flipItem(int position) {
        if (position >= 0 && position < this.cooking.size() && !((class_1799)this.cooking.get(position)).method_7960()) {
            CookingSpace space = (CookingSpace)this.spaces.get(position);
            if (space.isHalfCooked()) {
                space.flip();
                this.sendFlipAnimationToPlayers(position);
                this.syncCookingSpace(position);
                this.method_5431();
            } else if (space.isFullyCooked()) {
                this.removeCookingItem(position);
            }
        }
    }

    private void sendFlipAnimationToPlayers(int position) {
        class_1937 level = Objects.requireNonNull(this.field_11863);
        class_2802 class_28022 = level.method_8398();
        if (class_28022 instanceof class_3215) {
            class_3215 cache = (class_3215)class_28022;
            class_2338 pos = this.method_11016();
            List players = cache.field_17254.method_17210(new class_1923(pos), false);
            players.forEach(player -> Network.getPlay().sendToPlayer(() -> player, (Object)new MessageFlipAnimation(pos, position)));
        }
    }

    public boolean flipItems() {
        for (int i = 0; i < 4; ++i) {
            if (((class_1799)this.cooking.get(i)).method_7960() || !((CookingSpace)this.spaces.get(i)).isHalfCooked()) continue;
            this.flipItem(i);
            return true;
        }
        return false;
    }

    public void removeCookingItem(int position) {
        if (position >= 0 && position < this.cooking.size() && !((class_1799)this.cooking.get(position)).method_7960()) {
            double posX = (double)this.field_11867.method_10263() + 0.3 + 0.4 * (double)(position % 2);
            double posY = (double)this.field_11867.method_10264() + 1.0;
            double posZ = (double)this.field_11867.method_10260() + 0.3 + 0.4 * (double)(position / 2);
            class_1542 entity = new class_1542(this.field_11863, posX, posY + 0.1, posZ, ((class_1799)this.cooking.get(position)).method_7972());
            this.field_11863.method_8649((class_1297)entity);
            this.cooking.set(position, (Object)class_1799.field_8037);
            CookingSpace space = (CookingSpace)this.spaces.get(position);
            if (space.isFullyCooked()) {
                this.spawnExperience(posX, posY, posZ, space.getExperience());
            }
            space.update(0, 0.0f, 0);
            BlockEntityHelper.sendCustomUpdate((class_2586)this, this::writeCookingItems);
            this.method_5431();
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, GrillBlockEntity grill) {
        boolean canCook = grill.canCook();
        if (grill.remainingFuel == 0 && canCook) {
            for (int i = grill.fuel.size() - 1; i >= 0; --i) {
                class_1799 fuel = (class_1799)grill.fuel.get(i);
                if (fuel.method_7960()) continue;
                grill.remainingFuel = level.method_61269().method_61755(fuel);
                grill.fuel.set(i, (Object)class_1799.field_8037);
                grill.method_5431();
                BlockEntityHelper.sendCustomUpdate((class_2586)grill, output -> {
                    grill.writeFuel((class_11372)output);
                    grill.writeRemainingFuel((class_11372)output);
                });
                break;
            }
        }
        if (canCook && grill.remainingFuel > 0) {
            grill.cookItems();
            --grill.remainingFuel;
            grill.method_5431();
            if (grill.remainingFuel == 0) {
                BlockEntityHelper.sendCustomUpdate((class_2586)grill, grill::writeRemainingFuel);
            }
        }
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, GrillBlockEntity grill) {
        grill.spawnParticles();
        grill.spaces.forEach(space -> {
            AudioManager.get().playLevelAudio((ILevelAudio)space);
            FlipAnimation animation = space.getAnimation();
            boolean wasPlaying = animation.isPlaying();
            animation.tick();
            if (wasPlaying && !animation.isPlaying()) {
                grill.playPlaceSound((CookingSpace)space, true, 1.0f);
            }
        });
    }

    private boolean canCook() {
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space = (CookingSpace)this.spaces.get(i);
            if (((class_1799)this.cooking.get(i)).method_7960() || !space.canCook()) continue;
            return true;
        }
        return false;
    }

    private void cookItems() {
        boolean changed = false;
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space;
            if (((class_1799)this.cooking.get(i)).method_7960() || !(space = (CookingSpace)this.spaces.get(i)).canCook()) continue;
            space.cook();
            if (!space.isCooked()) continue;
            if (space.isFlipped()) {
                class_1937 level = Objects.requireNonNull(this.field_11863);
                Optional<? extends ProcessingRecipe> optional = this.getRecipe((class_1799)this.cooking.get(i));
                if (optional.isPresent()) {
                    this.cooking.set(i, (Object)optional.get().getResult().method_7972());
                }
            }
            this.syncCookingSpace(i);
            changed = true;
        }
        if (changed) {
            BlockEntityHelper.sendCustomUpdate((class_2586)this, this::writeCookingItems);
            this.method_5431();
        }
    }

    private void spawnParticles() {
        class_1937 level = this.method_10997();
        if (level != null) {
            if (this.isCooking()) {
                double posX = (double)this.field_11867.method_10263() + 0.2 + 0.6 * level.field_9229.method_43058();
                double posY = (double)this.field_11867.method_10264() + 0.85;
                double posZ = (double)this.field_11867.method_10260() + 0.2 + 0.6 * level.field_9229.method_43058();
                level.method_8406((class_2394)class_2398.field_11240, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
            for (int i = 0; i < this.cooking.size(); ++i) {
                CookingSpace space;
                if (((class_1799)this.cooking.get(i)).method_7960()) continue;
                if (level.field_9229.method_43057() < 0.1f && (space = (CookingSpace)this.spaces.get(i)).isHalfCooked()) {
                    class_243 spacePos = space.getWorldPosition();
                    for (int j = 0; j < 4; ++j) {
                        level.method_8406((class_2394)class_2398.field_11251, spacePos.field_1352, spacePos.field_1351, spacePos.field_1350, 0.0, 0.0, 0.0);
                    }
                }
                space = (CookingSpace)this.spaces.get(i);
                if (this.remainingFuel <= 0 || !space.canCook() || space.isCooked() || space.getAnimation().isPlaying()) continue;
                class_243 spacePos = space.getWorldPosition();
                spacePos = spacePos.method_1031(0.05 * level.field_9229.method_43059(), 0.0, 0.05 * level.field_9229.method_43059());
                this.spawnSteam(level, spacePos.field_1352, spacePos.field_1351, spacePos.field_1350);
            }
        }
    }

    public void spawnSteam(class_1937 level, double x, double y, double z) {
        double ySpeed = 0.01;
        if (this.isRangeHoodPowered(level, this.field_11867.method_10086(2))) {
            ySpeed = 0.05;
        } else if (this.isRangeHoodPowered(level, this.field_11867.method_10086(3))) {
            ySpeed = 0.1;
        }
        level.method_8406((class_2394)ModParticleTypes.STEAM.get(), x, y, z, 0.0, ySpeed, 0.0);
    }

    private boolean isRangeHoodPowered(class_1937 level, class_2338 pos) {
        class_2338 start = this.field_11867.method_10084();
        while (start.method_10264() < pos.method_10264()) {
            if (!level.method_8320(start).method_26215()) {
                return false;
            }
            start = start.method_10084();
        }
        class_2680 state = level.method_8320(pos);
        if (state.method_26204() instanceof RangeHoodBlock) {
            return (Boolean)state.method_11654((class_2769)RangeHoodBlock.POWERED);
        }
        return false;
    }

    private boolean isCooking() {
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space = (CookingSpace)this.spaces.get(i);
            if (((class_1799)this.cooking.get(i)).method_7960() || !space.canCook() && !space.isHalfCooked()) continue;
            return this.remainingFuel > 0;
        }
        return false;
    }

    private Optional<? extends ProcessingRecipe> getRecipe(class_1799 stack) {
        Optional<? extends ProcessingRecipe> optional = this.getRecipeFromCache(this.recipeCache, stack);
        if (((Boolean)Config.SERVER.recipes.inheritCampfireRecipes.get()).booleanValue()) {
            optional = optional.isEmpty() ? this.getCookingRecipeFromCache(this.campfireCookingCache, stack) : optional;
        }
        return optional;
    }

    private Optional<? extends ProcessingRecipe> getRecipeFromCache(class_1863.class_7266<class_9696, ? extends ProcessingRecipe> cache, class_1799 stack) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            return cache.method_42303((class_9695)new class_9696(stack), serverLevel).map(class_8786::comp_1933);
        }
        return Optional.empty();
    }

    private Optional<? extends ProcessingRecipe> getCookingRecipeFromCache(class_1863.class_7266<class_9696, ? extends class_1874> cache, class_1799 stack) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            return cache.method_42303((class_9695)new class_9696(stack), serverLevel).map(class_8786::comp_1933).map(recipe -> ProcessingRecipe.Item.fromCookingRecipe(recipe, this.field_11863.method_30349()));
        }
        return Optional.empty();
    }

    public int method_5439() {
        return this.fuel.size() + this.cooking.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.fuel) {
            if (stack.method_7960()) continue;
            return false;
        }
        for (class_1799 stack : this.cooking) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int index) {
        if (index - this.fuel.size() >= 0) {
            return (class_1799)this.cooking.get(index - this.fuel.size());
        }
        return (class_1799)this.fuel.get(index);
    }

    public class_1799 method_5434(int index, int count) {
        if (index - this.fuel.size() >= 0) {
            class_1799 result = class_1262.method_5430(this.cooking, (int)(index -= this.fuel.size()), (int)count);
            if (!result.method_7960()) {
                this.method_5431();
            }
            if (((class_1799)this.cooking.get(index)).method_7960()) {
                CookingSpace space = (CookingSpace)this.spaces.get(index);
                if (space.isFullyCooked()) {
                    double posX = (double)this.field_11867.method_10263() + 0.3 + 0.4 * (double)(index % 2);
                    double posY = (double)this.field_11867.method_10264() + 1.0;
                    double posZ = (double)this.field_11867.method_10260() + 0.3 + 0.4 * (double)(index / 2);
                    this.spawnExperience(posX, posY, posZ, space.getExperience());
                }
                space.update(0, 0.0f, 0);
            }
            BlockEntityHelper.sendCustomUpdate((class_2586)this, output -> {
                this.writeCookingItems((class_11372)output);
                this.writeFuel((class_11372)output);
            });
            return result;
        }
        class_1799 result = class_1262.method_5430(this.fuel, (int)index, (int)count);
        if (!result.method_7960()) {
            this.method_5431();
        }
        this.syncFuel();
        return result;
    }

    public class_1799 method_5441(int index) {
        if (index - this.fuel.size() >= 0) {
            return class_1262.method_5428(this.cooking, (int)(index - this.fuel.size()));
        }
        return class_1262.method_5428(this.fuel, (int)index);
    }

    public void method_5447(int index, class_1799 stack) {
        class_2371<class_1799> inventory = this.fuel;
        if (index - this.fuel.size() >= 0) {
            index -= this.fuel.size();
            inventory = this.cooking;
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(stack);
            if (optional.isPresent()) {
                ProcessingRecipe recipe = optional.get();
                ((CookingSpace)this.spaces.get(index)).update(recipe.getTime(), 0.0f, 0);
                this.syncCookingSpace(index);
            }
        }
        inventory.set(index, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        BlockEntityHelper.sendCustomUpdate((class_2586)this, output -> {
            this.writeCookingItems((class_11372)output);
            this.writeFuel((class_11372)output);
        });
        this.method_5431();
    }

    public int method_5444() {
        return 1;
    }

    public void method_5448() {
        this.fuel.clear();
        this.cooking.clear();
    }

    public void method_11014(class_11368 input) {
        super.method_11014(input);
        BlockEntityHelper.loadItems("Grill", input, this.cooking);
        BlockEntityHelper.loadItems("Fuel", input, this.fuel);
        input.method_71439("RemainingFuel").ifPresent(value -> {
            this.remainingFuel = value;
        });
        input.method_71426("StoredExperience", (Codec)Codec.FLOAT).ifPresent(value -> {
            this.storedExperience = value.floatValue();
        });
        this.readCookingSpaces(input);
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.writeCookingItems(output);
        this.writeFuel(output);
        this.writeRemainingFuel(output);
        this.writeCookingSpaces(output);
        output.method_71468("StoredExperience", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.storedExperience));
    }

    private void writeCookingItems(class_11372 output) {
        BlockEntityHelper.saveItems("Grill", output, this.cooking);
    }

    private void writeFuel(class_11372 output) {
        BlockEntityHelper.saveItems("Fuel", output, this.fuel);
    }

    private void writeRemainingFuel(class_11372 output) {
        output.method_71465("RemainingFuel", this.remainingFuel);
    }

    private void writeCookingSpaces(class_11372 output) {
        this.writeCookingSpaces(output, -1);
    }

    private void writeCookingSpaces(class_11372 output, int position) {
        class_11372.class_11374 list = output.method_71476("CookingSpaces");
        if (position >= 0 && position < this.spaces.size()) {
            class_11372 spaceOutput = list.method_71480();
            spaceOutput.method_71465("Position", position);
            ((CookingSpace)this.spaces.get(position)).writeToTag(spaceOutput);
        } else if (position == -1) {
            for (int i = 0; i < this.spaces.size(); ++i) {
                class_11372 spaceOutput = list.method_71480();
                spaceOutput.method_71465("Position", i);
                ((CookingSpace)this.spaces.get(i)).writeToTag(spaceOutput);
            }
        }
        if (list.method_71482()) {
            output.method_71478("CookingSpaces");
        }
    }

    private void readCookingSpaces(class_11368 input) {
        input.method_71436("CookingSpaces").ifPresent(list -> list.forEach(spaceInput -> {
            int position = spaceInput.method_71424("Position", -1);
            if (position >= 0 && position < this.spaces.size()) {
                ((CookingSpace)this.spaces.get(position)).readFromInput((class_11368)spaceInput);
            }
        }));
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public int[] method_5494(class_2350 side) {
        return side == class_2350.field_11033 ? GRILL_SLOTS : ALL_SLOTS;
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        if (!this.method_5438(index).method_7960()) {
            return false;
        }
        if (index - this.fuel.size() >= 0) {
            return this.getRecipe(stack).isPresent();
        }
        return stack.method_7909() == class_1802.field_8713 || stack.method_7909() == class_1802.field_8665;
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        if (direction == class_2350.field_11033 && index - this.fuel.size() >= 0 && ((CookingSpace)this.spaces.get(index -= this.fuel.size())).isFullyCooked()) {
            return this.getRecipe(stack).isEmpty();
        }
        return false;
    }

    private void playPlaceSound(CookingSpace space, boolean client, float pitch) {
        class_1937 level = Objects.requireNonNull(this.field_11863);
        class_243 pos = space.getWorldPosition();
        if (client) {
            level.method_8486(pos.field_1352, pos.field_1351, pos.field_1350, (class_3414)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), class_3419.field_15248, 1.0f, pitch, false);
            return;
        }
        level.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, (class_3414)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), class_3419.field_15248, 1.0f, pitch);
    }

    private void syncCookingSpace(int position) {
        BlockEntityHelper.sendCustomUpdate((class_2586)this, output -> {
            this.writeCookingItems((class_11372)output);
            this.writeCookingSpaces((class_11372)output, position);
        });
    }

    private void syncFuel() {
        BlockEntityHelper.sendCustomUpdate((class_2586)this, this::writeFuel);
    }

    private void spawnExperience(double x, double y, double z, float exp) {
        class_1937 class_19372;
        this.storedExperience += Math.max(exp, 0.0f);
        if ((float)class_3532.method_15375((float)this.storedExperience) >= 1.0f && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            int amount = class_3532.method_15375((float)this.storedExperience);
            class_1303.method_31493((class_3218)level, (class_243)new class_243(x, y, z), (int)amount);
            this.storedExperience = Math.max(this.storedExperience - (float)amount, 0.0f);
        }
    }

    public void playFlipAnimation(int position) {
        if (Objects.requireNonNull(this.field_11863).method_8608() && position >= 0 && position < this.spaces.size()) {
            ((CookingSpace)this.spaces.get(position)).getAnimation().play();
        }
    }

    public static class CookingSpace
    implements ILevelAudio {
        public static final double MAX_AUDIO_DISTANCE = class_3532.method_34954((int)8);
        private final int index;
        private final GrillBlockEntity grill;
        private int cookingTime = 0;
        private int totalCookingTime = 0;
        private boolean flipped = false;
        private float experience = 0.0f;
        private int rotation = 0;
        private FlipAnimation animation;

        public CookingSpace(int index, GrillBlockEntity grill) {
            this.index = index;
            this.grill = grill;
        }

        public boolean isFlipped() {
            return this.flipped;
        }

        public float getExperience() {
            return this.experience;
        }

        public int getRotation() {
            return this.rotation;
        }

        public void cook() {
            if (this.cookingTime < this.totalCookingTime) {
                ++this.cookingTime;
            }
        }

        public boolean isCooked() {
            return this.cookingTime == this.totalCookingTime;
        }

        public boolean isHalfCooked() {
            return !this.flipped && this.cookingTime == this.totalCookingTime;
        }

        public boolean isFullyCooked() {
            return this.flipped && this.cookingTime == this.totalCookingTime;
        }

        public boolean canCook() {
            return this.cookingTime < this.totalCookingTime;
        }

        public void update(int cookTime, float experience, int rotation) {
            this.cookingTime = 0;
            this.totalCookingTime = cookTime / 2;
            this.flipped = false;
            this.experience = experience;
            this.rotation = rotation;
        }

        public void flip() {
            if (!this.flipped) {
                this.flipped = true;
                this.cookingTime = 0;
            }
        }

        public class_243 getWorldPosition() {
            class_2338 pos = this.grill.field_11867;
            double x = (double)pos.method_10263() + 0.3 + 0.4 * (double)(this.index % 2);
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.3 + 0.4 * (double)(this.index / 2);
            return new class_243(x, y, z);
        }

        public void writeToTag(class_11372 output) {
            output.method_71465("CookingTime", this.cookingTime);
            output.method_71465("TotalCookingTime", this.totalCookingTime);
            output.method_71468("Flipped", (Codec)Codec.BOOL, (Object)this.flipped);
            output.method_71468("Experience", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.experience));
            output.method_71465("Rotation", this.rotation);
        }

        public void readFromInput(class_11368 input) {
            input.method_71439("CookingTime").ifPresent(value -> {
                this.cookingTime = value;
            });
            input.method_71439("TotalCookingTime").ifPresent(value -> {
                this.totalCookingTime = value;
            });
            input.method_71426("Flipped", (Codec)Codec.BOOL).ifPresent(value -> {
                this.flipped = value;
            });
            input.method_71426("Experience", (Codec)Codec.FLOAT).ifPresent(value -> {
                this.experience = value.floatValue();
            });
            input.method_71439("Rotation").ifPresent(value -> {
                this.rotation = value;
            });
        }

        public FlipAnimation getAnimation() {
            if (this.animation == null) {
                this.animation = new FlipAnimation();
            }
            return this.animation;
        }

        @Override
        public class_3414 getSound() {
            return (class_3414)ModSounds.BLOCK_FRYING_PAN_SIZZLING.get();
        }

        @Override
        public class_3419 getSource() {
            return class_3419.field_15245;
        }

        @Override
        public class_243 getAudioPosition() {
            return this.getWorldPosition();
        }

        @Override
        public boolean canPlayAudio() {
            return !this.grill.method_11015() && this.grill.remainingFuel > 0 && !((class_1799)this.grill.cooking.get(this.index)).method_7960() && (!this.isCooked() || this.isHalfCooked());
        }

        @Override
        public float getAudioVolume() {
            return (this.canCook() && !this.isCooked() || this.isHalfCooked()) && !this.getAnimation().isPlaying() ? 1.0f : 0.0f;
        }

        @Override
        public float getAudioPitch() {
            return this.isHalfCooked() ? 0.8f : 1.0f;
        }

        @Override
        public double getAudioRadiusSqr() {
            return MAX_AUDIO_DISTANCE;
        }

        @Override
        public int getAudioHash() {
            return Objects.hash(this.grill.field_11867, this.index);
        }

        @Override
        public boolean isAudioEqual(ILevelAudio other) {
            return other == this;
        }
    }
}

