/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.OnOffSlider;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.inventory.ElectricityGeneratorMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_5250;

public class ElectricityGeneratorScreen
extends class_465<ElectricityGeneratorMenu> {
    private static final class_2960 TEXTURE = Utils.resource("textures/gui/container/electricity_generator.png");
    protected OnOffSlider slider;

    public ElectricityGeneratorScreen(ElectricityGeneratorMenu menu, class_1661 inventory, class_2561 title) {
        super((class_1703)menu, inventory, title);
    }

    protected void method_25426() {
        super.method_25426();
        this.slider = (OnOffSlider)this.method_37063((class_364)new OnOffSlider(this.field_2776 + this.field_2792 - 22 - 6, this.field_2800 + 5, (class_2561)Utils.translation("gui", "generator_toggle", new Object[0]), btn -> Network.getPlay().sendToServer((Object)new MessageTogglePower())));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.slider.setEnabled(((ElectricityGeneratorMenu)this.field_2797).isEnabled());
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        this.method_2380(graphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 graphics, float partialTick, int mouseX, int mouseY) {
        graphics.method_25290(class_10799.field_56883, TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        if (((ElectricityGeneratorMenu)this.field_2797).getEnergy() > 0 && ((ElectricityGeneratorMenu)this.field_2797).getTotalEnergy() > 0) {
            float normalEnergy = (float)((ElectricityGeneratorMenu)this.field_2797).getEnergy() / (float)((ElectricityGeneratorMenu)this.field_2797).getTotalEnergy();
            int v = (int)Math.ceil(14.0f * normalEnergy);
            graphics.method_25290(class_10799.field_56883, TEXTURE, this.field_2776 + 26, this.field_2800 + 25 + 14 - v, 176.0f, (float)(14 - v), 14, v, 256, 256);
        }
        Status status = this.getStatus();
        graphics.method_25290(class_10799.field_56883, IconButton.ICON_TEXTURES, this.field_2776 + 66, this.field_2800 + 29, (float)status.iconU, (float)status.iconV, 10, 10, 64, 64);
        graphics.method_25290(class_10799.field_56883, IconButton.ICON_TEXTURES, this.field_2776 + 66, this.field_2800 + 46, 0.0f, 10.0f, 10, 10, 64, 64);
        if (((ElectricityGeneratorMenu)this.field_2797).getEnergy() > 0 && ((ElectricityGeneratorMenu)this.field_2797).getTotalEnergy() > 0 && ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.field_2776 + 26, this.field_2800 + 25, 14, 14)) {
            graphics.method_71276((class_2561)Utils.translation("gui", "progress", ((ElectricityGeneratorMenu)this.field_2797).getEnergy(), Components.GUI_SLASH, ((ElectricityGeneratorMenu)this.field_2797).getTotalEnergy()), mouseX, mouseY);
        }
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        super.method_2388(graphics, mouseX, mouseY);
        Status status = this.getStatus();
        graphics.method_51439(this.field_22793, status.label, 80, 30, status.textColour, true);
        Pair<class_2561, Integer> pair = this.getNodeCount();
        graphics.method_51439(this.field_22793, (class_2561)pair.left(), 80, 47, ((Integer)pair.right()).intValue(), true);
    }

    private Pair<class_2561, Integer> getNodeCount() {
        int nodeCount = ((ElectricityGeneratorMenu)this.field_2797).getNodeCount();
        int maxNodeCount = (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
        class_5250 label = Utils.translation("gui", "node_count", nodeCount, maxNodeCount);
        int textColour = nodeCount > maxNodeCount ? -3983818 : -1;
        return Pair.of((Object)label, (Object)textColour);
    }

    private Status getStatus() {
        if (((ElectricityGeneratorMenu)this.field_2797).isOverloaded()) {
            return Status.OVERLOADED;
        }
        if (((ElectricityGeneratorMenu)this.field_2797).isEnabled()) {
            if (((ElectricityGeneratorMenu)this.field_2797).isPowered()) {
                return Status.ONLINE;
            }
            if (((ElectricityGeneratorMenu)this.field_2797).getEnergy() == 0) {
                return Status.NO_FUEL;
            }
        }
        return Status.OFFLINE;
    }

    private static enum Status {
        ONLINE(-8799453, 50, 0, (class_2561)Utils.translation("gui", "status.online", new Object[0])),
        OFFLINE(-3983818, 40, 0, (class_2561)Utils.translation("gui", "status.offline", new Object[0])),
        OVERLOADED(-2711764, 30, 0, (class_2561)Utils.translation("gui", "status.overloaded", new Object[0])),
        NO_FUEL(-2711764, 10, 10, (class_2561)Utils.translation("gui", "status.no_fuel", new Object[0]));

        private final int textColour;
        private final int iconU;
        private final int iconV;
        private final class_2561 label;

        private Status(int textColour, int iconU, int iconV, class_2561 label) {
            this.textColour = textColour;
            this.iconU = iconU;
            this.iconV = iconV;
            this.label = label;
        }
    }
}

