/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.core.mc1216;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.NbtUtil;

public class NbtDataConverter {
    public static void nbt2writeData(class_2487 nbt, class_11372 view) {
        if (nbt == null || view == null) {
            return;
        }
        ArrayList keys = new ArrayList(nbt.method_10541());
        for (String key : keys) {
            class_2520 value = nbt.method_10580(key);
            if (value == null) continue;
            byte type = value.method_10711();
            view.method_71462("__nbttype_" + key + "__", type);
            switch (type) {
                case 1: {
                    Optional optional = value.method_68600();
                    if (optional.isEmpty()) break;
                    view.method_71462(key, ((Byte)optional.get()).byteValue());
                    break;
                }
                case 2: {
                    Optional optionalShort = value.method_68601();
                    if (optionalShort.isEmpty()) break;
                    view.method_71471(key, ((Short)optionalShort.get()).shortValue());
                    break;
                }
                case 3: {
                    Optional optionalInt = value.method_68602();
                    if (optionalInt.isEmpty()) break;
                    view.method_71465(key, ((Integer)optionalInt.get()).intValue());
                    break;
                }
                case 4: {
                    Optional optionalLong = value.method_68603();
                    if (optionalLong.isEmpty()) break;
                    view.method_71466(key, ((Long)optionalLong.get()).longValue());
                    break;
                }
                case 5: {
                    Optional optionalFloat = value.method_68604();
                    if (optionalFloat.isEmpty()) break;
                    view.method_71464(key, ((Float)optionalFloat.get()).floatValue());
                    break;
                }
                case 6: {
                    Optional optionalDouble = value.method_68605();
                    if (optionalDouble.isEmpty()) break;
                    view.method_71463(key, ((Double)optionalDouble.get()).doubleValue());
                    break;
                }
                case 8: {
                    Optional optionalString = value.method_68658();
                    if (optionalString.isEmpty()) break;
                    view.method_71469(key, (String)optionalString.get());
                    break;
                }
                case 7: {
                    Optional optionalByteArray = value.method_68559();
                    if (optionalByteArray.isEmpty()) break;
                    byte[] byteArray = (byte[])optionalByteArray.get();
                    int[] intArray = new int[byteArray.length];
                    for (int i = 0; i < byteArray.length; ++i) {
                        intArray[i] = byteArray[i];
                    }
                    view.method_71473(key, intArray);
                    break;
                }
                case 11: {
                    Optional optionalIntArray = value.method_68572();
                    if (optionalIntArray.isEmpty()) break;
                    view.method_71473(key, (int[])optionalIntArray.get());
                    break;
                }
                case 12: {
                    Optional optionalLongArray = value.method_68593();
                    if (optionalLongArray.isEmpty()) break;
                    long[] longArray = (long[])optionalLongArray.get();
                    int[] longIntArray = new int[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        longIntArray[i] = (int)(longArray[i] & 0xFFFFFFFFL);
                    }
                    view.method_71473(key, longIntArray);
                    break;
                }
                case 10: {
                    Optional optionalCompound = value.method_68571();
                    if (optionalCompound.isEmpty()) break;
                    class_2487 nbt2 = (class_2487)optionalCompound.get();
                    view.method_71468(key, class_2487.field_25128, (Object)nbt2);
                }
            }
        }
        view.method_71469("__all_keys__", String.join((CharSequence)",", keys));
    }

    public static void data2nbt(class_11368 view, class_2487 nbt) {
        String[] keys;
        if (view == null || nbt == null) {
            return;
        }
        String keysStr = view.method_71428("__all_keys__", "");
        if (keysStr.isEmpty()) {
            return;
        }
        block13: for (String key : keys = keysStr.split(",")) {
            byte type;
            if (key == null || key.isEmpty() || (type = view.method_71421("__nbttype_" + key + "__", (byte)-1)) == -1) continue;
            switch (type) {
                case 1: {
                    nbt.method_10567(key, view.method_71421(key, (byte)0));
                    continue block13;
                }
                case 2: {
                    nbt.method_10575(key, (short)view.method_71432(key, (short)0));
                    continue block13;
                }
                case 3: {
                    nbt.method_10569(key, view.method_71424(key, 0));
                    continue block13;
                }
                case 4: {
                    nbt.method_10544(key, view.method_71425(key, 0L));
                    continue block13;
                }
                case 5: {
                    nbt.method_10548(key, view.method_71423(key, 0.0f));
                    continue block13;
                }
                case 6: {
                    nbt.method_10549(key, view.method_71422(key, 0.0));
                    continue block13;
                }
                case 8: {
                    nbt.method_10582(key, view.method_71428(key, ""));
                    continue block13;
                }
                case 7: {
                    int[] intArray = (int[])view.method_71442(key).get();
                    byte[] byteArray = new byte[intArray.length];
                    for (int i = 0; i < intArray.length; ++i) {
                        byteArray[i] = (byte)intArray[i];
                    }
                    nbt.method_10570(key, byteArray);
                    continue block13;
                }
                case 11: {
                    nbt.method_10539(key, (int[])view.method_71442(key).get());
                    continue block13;
                }
                case 12: {
                    int[] longIntArray = (int[])view.method_71442(key).get();
                    long[] longArray = new long[longIntArray.length];
                    for (int i = 0; i < longIntArray.length; ++i) {
                        longArray[i] = (long)longIntArray[i] & 0xFFFFFFFFL;
                    }
                    nbt.method_10564(key, longArray);
                    continue block13;
                }
                case 10: {
                    class_2487 nbt2 = (class_2487)view.method_71426(key, class_2487.field_25128).get();
                    nbt.method_10566(key, (class_2520)nbt2);
                    continue block13;
                }
                default: {
                    nbt.method_10582(key, "Unsupported NBT type: " + type);
                }
            }
        }
    }

    public static void data2nbt(class_11372 view, class_2487 nbt) {
        if (view == null || nbt == null) {
            return;
        }
        if (view instanceof class_11362) {
            NbtUtil.copyFrom(((class_11362)view).method_71475(), nbt);
        }
    }

    public static class_11372 nbt2writeData(class_2487 nbt, CompatRegistryLookup registryLookup) {
        class_11362 view = class_11362.method_71458((class_8942)class_8942.field_60348);
        NbtDataConverter.nbt2writeData(nbt, (class_11372)view);
        return view;
    }

    public static class_11368 nbt2readData(class_2487 nbt, CompatRegistryLookup registryLookup) {
        if (nbt == null) {
            nbt = NbtUtil.create();
        }
        return class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)registryLookup.getRegistryLookup(), (class_2487)nbt);
    }

    public static class_2487 data2nbt(class_11368 view) {
        class_2487 nbt = new class_2487();
        NbtDataConverter.data2nbt(view, nbt);
        return nbt;
    }

    public static class_2487 data2nbt(class_11372 view) {
        class_2487 nbt = new class_2487();
        NbtDataConverter.data2nbt(view, nbt);
        return nbt;
    }
}

