/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.core.TerraBlender;
import terrablender.worldgen.DefaultNetherRegion;
import terrablender.worldgen.DefaultOverworldRegion;

public class Regions {
    private static Map<RegionType, LinkedHashMap<class_2960, Region>> regions = Maps.newHashMap();
    private static Map<RegionType, Map<class_2960, Integer>> indices = Maps.newHashMap();

    public static void register(class_2960 name, Region region) {
        regions.get((Object)region.getType()).put(name, region);
        int index = regions.get((Object)region.getType()).size() - 1;
        indices.get((Object)region.getType()).put(name, index);
        TerraBlender.LOGGER.info("Registered region " + String.valueOf(name) + " to index " + index + " for type " + String.valueOf((Object)region.getType()));
    }

    public static void register(class_2960 name, int index, Region region) {
        ArrayList entries = Lists.newArrayList(regions.get((Object)region.getType()).entrySet());
        entries.add(index, Map.entry(name, region));
        regions.get((Object)region.getType()).clear();
        entries.forEach(entry -> regions.get((Object)region.getType()).put((class_2960)entry.getKey(), (Region)entry.getValue()));
        TerraBlender.LOGGER.info("Registered region " + String.valueOf(name) + " to index " + index + " for type " + String.valueOf((Object)region.getType()));
    }

    public static void register(Region region) {
        Regions.register(region.getName(), region);
    }

    public static void remove(RegionType type, class_2960 name) {
        if (!regions.get((Object)type).containsKey(name)) {
            return;
        }
        regions.get((Object)type).remove(name);
        TerraBlender.LOGGER.info("Removed region " + String.valueOf(name));
    }

    public static List<Region> get(RegionType type) {
        return ImmutableList.copyOf(regions.get((Object)type).values());
    }

    public static int getIndex(RegionType type, class_2960 location) {
        LinkedHashMap<class_2960, Region> typedRegions = regions.get((Object)type);
        Map<class_2960, Integer> typedIndices = indices.get((Object)type);
        if (typedIndices.containsKey(location)) {
            return typedIndices.get(location);
        }
        if (!typedRegions.containsKey(location)) {
            throw new RuntimeException("Attempted to get index of an unregistered region " + String.valueOf(location));
        }
        int index = ImmutableList.copyOf(typedRegions.keySet()).indexOf((Object)location);
        typedIndices.put(location, index);
        return index;
    }

    public static int getCount(RegionType type) {
        return regions.get((Object)type).size();
    }

    static {
        for (RegionType type : RegionType.values()) {
            regions.put(type, Maps.newLinkedHashMap());
            indices.put(type, Maps.newHashMap());
        }
        Regions.register(new DefaultOverworldRegion(TerraBlender.CONFIG.vanillaOverworldRegionWeight));
        Regions.register(new DefaultNetherRegion(TerraBlender.CONFIG.vanillaNetherRegionWeight));
    }
}

