/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag.component;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import net.minecraft.class_332;

public interface DraggableComponent<T>
extends Supplier<T> {
    default public <A> Optional<DraggableComponent<A>> getIf(A ... typeHack) {
        if (typeHack.length != 0) {
            throw new IllegalStateException("array must be empty!");
        }
        if (typeHack.getClass().getComponentType().isInstance(this.get())) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    default public <A> boolean ifMatches(Consumer<A> consumer, A ... typeHack) {
        Optional<DraggableComponent<A>> optional = this.getIf(typeHack);
        optional.ifPresent(comp -> consumer.accept(comp.get()));
        return optional.isPresent();
    }

    default public <A> boolean ifMatches(Predicate<A> consumer, A ... typeHack) {
        Optional<DraggableComponent<A>> optional = this.getIf(typeHack);
        return optional.map(comp -> consumer.test(comp.get())).orElse(false);
    }

    public int getWidth();

    public int getHeight();

    default public Rectangle getOriginBounds(Point mouse) {
        return new Rectangle(mouse.x - this.getWidth() / 2, mouse.y - this.getHeight() / 2, this.getWidth(), this.getHeight());
    }

    default public void drag() {
    }

    default public void release(DraggedAcceptorResult result) {
    }

    default public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
    }

    default public void render(class_332 graphics, Point position, int mouseX, int mouseY, float delta) {
        this.render(graphics, new Rectangle(position.x - this.getWidth() / 2, position.y - this.getHeight() / 2, this.getWidth(), this.getHeight()), mouseX, mouseY, delta);
    }
}

