/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextType;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResultImpl;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FilteringLogic {
    private static final MutableLong LAST_WARNING = new MutableLong(-1L);

    public static void warnFiltering() {
        if (LAST_WARNING.getValue() > 0L && System.currentTimeMillis() - LAST_WARNING.getValue() > 5000L) {
            InternalLogger.getInstance().warn("Detected runtime EntryRegistry modification, this can be extremely dangerous, or be extremely inefficient!");
        }
        LAST_WARNING.setValue(System.currentTimeMillis());
    }

    public static List<FilteringRule<?>> getRules() {
        List<FilteringRule<?>> rules = ((ConfigObjectImpl)ConfigObject.getInstance()).getFilteringRules();
        boolean added = false;
        for (FilteringRuleType type : FilteringRuleTypeRegistry.getInstance()) {
            if (!type.isSingular() || !rules.stream().noneMatch(filteringRule -> filteringRule.getType().equals(type))) continue;
            rules.add((FilteringRule<?>)type.createNew());
            added = true;
        }
        if (added) {
            ConfigManager.getInstance().saveConfig();
        }
        return rules;
    }

    private static LinkedHashMap<FilteringRule<?>, Object> prepareCache(List<FilteringRule<?>> rules, boolean async, Collection<EntryStack<?>> entries) {
        LinkedHashMap cache = new LinkedHashMap();
        for (int i = rules.size() - 1; i >= 0; --i) {
            FilteringRule<?> rule = rules.get(i);
            cache.put(rule, rule.prepareCache(async));
        }
        return cache;
    }

    public static List<EntryStack<?>> filter(List<FilteringRule<?>> rules, boolean log, boolean async, List<EntryStack<?>> entries) {
        return (List)FilteringLogic.filter(rules, log, async, entries);
    }

    public static Collection<EntryStack<?>> filter(List<FilteringRule<?>> rules, boolean log, boolean async, Collection<EntryStack<?>> entries) {
        Set<HashedEntryStackWrapper> hiddenStacks = FilteringLogic.hidden(rules, log, async, entries).get((Object)FilteringContextType.HIDDEN);
        if (hiddenStacks.isEmpty()) {
            return entries;
        }
        if (async) {
            return entries.parallelStream().filter(stack -> !hiddenStacks.contains(new HashedEntryStackWrapper((EntryStack<?>)stack))).collect(Collectors.toList());
        }
        return CollectionUtils.filterToList(entries, stack -> !hiddenStacks.contains(new HashedEntryStackWrapper((EntryStack<?>)stack)));
    }

    public static Map<FilteringContextType, Set<HashedEntryStackWrapper>> hidden(List<FilteringRule<?>> rules, boolean log, boolean async, Collection<EntryStack<?>> entries) {
        async = entries.size() > 100 && async;
        FilteringContextImpl context = new FilteringContextImpl(async, entries);
        LinkedHashMap<FilteringRule<?>, Object> cache = FilteringLogic.prepareCache(rules, async, entries);
        FilteringLogic.filter0(log, context, cache, entries);
        return context.stacks;
    }

    private static void filter0(boolean log, FilteringContextImpl context, LinkedHashMap<FilteringRule<?>, Object> cache, Collection<EntryStack<?>> entries) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (Map.Entry<FilteringRule<?>, Object> entry : cache.entrySet()) {
            stopwatch.reset().start();
            FilteringRule<?> rule = entry.getKey();
            Object cacheObject = entry.getValue();
            context.handleResult((FilteringResultImpl)rule.processFilteredStacks(context, () -> new FilteringResultImpl(new ArrayList(), new ArrayList()), cache.get(rule), true));
            if (!log) continue;
            InternalLogger.getInstance().debug("Refiltered rule [%s] in %s.", rule.getType().toString(), stopwatch.stop().toString());
        }
    }
}

