/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.events;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import reborncore.api.IListInfoProvider;
import reborncore.common.BaseBlockEntityProvider;
import techreborn.blocks.cable.CableBlock;
import techreborn.client.events.ToolTipAssistUtils;
import techreborn.events.OreDepthSyncHandler;
import techreborn.init.TRContent;
import techreborn.items.DynamicCellItem;
import techreborn.items.UpgradeItem;
import techreborn.items.armor.NanoSuitItem;
import techreborn.items.armor.QuantumSuitItem;
import techreborn.world.OreDepth;
import techreborn.world.TargetDimension;

@Environment(value=EnvType.CLIENT)
public class StackToolTipHandler
implements ItemTooltipCallback {
    public static final Map<class_1792, Boolean> ITEM_ID = Maps.newHashMap();
    private static final List<class_2248> UNOBTAINABLE_ORES = Lists.newLinkedList();

    public static void setup() {
        ItemTooltipCallback.EVENT.register((Object)new StackToolTipHandler());
        for (TRContent.Ores ore : TRContent.Ores.values()) {
            if (!ore.isDeepslate()) continue;
            TRContent.Ores normal = ore.getUnDeepslate();
            if (normal.distribution == null || normal.distribution.dimension == TargetDimension.OVERWORLD) continue;
            UNOBTAINABLE_ORES.add(ore.block);
        }
    }

    public void getTooltip(class_1799 stack, class_1792.class_9635 tooltipContext, class_1836 tooltipType, List<class_2561> lines) {
        DynamicCellItem cell;
        class_3611 fluid;
        CableBlock cable;
        class_2586 blockEntity;
        class_1792 item = stack.method_7909();
        if (!class_310.method_1551().method_18854()) {
            return;
        }
        if (!ITEM_ID.computeIfAbsent(item, StackToolTipHandler::isTRItem).booleanValue()) {
            return;
        }
        class_2248 block = class_2248.method_9503((class_1792)item);
        if (block instanceof BaseBlockEntityProvider) {
            ToolTipAssistUtils.addInfo(item.method_7876(), lines);
        }
        if (block instanceof CableBlock && (blockEntity = (cable = (CableBlock)block).method_10123(class_2338.field_10980, block.method_9564())) != null) {
            ((IListInfoProvider)blockEntity).addInfo(lines, false, false);
        }
        if (item instanceof UpgradeItem) {
            UpgradeItem upgrade = (UpgradeItem)item;
            ToolTipAssistUtils.addInfo(item.method_7876(), lines, false);
            lines.addAll(ToolTipAssistUtils.getUpgradeStats(TRContent.Upgrades.fromItem(upgrade), stack.method_7947(), class_437.method_25442()));
        }
        if (item instanceof DynamicCellItem && !((fluid = (cell = (DynamicCellItem)item).getFluid(stack)) instanceof class_3609) && fluid != class_3612.field_15906) {
            ToolTipAssistUtils.addInfo("unplaceable_fluid", lines, false);
        }
        if (item == TRContent.Upgrades.SUPERCONDUCTOR.item && class_437.method_25441()) {
            lines.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1065) + "Blame obstinate_3 for this")));
        }
        if (item == TRContent.OMNI_TOOL) {
            lines.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1054) + class_1074.method_4662((String)"techreborn.tooltip.omnitool_motto", (Object[])new Object[0]))));
        }
        if (block == TRContent.Machine.INDUSTRIAL_CENTRIFUGE.block && class_437.method_25441()) {
            lines.add((class_2561)class_2561.method_43470((String)"Round and round it goes"));
        }
        if (UNOBTAINABLE_ORES.contains(block)) {
            lines.add((class_2561)class_2561.method_43471((String)"techreborn.tooltip.unobtainable").method_27692(class_124.field_1075));
        } else if (OreDepthSyncHandler.getOreDepthMap().containsKey(block)) {
            OreDepth oreDepth = OreDepthSyncHandler.getOreDepthMap().get(block);
            class_2561 text = StackToolTipHandler.getOreDepthText(oreDepth);
            lines.add((class_2561)text.method_27661().method_27692(class_124.field_1075));
        }
        if (item instanceof NanoSuitItem) {
            NanoSuitItem suit = (NanoSuitItem)item;
            suit.appendArmorTooltip(stack, lines, class_437.method_25442());
        } else if (item instanceof QuantumSuitItem) {
            QuantumSuitItem suit = (QuantumSuitItem)item;
            suit.appendArmorTooltip(stack, lines, class_437.method_25442());
        }
    }

    private static boolean isTRItem(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item).method_12836().equals("techreborn");
    }

    private static class_2561 getOreDepthText(OreDepth depth) {
        return class_2561.method_43469((String)"techreborn.tooltip.ores.%s".formatted(depth.dimension().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(depth.minY())).method_27692(class_124.field_1054), class_2561.method_43470((String)String.valueOf(depth.maxY())).method_27692(class_124.field_1054)});
    }
}

