/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.google.common.collect.MapMaker;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.contraptions.actors.psi.PortableFluidInterfaceBlockEntity;
import com.zurrtum.create.content.contraptions.actors.psi.PortableItemInterfaceBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.fluids.drain.ItemDrainBlockEntity;
import com.zurrtum.create.content.fluids.hosePulley.HosePulleyBlockEntity;
import com.zurrtum.create.content.fluids.spout.SpoutBlockEntity;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.crusher.CrushingWheelControllerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.millstone.MillstoneBlockEntity;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.content.logistics.chute.ChuteBlockEntity;
import com.zurrtum.create.content.logistics.chute.SmartChuteBlockEntity;
import com.zurrtum.create.content.logistics.crate.CreativeCrateBlockEntity;
import com.zurrtum.create.content.logistics.depot.DepotBlockEntity;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.repackager.RepackagerBlockEntity;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import com.zurrtum.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.CachedDirectionInventoryBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.CachedFluidInventoryBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.CachedInventoryBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.transfer.FluidInventoryWrapper;
import com.zurrtum.create.infrastructure.transfer.FluidItemContext;
import com.zurrtum.create.infrastructure.transfer.FluidItemInventoryWrapper;
import com.zurrtum.create.infrastructure.transfer.InventoryWrapper;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class AllTransfer {
    public static final boolean DISABLE = !FabricLoader.getInstance().isModLoaded("fabric-transfer-api-v1");
    public static Map<Class<? extends SmartBlockEntity>, List<Function<? extends SmartBlockEntity, BlockEntityBehaviour<?>>>> ALL;
    private static final Map<Storage<ItemVariant>, class_1263> WRAPPERS_ITEM;
    private static final Map<Storage<FluidVariant>, FluidInventory> WRAPPERS_FLUID;

    public static <T extends SmartBlockEntity> void addBehaviours(T blockEntity, ArrayList<BlockEntityBehaviour<?>> behaviours) {
        if (DISABLE) {
            return;
        }
        List<Function<SmartBlockEntity, BlockEntityBehaviour<?>>> list = ALL.get(blockEntity.getClass());
        if (list == null) {
            return;
        }
        for (Function<SmartBlockEntity, BlockEntityBehaviour<?>> factory : list) {
            behaviours.add(factory.apply(blockEntity));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Supplier<class_1263> getCacheInventory(class_3218 world, class_2338 pos, class_2350 direction, BiPredicate<class_2586, class_2350> filter) {
        if (DISABLE) {
            return null;
        }
        @Nullable BlockApiCache cache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)world, (class_2338)pos);
        return () -> {
            Storage inventory = (Storage)cache.find((Object)direction);
            if (inventory == null || filter != null && !filter.test(cache.getBlockEntity(), direction)) {
                return null;
            }
            return WRAPPERS_ITEM.computeIfAbsent((Storage<ItemVariant>)inventory, InventoryWrapper::of);
        };
    }

    public static class_1263 getInventory(class_1937 world, class_2338 pos, @Nullable class_2680 state, @Nullable class_2586 blockEntity, class_2350 direction) {
        if (DISABLE) {
            return null;
        }
        Storage inventory = (Storage)ItemStorage.SIDED.find(world, pos, state, blockEntity, (Object)direction);
        if (inventory == null) {
            return null;
        }
        return WRAPPERS_ITEM.computeIfAbsent((Storage<ItemVariant>)inventory, InventoryWrapper::of);
    }

    public static boolean hasFluidInventory(class_1937 world, class_2338 pos, @Nullable class_2680 state, @Nullable class_2586 blockEntity, class_2350 direction) {
        if (DISABLE) {
            return false;
        }
        return FluidStorage.SIDED.find(world, pos, state, blockEntity, (Object)direction) != null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Supplier<FluidInventory> getCacheFluidInventory(class_3218 world, class_2338 pos, class_2350 direction) {
        if (DISABLE) {
            return null;
        }
        @Nullable BlockApiCache cache = BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (class_3218)world, (class_2338)pos);
        return () -> {
            Storage inventory = (Storage)cache.find((Object)direction);
            if (inventory == null) {
                return null;
            }
            return WRAPPERS_FLUID.computeIfAbsent((Storage<FluidVariant>)inventory, FluidInventoryWrapper::of);
        };
    }

    public static FluidInventory getFluidInventory(class_1937 world, class_2338 pos, @Nullable class_2680 state, @Nullable class_2586 blockEntity, class_2350 direction) {
        if (DISABLE) {
            return null;
        }
        Storage inventory = (Storage)FluidStorage.SIDED.find(world, pos, state, blockEntity, (Object)direction);
        if (inventory == null) {
            return null;
        }
        return WRAPPERS_FLUID.computeIfAbsent((Storage<FluidVariant>)inventory, FluidInventoryWrapper::of);
    }

    public static boolean hasFluidInventory(class_1799 stack) {
        if (DISABLE) {
            return false;
        }
        FluidItemContext context = FluidItemContext.of(stack);
        boolean result = FluidStorage.ITEM.find(stack, (Object)context) != null;
        context.close();
        return result;
    }

    public static FluidItemInventory getFluidInventory(class_1799 stack) {
        if (DISABLE) {
            return null;
        }
        FluidItemContext context = FluidItemContext.of(stack);
        Storage inventory = (Storage)FluidStorage.ITEM.find(stack, (Object)context);
        if (inventory == null) {
            context.close();
            return null;
        }
        return FluidItemInventoryWrapper.of((Storage<FluidVariant>)inventory, context);
    }

    private static <T extends SmartBlockEntity> void registerItemSide(Class<T> target, class_2591<T> type, Function<T, class_1263> factory) {
        ALL.computeIfAbsent(target, t -> new ArrayList()).add(be -> new CachedInventoryBehaviour<SmartBlockEntity>((SmartBlockEntity)be, factory));
        ItemStorage.SIDED.registerForBlockEntity(CachedInventoryBehaviour::get, type);
    }

    private static <T extends SmartBlockEntity> void registerItemSide(Class<T> target, class_2591<T> type, BiFunction<T, class_2350, class_1263> factory) {
        ALL.computeIfAbsent(target, t -> new ArrayList()).add(be -> new CachedDirectionInventoryBehaviour<SmartBlockEntity>((SmartBlockEntity)be, factory));
        ItemStorage.SIDED.registerForBlockEntity(CachedDirectionInventoryBehaviour::get, type);
    }

    private static <T extends SmartBlockEntity> void registerFluidSide(Class<T> target, class_2591<T> type, Function<T, FluidInventory> factory) {
        ALL.computeIfAbsent(target, t -> new ArrayList()).add(be -> new CachedFluidInventoryBehaviour<SmartBlockEntity>((SmartBlockEntity)be, factory));
        FluidStorage.SIDED.registerForBlockEntity(CachedFluidInventoryBehaviour::get, type);
    }

    private static <T extends SmartBlockEntity> void registerFluidSide(Class<T> target, class_2591<T> type, Function<T, FluidInventory> factory, BiPredicate<T, class_2350> valid) {
        ALL.computeIfAbsent(target, t -> new ArrayList()).add(be -> new CachedFluidInventoryBehaviour<SmartBlockEntity>((SmartBlockEntity)be, factory));
        FluidStorage.SIDED.registerForBlockEntity((be, side) -> {
            if (valid.test((Object)be, (class_2350)side)) {
                return CachedFluidInventoryBehaviour.get(be, side);
            }
            return null;
        }, type);
    }

    public static void register() {
        if (DISABLE) {
            return;
        }
        ALL = new Reference2ObjectArrayMap();
        AllTransfer.registerItemSide(DepotBlockEntity.class, AllBlockEntityTypes.DEPOT, (T be) -> be.depotBehaviour.itemHandler);
        AllTransfer.registerItemSide(EjectorBlockEntity.class, AllBlockEntityTypes.WEIGHTED_EJECTOR, (T be) -> be.depotBehaviour.itemHandler);
        AllTransfer.registerItemSide(BeltBlockEntity.class, AllBlockEntityTypes.BELT, (T be) -> {
            if (!BeltBlock.canTransportObjects(be.method_11010())) {
                return null;
            }
            if (!be.method_11015() && be.itemHandler == null) {
                be.initializeItemHandler();
            }
            return be.itemHandler;
        });
        AllTransfer.registerItemSide(MillstoneBlockEntity.class, AllBlockEntityTypes.MILLSTONE, (T be) -> be.capability);
        AllTransfer.registerItemSide(SawBlockEntity.class, AllBlockEntityTypes.SAW, (T be) -> be.inventory);
        AllTransfer.registerItemSide(BasinBlockEntity.class, AllBlockEntityTypes.BASIN, (T be) -> be.itemCapability);
        AllTransfer.registerItemSide(BeltTunnelBlockEntity.class, AllBlockEntityTypes.ANDESITE_TUNNEL, (T be) -> {
            class_1263 capBelow;
            class_2586 beBelow;
            class_2338 pos;
            class_1937 world;
            class_2680 state;
            if (be.cap == null && (state = (world = be.method_10997()).method_8320((pos = be.method_11016()).method_10074())).method_27852((class_2248)AllBlocks.BELT) && (beBelow = world.method_8321(pos.method_10074())) != null && (capBelow = ItemHelper.getInventory(world, pos.method_10074(), state, beBelow, class_2350.field_11036)) != null) {
                be.cap = capBelow;
            }
            return be.cap;
        });
        AllTransfer.registerItemSide(BrassTunnelBlockEntity.class, AllBlockEntityTypes.BRASS_TUNNEL, (T be) -> be.tunnelCapability);
        AllTransfer.registerItemSide(ChuteBlockEntity.class, AllBlockEntityTypes.CHUTE, (T be) -> be.itemHandler);
        AllTransfer.registerItemSide(SmartChuteBlockEntity.class, AllBlockEntityTypes.SMART_CHUTE, (T be) -> be.itemHandler);
        AllTransfer.registerItemSide(PortableItemInterfaceBlockEntity.class, AllBlockEntityTypes.PORTABLE_STORAGE_INTERFACE, (T be) -> be.capability);
        AllTransfer.registerItemSide(ItemDrainBlockEntity.class, AllBlockEntityTypes.ITEM_DRAIN, (T be, class_2350 context) -> {
            if (context != null && context.method_10166().method_10179()) {
                return be.itemHandlers.get(context);
            }
            return null;
        });
        AllTransfer.registerItemSide(DeployerBlockEntity.class, AllBlockEntityTypes.DEPLOYER, (T be) -> {
            if (be.invHandler == null) {
                be.initHandler();
            }
            return be.invHandler;
        });
        AllTransfer.registerItemSide(CrushingWheelControllerBlockEntity.class, AllBlockEntityTypes.CRUSHING_WHEEL_CONTROLLER, (T be) -> be.inventory);
        AllTransfer.registerItemSide(MechanicalCrafterBlockEntity.class, AllBlockEntityTypes.MECHANICAL_CRAFTER, MechanicalCrafterBlockEntity::getInvCapability);
        AllTransfer.registerItemSide(CreativeCrateBlockEntity.class, AllBlockEntityTypes.CREATIVE_CRATE, (T be) -> be.inv);
        AllTransfer.registerItemSide(PackagerBlockEntity.class, AllBlockEntityTypes.PACKAGER, (T be) -> be.inventory);
        AllTransfer.registerItemSide(RepackagerBlockEntity.class, AllBlockEntityTypes.REPACKAGER, (T be) -> be.inventory);
        AllTransfer.registerItemSide(PostboxBlockEntity.class, AllBlockEntityTypes.PACKAGE_POSTBOX, (T be) -> be.inventory);
        AllTransfer.registerItemSide(FrogportBlockEntity.class, AllBlockEntityTypes.PACKAGE_FROGPORT, (T be) -> be.inventory);
        AllTransfer.registerItemSide(ToolboxBlockEntity.class, AllBlockEntityTypes.TOOLBOX, (T be) -> be.inventory);
        AllTransfer.registerItemSide(StationBlockEntity.class, AllBlockEntityTypes.TRACK_STATION, (T be) -> be.depotBehaviour.itemHandler);
        AllTransfer.registerFluidSide(FluidTankBlockEntity.class, AllBlockEntityTypes.FLUID_TANK, be -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            return be.fluidCapability;
        });
        AllTransfer.registerFluidSide(BasinBlockEntity.class, AllBlockEntityTypes.BASIN, be -> be.fluidCapability);
        AllTransfer.registerFluidSide(PortableFluidInterfaceBlockEntity.class, AllBlockEntityTypes.PORTABLE_FLUID_INTERFACE, be -> be.capability);
        AllTransfer.registerFluidSide(HosePulleyBlockEntity.class, AllBlockEntityTypes.HOSE_PULLEY, be -> be.handler);
        AllTransfer.registerFluidSide(SpoutBlockEntity.class, AllBlockEntityTypes.SPOUT, be -> be.tank.getCapability());
    }

    static {
        WRAPPERS_ITEM = new MapMaker().weakValues().makeMap();
        WRAPPERS_FLUID = new MapMaker().weakValues().makeMap();
    }
}

