/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client;

import com.zurrtum.create.client.foundation.entity.behaviour.CarriageAudioBehaviour;
import com.zurrtum.create.client.foundation.entity.behaviour.CarriageParticleBehaviour;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.foundation.entity.behaviour.EntityBehaviour;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;

@Environment(value=EnvType.CLIENT)
public class AllEntityBehaviours {
    public static Map<Class<? extends class_1297>, Function<? extends class_1297, EntityBehaviour<?>>[]> ALL = new Reference2ObjectArrayMap();

    public static <T extends class_1297> void addBehaviours(T blockEntity, ArrayList<EntityBehaviour<?>> behaviours) {
        Function<? extends class_1297, EntityBehaviour<?>>[] factorys = ALL.get(blockEntity.getClass());
        if (factorys != null) {
            for (Function<class_1297, EntityBehaviour<?>> function : factorys) {
                behaviours.add(function.apply(blockEntity));
            }
        }
    }

    @SafeVarargs
    public static <T extends class_1297> void add(Class<T> type, Function<T, EntityBehaviour<?>> ... factory) {
        ALL.put(type, factory);
    }

    public static void register() {
        AllEntityBehaviours.add(CarriageContraptionEntity.class, CarriageAudioBehaviour::new, CarriageParticleBehaviour::new);
    }
}

