/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.elevator;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.client.content.contraptions.actors.contraptionControls.ControlsSlot;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import java.lang.ref.WeakReference;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.commons.lang3.tuple.MutablePair;

@Environment(value=EnvType.CLIENT)
public class ElevatorControlsHandler {
    private static final ControlsSlot slot = new ElevatorControlsSlot();

    public static boolean onScroll(class_310 mc, double delta) {
        class_638 world = mc.field_1687;
        if (world == null) {
            return false;
        }
        class_746 player = mc.field_1724;
        Couple<class_243> rayInputs = ContraptionHandlerClient.getRayInputs(mc, player);
        class_243 origin = (class_243)rayInputs.getFirst();
        class_243 target = (class_243)rayInputs.getSecond();
        class_238 aabb = new class_238(origin, target).method_1014(16.0);
        Collection<WeakReference<AbstractContraptionEntity>> contraptions = ContraptionHandlerClient.loadedContraptions.get((class_1936)world).values();
        for (WeakReference<AbstractContraptionEntity> ref : contraptions) {
            class_3965 rayTraceResult;
            Contraption contraption;
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)((Object)ref.get());
            if (contraptionEntity == null || !((contraption = contraptionEntity.getContraption()) instanceof ElevatorContraption)) continue;
            ElevatorContraption ec = (ElevatorContraption)contraption;
            if (!contraptionEntity.method_5829().method_994(aabb) || (rayTraceResult = ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity)) == null) continue;
            class_2338 pos = rayTraceResult.method_17777();
            class_3499.class_3501 info = contraption.getBlocks().get(pos);
            if (info == null || !info.comp_1342().method_27852((class_2248)AllBlocks.CONTRAPTION_CONTROLS) || !slot.testHit((class_1936)world, pos, info.comp_1342(), rayTraceResult.method_17784().method_1020(class_243.method_24954((class_2382)pos)))) continue;
            MovementContext ctx = null;
            for (MutablePair<class_3499.class_3501, MovementContext> pair : contraption.getActors()) {
                if (!info.equals(pair.left)) continue;
                ctx = (MovementContext)pair.right;
                break;
            }
            if (ctx == null) continue;
            if (!(ctx.temporaryData instanceof ContraptionControlsMovement.ElevatorFloorSelection)) {
                ctx.temporaryData = new ContraptionControlsMovement.ElevatorFloorSelection();
            }
            ContraptionControlsMovement.ElevatorFloorSelection efs = (ContraptionControlsMovement.ElevatorFloorSelection)ctx.temporaryData;
            int prev = efs.currentIndex;
            efs.currentIndex = efs.currentIndex + (int)(delta > 0.0 ? Math.ceil(delta) : Math.floor(delta));
            ContraptionControlsMovement.tickFloorSelection(efs, ec);
            if (prev != efs.currentIndex && !ec.namesList.isEmpty()) {
                float pitch = (float)efs.currentIndex / (float)ec.namesList.size();
                pitch = class_3532.method_16439((float)pitch, (float)1.0f, (float)1.5f);
                AllSoundEvents.SCROLL_VALUE.play((class_1937)world, (class_1657)player, (class_2382)class_2338.method_49638((class_2374)contraptionEntity.toGlobalVector(rayTraceResult.method_17784(), 1.0f)), 1.0f, pitch);
            }
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ElevatorControlsSlot
    extends ControlsSlot {
        private ElevatorControlsSlot() {
        }

        @Override
        public boolean testHit(class_1936 level, class_2338 pos, class_2680 state, class_243 localHit) {
            class_243 offset = this.getLocalOffset(level, pos, state);
            if (offset == null) {
                return false;
            }
            return localHit.method_1022(offset) < (double)this.scale * 0.85;
        }
    }
}

