/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.bogey;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.content.processing.burner.ScrollTransformedInstance;
import com.zurrtum.create.client.content.trains.bogey.BogeyVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.client.foundation.render.SpecialModels;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class StandardBogeyVisual
implements BogeyVisual {
    private final TransformedInstance shaft1;
    private final TransformedInstance shaft2;

    public StandardBogeyVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        Instancer<TransformedInstance> shaftInstancer = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.SHAFT));
        this.shaft1 = shaftInstancer.createInstance();
        this.shaft2 = shaftInstancer.createInstance();
    }

    @Override
    public void update(class_2487 bogeyData, float wheelAngle, class_4587 poseStack) {
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft1.setTransform(poseStack).translate(-0.5f, 0.25f, 0.0f).center()).rotateTo(class_2350.field_11036, class_2350.field_11035)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft2.setTransform(poseStack).translate(-0.5f, 0.25f, -1.0f).center()).rotateTo(class_2350.field_11036, class_2350.field_11035)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
    }

    @Override
    public void hide() {
        this.shaft1.setZeroTransform().setChanged();
        this.shaft2.setZeroTransform().setChanged();
    }

    @Override
    public void updateLight(int packedLight) {
        this.shaft1.light(packedLight).setChanged();
        this.shaft2.light(packedLight).setChanged();
    }

    @Override
    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept(this.shaft1);
        consumer.accept(this.shaft2);
    }

    @Override
    public void delete() {
        this.shaft1.delete();
        this.shaft2.delete();
    }

    @Environment(value=EnvType.CLIENT)
    public static class Large
    extends StandardBogeyVisual {
        private final TransformedInstance secondaryShaft1;
        private final TransformedInstance secondaryShaft2;
        private final TransformedInstance drive;
        private final ScrollTransformedInstance belt;
        private final TransformedInstance piston;
        private final TransformedInstance wheels;
        private final TransformedInstance pin;

        public Large(VisualizationContext ctx, float partialTick, boolean inContraption) {
            super(ctx, partialTick, inContraption);
            Instancer<TransformedInstance> secondaryShaftInstancer = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit(AllPartialModels.SHAFT));
            this.secondaryShaft1 = secondaryShaftInstancer.createInstance();
            this.secondaryShaft2 = secondaryShaftInstancer.createInstance();
            this.drive = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit(AllPartialModels.BOGEY_DRIVE)).createInstance();
            this.belt = ctx.instancerProvider().instancer(AllInstanceTypes.SCROLLING_TRANSFORMED, SpecialModels.smoothLit(AllPartialModels.BOGEY_DRIVE_BELT)).createInstance();
            this.piston = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit(AllPartialModels.BOGEY_PISTON)).createInstance();
            this.wheels = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit(AllPartialModels.LARGE_BOGEY_WHEELS)).createInstance();
            this.pin = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit(AllPartialModels.BOGEY_PIN)).createInstance();
            this.belt.setSpriteShift(AllSpriteShifts.BOGEY_BELT);
        }

        @Override
        public void update(class_2487 bogeyData, float wheelAngle, class_4587 poseStack) {
            super.update(bogeyData, wheelAngle, poseStack);
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.secondaryShaft1.setTransform(poseStack).translate(-0.5f, 0.25f, 0.5f).center()).rotateTo(class_2350.field_11036, class_2350.field_11034)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.secondaryShaft2.setTransform(poseStack).translate(-0.5f, 0.25f, -1.5f).center()).rotateTo(class_2350.field_11036, class_2350.field_11034)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)this.drive.setTransform(poseStack).scale(0.9980469f)).setChanged();
            ((TransformedInstance)this.belt.offset(0.0f, 0.0054541538f * wheelAngle).setTransform(poseStack).scale(0.9980469f)).setChanged();
            ((TransformedInstance)this.piston.setTransform(poseStack).translate(0.0, 0.0, 0.25 * Math.sin(AngleHelper.rad(wheelAngle)))).setChanged();
            ((TransformedInstance)this.wheels.setTransform(poseStack).translate(0.0f, 1.0f, 0.0f).rotateXDegrees(wheelAngle)).setChanged();
            ((TransformedInstance)((TransformedInstance)this.pin.setTransform(poseStack).translate(0.0f, 1.0f, 0.0f).rotateXDegrees(wheelAngle)).translate(0.0f, 0.25f, 0.0f).rotateXDegrees(-wheelAngle)).setChanged();
        }

        @Override
        public void hide() {
            super.hide();
            this.secondaryShaft1.setZeroTransform().setChanged();
            this.secondaryShaft2.setZeroTransform().setChanged();
            this.wheels.setZeroTransform().setChanged();
            this.drive.setZeroTransform().setChanged();
            this.belt.setZeroTransform().setChanged();
            this.piston.setZeroTransform().setChanged();
            this.pin.setZeroTransform().setChanged();
        }

        @Override
        public void updateLight(int packedLight) {
            super.updateLight(packedLight);
            this.secondaryShaft1.light(packedLight).setChanged();
            this.secondaryShaft2.light(packedLight).setChanged();
            this.wheels.light(packedLight).setChanged();
            this.drive.light(packedLight).setChanged();
            this.belt.light(packedLight).setChanged();
            this.piston.light(packedLight).setChanged();
            this.pin.light(packedLight).setChanged();
        }

        @Override
        public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
            super.collectCrumblingInstances(consumer);
            consumer.accept(this.secondaryShaft1);
            consumer.accept(this.secondaryShaft2);
            consumer.accept(this.wheels);
            consumer.accept(this.drive);
            consumer.accept(this.belt);
            consumer.accept(this.piston);
            consumer.accept(this.pin);
        }

        @Override
        public void delete() {
            super.delete();
            this.secondaryShaft1.delete();
            this.secondaryShaft2.delete();
            this.wheels.delete();
            this.drive.delete();
            this.belt.delete();
            this.piston.delete();
            this.pin.delete();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Small
    extends StandardBogeyVisual {
        private final TransformedInstance frame;
        private final TransformedInstance wheel1;
        private final TransformedInstance wheel2;

        public Small(VisualizationContext ctx, float partialTick, boolean inContraption) {
            super(ctx, partialTick, inContraption);
            Instancer<TransformedInstance> wheelInstancer = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit(AllPartialModels.SMALL_BOGEY_WHEELS));
            this.frame = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit(AllPartialModels.BOGEY_FRAME)).createInstance();
            this.wheel1 = wheelInstancer.createInstance();
            this.wheel2 = wheelInstancer.createInstance();
        }

        @Override
        public void update(class_2487 bogeyData, float wheelAngle, class_4587 poseStack) {
            super.update(bogeyData, wheelAngle, poseStack);
            ((TransformedInstance)this.wheel1.setTransform(poseStack).translate(0.0f, 0.75f, -1.0f).rotateXDegrees(wheelAngle)).setChanged();
            ((TransformedInstance)this.wheel2.setTransform(poseStack).translate(0.0f, 0.75f, 1.0f).rotateXDegrees(wheelAngle)).setChanged();
            ((TransformedInstance)this.frame.setTransform(poseStack).scale(0.9980469f)).setChanged();
        }

        @Override
        public void hide() {
            super.hide();
            this.frame.setZeroTransform().setChanged();
            this.wheel1.setZeroTransform().setChanged();
            this.wheel2.setZeroTransform().setChanged();
        }

        @Override
        public void updateLight(int packedLight) {
            super.updateLight(packedLight);
            this.frame.light(packedLight).setChanged();
            this.wheel1.light(packedLight).setChanged();
            this.wheel2.light(packedLight).setChanged();
        }

        @Override
        public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
            super.collectCrumblingInstances(consumer);
            consumer.accept(this.frame);
            consumer.accept(this.wheel1);
            consumer.accept(this.wheel2);
        }

        @Override
        public void delete() {
            super.delete();
            this.frame.delete();
            this.wheel1.delete();
            this.wheel2.delete();
        }
    }
}

