/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.gl;

import com.zurrtum.create.client.flywheel.backend.FlwBackend;
import com.zurrtum.create.client.flywheel.backend.compile.core.Compilation;
import com.zurrtum.create.client.flywheel.backend.gl.Driver;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlProgram;
import com.zurrtum.create.client.flywheel.backend.glsl.GlslVersion;
import com.zurrtum.create.client.flywheel.lib.math.MoreMath;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.UnknownNullability;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL40;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public final class GlCompat {
    public static final @UnknownNullability GLCapabilities CAPABILITIES;
    public static final Driver DRIVER;
    public static final int SUBGROUP_SIZE;
    public static final boolean ALLOW_DSA = true;
    public static final GlslVersion MAX_GLSL_VERSION;
    public static final boolean SUPPORTS_DSA;
    public static final boolean SUPPORTS_INSTANCING;
    public static final boolean SUPPORTS_INDIRECT;

    private GlCompat() {
    }

    public static void init() {
    }

    public static int getComputeGroupCount(int invocations) {
        return MoreMath.ceilingDiv(invocations, SUBGROUP_SIZE);
    }

    public static void safeShaderSource(int glId, CharSequence source) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer sourceBuffer = MemoryUtil.memUTF8((CharSequence)source, (boolean)true);
            PointerBuffer pointers = stack.mallocPointer(1);
            pointers.put(sourceBuffer);
            GL20C.nglShaderSource((int)glId, (int)1, (long)pointers.address0(), (long)0L);
            MemoryUtil.memFree((Buffer)sourceBuffer);
        }
    }

    public static void safeMultiDrawElementsIndirect(GlProgram drawProgram, int mode, int type, int start, int end, long stride) {
        int count = end - start;
        long indirect = (long)start * stride;
        if (DRIVER == Driver.INTEL) {
            for (int i = 0; i < count; ++i) {
                drawProgram.setUInt("_flw_baseDraw", start + i);
                GL40.glDrawElementsIndirect((int)mode, (int)type, (long)indirect);
                indirect += stride;
            }
        } else {
            drawProgram.setUInt("_flw_baseDraw", start);
            GL43.glMultiDrawElementsIndirect((int)mode, (int)type, (long)indirect, (int)count, (int)((int)stride));
        }
    }

    private static Driver readVendorString() {
        if (CAPABILITIES == null) {
            return Driver.UNKNOWN;
        }
        String vendor = GL20C.glGetString((int)7936);
        if (vendor == null) {
            return Driver.UNKNOWN;
        }
        if (!vendor.contains("ATI") && !vendor.contains("AMD")) {
            if (vendor.contains("NVIDIA")) {
                return Driver.NVIDIA;
            }
            if (vendor.contains("Intel")) {
                return Driver.INTEL;
            }
            return vendor.contains("Mesa") ? Driver.MESA : Driver.UNKNOWN;
        }
        return Driver.AMD;
    }

    private static int subgroupSize() {
        if (CAPABILITIES == null) {
            return 32;
        }
        if (GlCompat.CAPABILITIES.GL_KHR_shader_subgroup) {
            return GL31C.glGetInteger((int)38194);
        }
        return DRIVER != Driver.AMD && DRIVER != Driver.MESA ? 32 : 64;
    }

    private static boolean isInstancingSupported() {
        if (CAPABILITIES == null) {
            return false;
        }
        return GlCompat.CAPABILITIES.OpenGL33 ? true : GlCompat.CAPABILITIES.GL_ARB_shader_bit_encoding;
    }

    private static boolean isIndirectSupported() {
        if (CAPABILITIES == null) {
            return false;
        }
        if (GlCompat.CAPABILITIES.OpenGL46) {
            return true;
        }
        return GlCompat.CAPABILITIES.GL_ARB_compute_shader && GlCompat.CAPABILITIES.GL_ARB_direct_state_access && GlCompat.CAPABILITIES.GL_ARB_gpu_shader5 && GlCompat.CAPABILITIES.GL_ARB_multi_bind && GlCompat.CAPABILITIES.GL_ARB_multi_draw_indirect && GlCompat.CAPABILITIES.GL_ARB_shader_draw_parameters && GlCompat.CAPABILITIES.GL_ARB_shader_storage_buffer_object && GlCompat.CAPABILITIES.GL_ARB_shading_language_420pack && GlCompat.CAPABILITIES.GL_ARB_vertex_attrib_binding && GlCompat.CAPABILITIES.GL_ARB_shader_image_load_store && GlCompat.CAPABILITIES.GL_ARB_shader_image_size;
    }

    private static boolean isDsaSupported() {
        return CAPABILITIES == null ? false : GlCompat.CAPABILITIES.GL_ARB_direct_state_access;
    }

    private static GlslVersion maxGlslVersion() {
        if (CAPABILITIES == null) {
            return GlslVersion.V150;
        }
        GlslVersion[] glslVersions = GlslVersion.values();
        for (int i = glslVersions.length - 1; i > 0; --i) {
            GlslVersion version = glslVersions[i];
            if (!GlCompat.canCompileVersion(version)) continue;
            return version;
        }
        return GlslVersion.V150;
    }

    private static boolean canCompileVersion(GlslVersion version) {
        int handle = GL20.glCreateShader((int)35633);
        String source = "#version %d\nvoid main() {}\n".formatted(version.version);
        GlCompat.safeShaderSource(handle, source);
        GL20.glCompileShader((int)handle);
        boolean success = Compilation.compiledSuccessfully(handle);
        GL20.glDeleteShader((int)handle);
        return success;
    }

    static {
        GLCapabilities caps;
        try {
            caps = GL.getCapabilities();
        }
        catch (IllegalStateException var2) {
            FlwBackend.LOGGER.warn("Failed to get GL capabilities; default Flywheel backends will be disabled.");
            caps = null;
        }
        CAPABILITIES = caps;
        DRIVER = GlCompat.readVendorString();
        SUBGROUP_SIZE = GlCompat.subgroupSize();
        MAX_GLSL_VERSION = GlCompat.maxGlslVersion();
        SUPPORTS_DSA = GlCompat.isDsaSupported();
        SUPPORTS_INSTANCING = GlCompat.isInstancingSupported();
        SUPPORTS_INDIRECT = GlCompat.isIndirectSupported();
    }
}

