/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class EjectorScenes {
    public static void ejector(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("weighted_ejector", "Using Weighted Ejectors");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        class_2338 ejectorPos = util.grid().at(4, 1, 2);
        Selection ejectorS = util.select().position(ejectorPos);
        class_2338 targetPos = util.grid().at(0, 1, 2);
        Selection targetS = util.select().position(targetPos);
        scene.world().setBlock(targetPos, AllBlocks.ANDESITE_CASING.method_9564(), false);
        scene.idle(5);
        scene.world().showSection(targetS, class_2350.field_11033);
        scene.idle(10);
        class_1799 asStack = AllItems.WEIGHTED_EJECTOR.method_7854();
        scene.overlay().showControls(util.vector().topOf(targetPos), Pointing.DOWN, 50).rightClick().whileSneaking().withItem(asStack);
        scene.idle(7);
        Object slot = new Object();
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, slot, new class_238(targetPos), 160);
        scene.overlay().showText(70).attachKeyFrame().colored(PonderPalette.OUTPUT).text("Sneak and Right-Click holding an Ejector to select its target location").pointAt(util.vector().blockSurface(targetPos, class_2350.field_11039)).placeNearTarget();
        scene.idle(80);
        scene.overlay().showControls(util.vector().topOf(ejectorPos), Pointing.DOWN, 50).rightClick().withItem(asStack);
        scene.idle(7);
        scene.world().setKineticSpeed(ejectorS, 0.0f);
        scene.world().modifyBlockEntityNBT(ejectorS, EjectorBlockEntity.class, nbt -> {
            nbt.method_67494("State", EjectorBlockEntity.State.CODEC, (Object)EjectorBlockEntity.State.RETRACTING);
            nbt.method_10548("ForceAngle", 1.0f);
        });
        scene.world().showSection(ejectorS, class_2350.field_11033);
        scene.idle(10);
        scene.overlay().showText(60).colored(PonderPalette.OUTPUT).text("The placed ejector will now launch objects to the marked location").pointAt(util.vector().blockSurface(ejectorPos, class_2350.field_11039)).placeNearTarget();
        scene.idle(70);
        slot = new Object();
        class_238 bb = new class_238(ejectorPos.method_10067());
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, slot, bb, 20);
        scene.idle(10);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, slot, bb.method_1012(-15.0, 15.0, 0.0), 100);
        scene.idle(10);
        scene.overlay().showText(60).attachKeyFrame().colored(PonderPalette.GREEN).text("A valid target can be at any height or distance within range").pointAt(util.vector().blockSurface(targetPos, class_2350.field_11039)).placeNearTarget();
        scene.idle(70);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, new Object(), bb.method_989(-2.0, 0.0, -1.0), 60);
        scene.idle(10);
        scene.overlay().showText(50).colored(PonderPalette.RED).text("They cannot however be off to a side").pointAt(util.vector().blockSurface(targetPos.method_10095().method_10078(), class_2350.field_11039)).placeNearTarget();
        scene.idle(70);
        scene.overlay().showOutlineWithText(util.select().position(ejectorPos.method_10067()), 70).colored(PonderPalette.OUTPUT).text("If no valid Target was selected, it will simply target the block directly in front").placeNearTarget();
        scene.idle(80);
        scene.world().showSection(util.select().position(3, 0, 5), class_2350.field_11036);
        scene.world().showSection(util.select().fromTo(4, 1, 5, 4, 1, 3), class_2350.field_11033);
        scene.idle(12);
        scene.world().setKineticSpeed(ejectorS, 32.0f);
        scene.idle(10);
        scene.overlay().showText(50).attachKeyFrame().text("Supply Rotational Force in order to charge it up").pointAt(util.vector().topOf(4, 1, 3)).placeNearTarget();
        scene.idle(60);
        class_1799 copperBlock = new class_1799((class_1935)class_1802.field_27071);
        class_1799 copperIngot = new class_1799((class_1935)class_1802.field_27022);
        scene.overlay().showControls(util.vector().topOf(ejectorPos).method_1031(0.5, 0.0, 0.0), Pointing.RIGHT, 30).withItem(copperBlock);
        scene.idle(7);
        scene.world().createItemOnBeltLike(ejectorPos, class_2350.field_11043, copperBlock);
        scene.idle(20);
        scene.overlay().showText(50).text("Items placed on the ejector cause it to trigger").pointAt(util.vector().topOf(ejectorPos)).placeNearTarget();
        scene.idle(60);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.world().hideSection(targetS, class_2350.field_11035);
        scene.idle(15);
        scene.world().restoreBlocks(targetS);
        scene.world().showSection(targetS, class_2350.field_11035);
        scene.idle(10);
        scene.world().createItemOnBeltLike(targetPos, class_2350.field_11035, copperIngot);
        scene.idle(20);
        scene.world().createItemOnBeltLike(ejectorPos, class_2350.field_11035, copperBlock);
        scene.overlay().showText(60).attachKeyFrame().text("If Inventories are targeted, the ejector will wait until there is space").pointAt(util.vector().topOf(targetPos)).placeNearTarget();
        scene.idle(70);
        scene.effects().indicateSuccess(targetPos);
        scene.world().removeItemsFromBelt(targetPos);
        scene.idle(40);
        scene.world().hideSection(targetS, class_2350.field_11043);
        scene.idle(15);
        scene.world().setBlock(targetPos, AllBlocks.ANDESITE_CASING.method_9564(), false);
        scene.world().showSection(targetS, class_2350.field_11043);
        class_243 input = util.vector().blockSurface(ejectorPos, class_2350.field_11039).method_1031(0.0, -0.125, 0.0);
        class_243 topOfSlot = input.method_1031(0.0, 0.125, 0.0);
        scene.overlay().showControls(topOfSlot, Pointing.DOWN, 60).rightClick();
        scene.overlay().showFilterSlotInput(input, class_2350.field_11039, 80);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().text("Using the value panel, a required Stack Size can be configured").pointAt(input.method_1031(0.0, 0.0, 0.125)).placeNearTarget();
        scene.world().modifyBlockEntityNBT(ejectorS, EjectorBlockEntity.class, nbt -> nbt.method_10569("ScrollValue", 10));
        scene.idle(90);
        scene.world().showSection(util.select().fromTo(5, 1, 0, 4, 1, 1), class_2350.field_11033);
        scene.world().showSection(util.select().position(5, 0, 1), class_2350.field_11036);
        scene.idle(15);
        class_2338 beltPos = util.grid().at(4, 1, 0);
        scene.world().createItemOnBeltLike(beltPos, class_2350.field_11036, copperBlock);
        scene.overlay().showText(100).text("It is now limited to this stack size, and only activates when its held stack reaches this amount").pointAt(util.vector().topOf(ejectorPos)).placeNearTarget();
        for (int i = 0; i < 4; ++i) {
            scene.idle(20);
            scene.world().createItemOnBeltLike(beltPos, class_2350.field_11036, copperBlock);
        }
        scene.idle(20);
        scene.world().createItemOnBeltLike(beltPos, class_2350.field_11036, copperBlock.method_46651(15));
        scene.idle(80);
        scene.world().hideSection(util.select().fromTo(5, 1, 0, 4, 1, 1), class_2350.field_11036);
        scene.world().hideSection(util.select().position(5, 0, 1), class_2350.field_11033);
        scene.idle(30);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.addKeyframe();
        ElementLink<ParrotElement> birb = scene.special().createBirb(util.vector().topOf(ejectorPos).method_1031(0.0, -0.1875, 0.0), ParrotPose.FlappyPose::new);
        scene.idle(15);
        scene.world().modifyBlockEntity(ejectorPos, EjectorBlockEntity.class, EjectorBlockEntity::activateDeferred);
        scene.special().moveParrot(birb, util.vector().of(-2.0, 3.0, 0.0), 5);
        scene.special().rotateParrot(birb, 0.0, 720.0, 0.0, 21);
        scene.idle(5);
        scene.special().moveParrot(birb, util.vector().of(-1.0, 0.0, 0.0), 3);
        scene.idle(3);
        scene.special().moveParrot(birb, util.vector().of(-0.75, -1.0, 0.0), 6);
        scene.idle(6);
        scene.special().moveParrot(birb, util.vector().of(-0.25, -1.8125, 0.0), 12);
        scene.idle(15);
        scene.special().changeBirbPose(birb, ParrotPose.FaceCursorPose::new);
        scene.overlay().showText(80).text("Mobs and Players will always trigger an Ejector when stepping on it").pointAt(util.vector().topOf(targetPos)).placeNearTarget();
        scene.idle(50);
    }

    public static void splitY(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("weighted_ejector_tunnel", "Splitting item stacks using Weighted Ejectors");
        Selection coverbelt = util.select().fromTo(3, 1, 1, 2, 1, 0);
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 5, 0, 1, 3), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(2, 2, 3), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(2, 1, 2), class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 2, 3, 1, 2), class_2350.field_11035);
        scene.idle(10);
        class_2338 ejectorPos = util.grid().at(2, 1, 2);
        scene.overlay().showText(80).attachKeyFrame().text("Combined with Brass Tunnels, Ejectors can split item stacks by specific amounts").pointAt(util.vector().topOf(ejectorPos)).placeNearTarget();
        scene.idle(90);
        class_2338 tunnel = util.grid().at(2, 2, 3);
        scene.overlay().showControls(util.vector().topOf(tunnel), Pointing.DOWN, 80).showing(AllIcons.I_TUNNEL_PREFER_NEAREST);
        scene.idle(10);
        scene.overlay().showCenteredScrollInput(tunnel, class_2350.field_11036, 100);
        scene.idle(10);
        scene.overlay().showText(100).attachKeyFrame().colored(PonderPalette.BLUE).text("First, configure the Brass Tunnel to 'Prefer Nearest', in order to prioritize its side output").pointAt(util.vector().topOf(tunnel)).placeNearTarget();
        scene.idle(110);
        class_243 input = util.vector().blockSurface(ejectorPos, class_2350.field_11043).method_1023(0.0, 0.125, 0.0);
        class_243 topOfSlot = input.method_1031(0.0, 0.125, 0.0);
        scene.overlay().showFilterSlotInput(input, class_2350.field_11043, 80);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().text("The Stack Size set on the Ejector now determines the amount to be split off").pointAt(topOfSlot).placeNearTarget();
        scene.world().modifyBlockEntityNBT(util.select().position(2, 1, 2), EjectorBlockEntity.class, nbt -> nbt.method_10569("ScrollValue", 10));
        scene.idle(90);
        scene.overlay().showControls(util.vector().topOf(util.grid().at(4, 1, 3)), Pointing.DOWN, 20).withItem(new class_1799((class_1935)class_1802.field_27022));
        scene.world().showSection(coverbelt, class_2350.field_11035);
        scene.idle(7);
        scene.world().createItemOnBelt(util.grid().at(4, 1, 3), class_2350.field_11036, new class_1799((class_1935)class_1802.field_27022, 64));
        scene.idle(40);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 0.0625f);
        scene.overlay().showText(80).attachKeyFrame().text("While a new stack of the configured size exits the side output...").pointAt(util.vector().blockSurface(util.grid().at(2, 1, 1), class_2350.field_11039)).placeNearTarget();
        scene.idle(90);
        scene.overlay().showText(80).text("...the remainder will continue on its path").pointAt(util.vector().blockSurface(util.grid().at(0, 1, 3), class_2350.field_11036)).placeNearTarget();
        scene.idle(90);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 16.0f);
    }

    public static void redstone(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("weighted_ejector_redstone", "Controlling Weighted Ejectors with Redstone");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 3, 4, 1, 5), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(0, 1, 2, 0, 2, 2), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(4, 1, 2), class_2350.field_11035);
        scene.idle(5);
        Selection redstone = util.select().fromTo(3, 1, 2, 2, 1, 2);
        scene.world().showSection(redstone, class_2350.field_11034);
        class_2338 ejectorPos = util.grid().at(4, 1, 2);
        class_243 topOf = util.vector().topOf(ejectorPos.method_10086(2));
        class_1799 copper = new class_1799((class_1935)class_1802.field_27022);
        for (int i = 0; i < 3; ++i) {
            scene.world().createItemEntity(topOf, util.vector().of(0.0, 0.1, 0.0), copper);
            scene.idle(12);
            scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
            scene.world().createItemOnBeltLike(ejectorPos, class_2350.field_11036, copper);
            scene.idle(20);
            if (i != 1) continue;
            scene.world().toggleRedstonePower(redstone);
            scene.effects().indicateRedstone(util.grid().at(2, 1, 2));
            scene.world().modifyBlockEntityNBT(util.select().position(4, 1, 2), EjectorBlockEntity.class, nbt -> nbt.method_10556("Powered", true));
        }
        scene.idle(10);
        scene.overlay().showText(60).colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector().topOf(ejectorPos)).placeNearTarget().text("When powered by Redstone, Ejectors will not activate");
        scene.idle(70);
        scene.world().toggleRedstonePower(redstone);
        scene.idle(2);
        scene.world().modifyBlockEntityNBT(util.select().position(4, 1, 2), EjectorBlockEntity.class, nbt -> nbt.method_10556("Powered", false));
        scene.idle(5);
        scene.world().hideSection(redstone, class_2350.field_11039);
        scene.idle(30);
        ElementLink<WorldSectionElement> observer = scene.world().showIndependentSection(util.select().position(4, 1, 1), class_2350.field_11035);
        scene.world().moveSection(observer, util.vector().of(0.5, 1.5, -0.5), 0);
        scene.world().rotateSection(observer, 0.0, -150.0, 0.0, 0);
        scene.idle(20);
        scene.world().moveSection(observer, util.vector().of(-0.5, -1.5, 0.5), 10);
        scene.world().rotateSection(observer, 0.0, 150.0, 0.0, 10);
        scene.world().showSection(util.select().position(4, 1, 0), class_2350.field_11035);
        Selection observerRedstone = util.select().fromTo(4, 1, 1, 4, 1, 0);
        for (int i = 0; i < 6; ++i) {
            scene.world().createItemEntity(topOf, util.vector().of(0.0, 0.1, 0.0), copper);
            scene.idle(12);
            scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
            scene.world().createItemOnBeltLike(ejectorPos, class_2350.field_11036, copper);
            scene.idle(1);
            scene.world().toggleRedstonePower(observerRedstone);
            scene.effects().indicateRedstone(util.grid().at(4, 1, 1));
            scene.idle(3);
            scene.world().toggleRedstonePower(observerRedstone);
            scene.idle(16);
            if (i == 3) {
                scene.markAsFinished();
            }
            if (i != 1) continue;
            scene.overlay().showText(60).attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(4, 1, 1), class_2350.field_11043)).placeNearTarget().text("Observers can detect when Ejectors activate");
        }
    }
}

