/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.gantry;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.contraptions.gantry.GantryContraption;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlock;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlockEntity;
import com.zurrtum.create.infrastructure.packet.s2c.GantryContraptionUpdatePacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class GantryContraptionEntity
extends AbstractContraptionEntity {
    class_2350 movementAxis;
    public double clientOffsetDiff;
    public double axisMotion;
    public double sequencedOffsetLimit = -1.0;

    public GantryContraptionEntity(class_1299<? extends GantryContraptionEntity> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
    }

    public static GantryContraptionEntity create(class_1937 world, Contraption contraption, class_2350 movementAxis) {
        GantryContraptionEntity entity = new GantryContraptionEntity((class_1299<? extends GantryContraptionEntity>)AllEntityTypes.GANTRY_CONTRAPTION, world);
        entity.setContraption(contraption);
        entity.movementAxis = movementAxis;
        return entity;
    }

    public void limitMovement(double maxOffset) {
        this.sequencedOffsetLimit = maxOffset;
    }

    @Override
    protected void tickContraption() {
        if (!(this.contraption instanceof GantryContraption)) {
            return;
        }
        double prevAxisMotion = this.axisMotion;
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            this.clientOffsetDiff *= 0.75;
            this.updateClientMotion();
        }
        this.checkPinionShaft();
        this.tickActors();
        class_243 movementVec = this.method_18798();
        if (ContraptionCollider.collideBlocks(this)) {
            if (!world.field_9236) {
                this.disassemble();
            }
            return;
        }
        if (!this.isStalled() && this.field_6012 > 2) {
            if (this.sequencedOffsetLimit >= 0.0) {
                movementVec = VecHelper.clampComponentWise(movementVec, (float)this.sequencedOffsetLimit);
            }
            this.move(movementVec.field_1352, movementVec.field_1351, movementVec.field_1350);
            if (this.sequencedOffsetLimit > 0.0) {
                this.sequencedOffsetLimit = Math.max(0.0, this.sequencedOffsetLimit - movementVec.method_1033());
            }
        }
        if (Math.signum(prevAxisMotion) != Math.signum(this.axisMotion) && prevAxisMotion != 0.0) {
            this.contraption.stop(world);
        }
        if (!(world.field_9236 || prevAxisMotion == this.axisMotion && this.field_6012 % 3 != 0)) {
            this.sendPacket();
        }
    }

    @Override
    public void disassemble() {
        this.sequencedOffsetLimit = -1.0;
        super.disassemble();
    }

    protected void checkPinionShaft() {
        GantryShaftBlockEntity gantryShaftBlockEntity;
        class_2586 be;
        class_1937 world;
        class_243 currentPosition;
        block11: {
            block10: {
                class_2350 facing = ((GantryContraption)this.contraption).getFacing();
                currentPosition = this.getAnchorVec().method_1031(0.5, 0.5, 0.5);
                class_2338 gantryShaftPos = class_2338.method_49638((class_2374)currentPosition).method_10093(facing.method_10153());
                world = this.method_37908();
                be = world.method_8321(gantryShaftPos);
                if (!(be instanceof GantryShaftBlockEntity)) break block10;
                gantryShaftBlockEntity = (GantryShaftBlockEntity)be;
                if (be.method_11010().method_27852((class_2248)AllBlocks.GANTRY_SHAFT)) break block11;
            }
            if (!world.field_9236) {
                this.setContraptionMotion(class_243.field_1353);
                this.disassemble();
            }
            return;
        }
        class_2680 blockState = be.method_11010();
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)GantryShaftBlock.FACING);
        float pinionMovementSpeed = gantryShaftBlockEntity.getPinionMovementSpeed();
        if (((Boolean)blockState.method_11654((class_2769)GantryShaftBlock.POWERED)).booleanValue() || pinionMovementSpeed == 0.0f) {
            this.setContraptionMotion(class_243.field_1353);
            if (!world.field_9236) {
                this.disassemble();
            }
            return;
        }
        if (this.sequencedOffsetLimit >= 0.0) {
            pinionMovementSpeed = (float)class_3532.method_15350((double)pinionMovementSpeed, (double)(-this.sequencedOffsetLimit), (double)this.sequencedOffsetLimit);
        }
        class_243 movementVec = class_243.method_24954((class_2382)direction.method_62675()).method_1021((double)pinionMovementSpeed);
        class_243 nextPosition = currentPosition.method_1019(movementVec);
        double currentCoord = direction.method_10166().method_10172(currentPosition.field_1352, currentPosition.field_1351, currentPosition.field_1350);
        double nextCoord = direction.method_10166().method_10172(nextPosition.field_1352, nextPosition.field_1351, nextPosition.field_1350);
        if ((double)((float)class_3532.method_15357((double)currentCoord) + 0.5f) < nextCoord != pinionMovementSpeed * (float)direction.method_10171().method_10181() < 0.0f && !gantryShaftBlockEntity.canAssembleOn()) {
            this.setContraptionMotion(class_243.field_1353);
            if (!world.field_9236) {
                this.disassemble();
            }
            return;
        }
        if (world.field_9236) {
            return;
        }
        this.axisMotion = pinionMovementSpeed;
        this.setContraptionMotion(movementVec);
    }

    @Override
    protected void writeAdditional(class_11372 view, boolean spawnPacket) {
        view.method_71468("GantryAxis", (Codec)class_2350.field_29502, (Object)this.movementAxis);
        if (this.sequencedOffsetLimit >= 0.0) {
            view.method_71463("SequencedOffsetLimit", this.sequencedOffsetLimit);
        }
        super.writeAdditional(view, spawnPacket);
    }

    @Override
    protected void readAdditional(class_11368 view, boolean spawnPacket) {
        this.movementAxis = view.method_71426("GantryAxis", (Codec)class_2350.field_29502).orElse(class_2350.field_11033);
        this.sequencedOffsetLimit = view.method_71422("SequencedOffsetLimit", -1.0);
        super.readAdditional(view, spawnPacket);
    }

    @Override
    public class_243 applyRotation(class_243 localPos, float partialTicks) {
        return localPos;
    }

    @Override
    public class_243 reverseRotation(class_243 localPos, float partialTicks) {
        return localPos;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        return new StructureTransform(class_2338.method_49638((class_2374)this.getAnchorVec().method_1031(0.5, 0.5, 0.5)), 0.0f, 0.0f, 0.0f);
    }

    @Override
    protected float getStalledAngle() {
        return 0.0f;
    }

    public void method_5859(double destX, double destY, double destZ) {
    }

    public void method_66246(class_243 pos, float yaw, float pitch) {
    }

    @Override
    public void handleStallInformation(double x, double y, double z, float angle) {
        this.method_23327(x, y, z);
        this.clientOffsetDiff = 0.0;
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        return AbstractContraptionEntity.ContraptionRotationState.NONE;
    }

    public void updateClientMotion() {
        float modifier = this.movementAxis.method_10171().method_10181();
        class_243 motion = class_243.method_24954((class_2382)this.movementAxis.method_62675()).method_1021((this.axisMotion + this.clientOffsetDiff * (double)modifier / 2.0) * (double)AllClientHandle.INSTANCE.getServerSpeed());
        if (this.sequencedOffsetLimit >= 0.0) {
            motion = VecHelper.clampComponentWise(motion, (float)this.sequencedOffsetLimit);
        }
        this.setContraptionMotion(motion);
    }

    public double getAxisCoord() {
        class_243 anchorVec = this.getAnchorVec();
        return this.movementAxis.method_10166().method_10172(anchorVec.field_1352, anchorVec.field_1351, anchorVec.field_1350);
    }

    public void sendPacket() {
        class_3215 chunkManager = ((class_3218)this.method_37908()).method_14178();
        chunkManager.method_18754((class_1297)this, (class_2596)new GantryContraptionUpdatePacket(this.method_5628(), this.getAxisCoord(), this.axisMotion, this.sequencedOffsetLimit));
    }
}

