/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.station;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.zurrtum.create.content.trains.station.GlobalPackagePort;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GlobalStation
extends SingleBlockEntityEdgePoint {
    public static final Codec<Map<class_2338, GlobalPackagePort>> PORTS_CODEC = CreateCodecs.getCodecMap(class_2338.field_25064, GlobalPackagePort.CODEC);
    public String name = "Track Station";
    public WeakReference<Train> nearestTrain = new WeakReference<Object>(null);
    public boolean assembling;
    public Map<class_2338, GlobalPackagePort> connectedPorts = new HashMap<class_2338, GlobalPackagePort>();

    @Override
    public void blockEntityAdded(class_2586 blockEntity, boolean front) {
        super.blockEntityAdded(blockEntity, front);
        class_2680 state = blockEntity.method_11010();
        this.assembling = state != null && state.method_28498((class_2769)StationBlock.ASSEMBLING) && (Boolean)state.method_11654((class_2769)StationBlock.ASSEMBLING) != false;
    }

    @Override
    public void read(class_11368 view, boolean migration, DimensionPalette dimensions) {
        super.read(view, migration, dimensions);
        this.name = view.method_71428("Name", "");
        this.assembling = view.method_71433("Assembling", false);
        this.nearestTrain = new WeakReference<Object>(null);
        view.method_71426("Ports", PORTS_CODEC).ifPresentOrElse(ports -> {
            this.connectedPorts = ports;
        }, this.connectedPorts::clear);
    }

    @Override
    public <T> void decode(DynamicOps<T> ops, T input, boolean migration, DimensionPalette dimensions) {
        super.decode(ops, input, migration, dimensions);
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        this.name = ops.getStringValue(map.get("Name")).result().orElse("");
        this.assembling = (Boolean)ops.getBooleanValue(map.get("Assembling")).getOrThrow();
    }

    @Override
    public void read(class_2540 buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        this.name = buffer.method_19772();
        this.assembling = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.blockEntityPos = buffer.method_10811();
        }
    }

    @Override
    public void write(class_11372 view, DimensionPalette dimensions) {
        super.write(view, dimensions);
        view.method_71469("Name", this.name);
        view.method_71472("Assembling", this.assembling);
        view.method_71468("Ports", PORTS_CODEC, this.connectedPorts);
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        DataResult<T> prefix = super.encode(ops, empty, dimensions);
        RecordBuilder map = ops.mapBuilder();
        map.add("Name", ops.createString(this.name));
        map.add("Assembling", ops.createBoolean(this.assembling));
        map.add("Ports", this.connectedPorts, PORTS_CODEC);
        return map.build(prefix);
    }

    @Override
    public void write(class_2540 buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        buffer.method_10814(this.name);
        buffer.method_52964(this.assembling);
        buffer.method_52964(this.blockEntityPos != null);
        if (this.blockEntityPos != null) {
            buffer.method_10807(this.blockEntityPos);
        }
    }

    public boolean canApproachFrom(TrackNode side) {
        return this.isPrimary(side) && !this.assembling;
    }

    @Override
    public boolean canNavigateVia(TrackNode side) {
        return super.canNavigateVia(side) && !this.assembling;
    }

    public void reserveFor(Train train) {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.navigation.distanceToDestination > train.navigation.distanceToDestination) {
            this.nearestTrain = new WeakReference<Train>(train);
        }
    }

    public void cancelReservation(Train train) {
        if (this.nearestTrain.get() == train) {
            this.nearestTrain = new WeakReference<Object>(null);
        }
    }

    public void trainDeparted(Train train) {
        this.cancelReservation(train);
    }

    @Nullable
    public Train getPresentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.getCurrentStation() != this) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getImminentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null) {
            return nearestTrain;
        }
        if (nearestTrain.getCurrentStation() == this) {
            return nearestTrain;
        }
        if (!nearestTrain.navigation.isActive()) {
            return null;
        }
        if (nearestTrain.navigation.distanceToDestination > 30.0) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getNearestTrain() {
        return (Train)this.nearestTrain.get();
    }

    public void runMailTransfer() {
        Train train = this.getPresentTrain();
        if (train == null || this.connectedPorts.isEmpty()) {
            return;
        }
        MinecraftServer server = Create.SERVER;
        class_3218 level = server.method_3847(this.getBlockEntityDimension());
        for (Carriage carriage : train.carriages) {
            CombinedInvWrapper carriageInventory = carriage.storage.getAllItems();
            if (carriageInventory == null) continue;
            for (Map.Entry<class_2338, GlobalPackagePort> entry : this.connectedPorts.entrySet()) {
                class_2586 class_25862;
                GlobalPackagePort port = entry.getValue();
                class_2338 pos = entry.getKey();
                PostboxBlockEntity box = null;
                ItemInventory postboxInventory = port.offlineBuffer;
                if (level != null && level.method_8477(pos) && (class_25862 = level.method_8321(pos)) instanceof PostboxBlockEntity) {
                    PostboxBlockEntity ppbe = (PostboxBlockEntity)class_25862;
                    postboxInventory = ppbe.inventory;
                    box = ppbe;
                }
                int size = postboxInventory.method_5439();
                for (int slot = 0; slot < size; ++slot) {
                    int insert;
                    class_1799 stack = postboxInventory.method_5438(slot);
                    if (PackageItem.matchAddress(stack, port.address) || (insert = carriageInventory.insert(stack)) == 0) continue;
                    int count = stack.method_7947();
                    if (insert == count) {
                        postboxInventory.method_5447(slot, class_1799.field_8037);
                    } else {
                        stack.method_7939(count - insert);
                    }
                    if (box == null) {
                        port.primed = true;
                    } else {
                        box.spawnParticles();
                    }
                    Create.RAILWAYS.markTracksDirty();
                }
            }
            Iterator iterator = carriageInventory.iterator();
            block3: while (iterator.hasNext()) {
                class_1799 stack = (class_1799)iterator.next();
                if (!PackageItem.isPackage(stack)) continue;
                for (Map.Entry<class_2338, GlobalPackagePort> entry : this.connectedPorts.entrySet()) {
                    class_2586 insert;
                    GlobalPackagePort port = entry.getValue();
                    class_2338 pos = entry.getKey();
                    PostboxBlockEntity box = null;
                    if (!PackageItem.matchAddress(stack, port.address)) continue;
                    ItemInventory postboxInventory = port.offlineBuffer;
                    if (level != null && level.method_8477(pos) && (insert = level.method_8321(pos)) instanceof PostboxBlockEntity) {
                        PostboxBlockEntity ppbe = (PostboxBlockEntity)insert;
                        postboxInventory = ppbe.inventory;
                        box = ppbe;
                        box.inventory.sendMode();
                    }
                    int insert2 = postboxInventory.insert(stack);
                    if (box != null) {
                        box.inventory.receiveMode();
                    }
                    if (insert2 == 0) continue;
                    int extract = carriageInventory.extract(stack, insert2);
                    if (extract != insert2) {
                        postboxInventory.extract(stack, insert2 - extract);
                    }
                    if (box == null) {
                        port.primed = true;
                    } else {
                        box.spawnParticles();
                    }
                    Create.RAILWAYS.markTracksDirty();
                    continue block3;
                }
            }
        }
    }
}

