/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import java.util.Optional;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3920;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_8942;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.refabricated.inventory.ItemStackHandler;

public class StoveBlockEntity
extends SyncedBlockEntity {
    private static final class_265 GRILLING_AREA = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final int INVENTORY_SLOT_COUNT = 6;
    private final ItemStackHandler inventory = this.createHandler();
    private final int[] cookingTimes = new int[6];
    private final int[] cookingTimesTotal = new int[6];
    private final class_1863.class_7266<class_9696, class_3920> quickCheck = class_1863.method_42302((class_3956)class_3956.field_17549);

    public StoveBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.STOVE.get(), pos, state);
    }

    public void method_11014(class_11368 input) {
        super.method_11014(input);
        this.inventory.deserialize(input.method_71434("Inventory"));
        if (input.method_71442("CookingTimes").isPresent()) {
            int[] arrayCookingTimes = (int[])input.method_71442("CookingTimes").get();
            System.arraycopy(arrayCookingTimes, 0, this.cookingTimes, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimes.length));
        }
        if (input.method_71442("CookingTotalTimes").isPresent()) {
            int[] arrayCookingTimesTotal = (int[])input.method_71442("CookingTotalTimes").get();
            System.arraycopy(arrayCookingTimesTotal, 0, this.cookingTimesTotal, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimesTotal.length));
        }
    }

    public void method_11007(class_11372 output) {
        this.writeItems(output);
        output.method_71473("CookingTimes", this.cookingTimes);
        output.method_71473("CookingTotalTimes", this.cookingTimesTotal);
    }

    private void writeItems(class_11372 output) {
        super.method_11007(output);
        this.inventory.serialize(output.method_71461("Inventory"));
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        class_2586 tileEntity = this.field_11863.method_8321(pos);
        if (tileEntity instanceof StoveBlockEntity) {
            ItemUtils.dropItems(this.field_11863, pos, ((StoveBlockEntity)tileEntity).getInventory());
        }
        super.method_66473(pos, state);
    }

    public static void cookingTick(class_3218 level, class_2338 pos, class_2680 state, StoveBlockEntity stove) {
        boolean isStoveLit = (Boolean)state.method_11654((class_2769)StoveBlock.LIT);
        if (stove.isStoveBlockedAbove()) {
            if (!ItemUtils.isInventoryEmpty(stove.inventory)) {
                ItemUtils.dropItems((class_1937)level, pos, stove.inventory);
                stove.inventoryChanged();
            }
        } else if (isStoveLit) {
            stove.cookAndOutputItems(level);
        } else {
            for (int i = 0; i < stove.inventory.getSlotCount(); ++i) {
                if (stove.cookingTimes[i] <= 0) continue;
                stove.cookingTimes[i] = class_3532.method_15340((int)(stove.cookingTimes[i] - 2), (int)0, (int)stove.cookingTimesTotal[i]);
            }
        }
    }

    public static void animationTick(class_1937 level, class_2338 pos, class_2680 state, StoveBlockEntity stove) {
        for (int i = 0; i < stove.inventory.getSlotCount(); ++i) {
            if (stove.inventory.getStackInSlot(i).method_7960() || !(level.field_9229.method_43057() < 0.2f)) continue;
            class_241 stoveItemVector = stove.getStoveItemOffset(i);
            class_2350 direction = (class_2350)state.method_11654(StoveBlock.FACING);
            int directionIndex = direction.method_10161();
            class_241 offset = directionIndex % 2 == 0 ? stoveItemVector : new class_241(stoveItemVector.field_1342, stoveItemVector.field_1343);
            double x = (double)pos.method_10263() + 0.5 - (double)((float)direction.method_10148() * offset.field_1343) + (double)((float)direction.method_10170().method_10148() * offset.field_1343);
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.5 - (double)((float)direction.method_10165() * offset.field_1342) + (double)((float)direction.method_10170().method_10165() * offset.field_1342);
            for (int k = 0; k < 3; ++k) {
                level.method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    private void cookAndOutputItems(class_3218 serverLevel) {
        if (this.field_11863 == null) {
            return;
        }
        boolean didInventoryChange = false;
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            class_1799 resultStack;
            class_1799 stoveStack = this.inventory.getStackInSlot(i);
            if (stoveStack.method_7960()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] < this.cookingTimesTotal[i]) continue;
            Optional<class_8786<class_3920>> recipe = this.getMatchingRecipe(stoveStack, serverLevel);
            if (recipe.isPresent() && !(resultStack = ((class_3920)recipe.get().comp_1933()).method_59998(new class_9696(stoveStack), (class_7225.class_7874)serverLevel.method_30349())).method_7960()) {
                ItemUtils.spawnItemEntity(this.field_11863, resultStack.method_7972(), (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0, (double)this.field_11867.method_10260() + 0.5, this.field_11863.field_9229.method_43059() * (double)0.01f, 0.1f, this.field_11863.field_9229.method_43059() * (double)0.01f);
            }
            this.inventory.setStackInSlot(i, class_1799.field_8037);
            didInventoryChange = true;
        }
        if (didInventoryChange) {
            this.inventoryChanged();
        }
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            class_1799 slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.method_7960()) continue;
            return i;
        }
        return -1;
    }

    public boolean addItem(class_3218 serverLevel, class_1799 itemStackIn, int slot) {
        class_1799 slotStack;
        Optional optional = serverLevel.method_64577().method_8132(class_3956.field_17549, (class_9695)new class_9696(itemStackIn), this.field_11863);
        if (optional.isPresent() && 0 <= slot && slot < this.inventory.getSlotCount() && (slotStack = this.inventory.getStackInSlot(slot)).method_7960()) {
            this.cookingTimesTotal[slot] = ((class_3920)((class_8786)optional.get()).comp_1933()).method_8167();
            this.cookingTimes[slot] = 0;
            this.inventory.setStackInSlot(slot, itemStackIn.method_7971(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public Optional<class_8786<class_3920>> getMatchingRecipe(class_1799 stack, class_3218 serverLevel) {
        return this.quickCheck.method_42303((class_9695)new class_9696(stack), serverLevel);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean isStoveBlockedAbove() {
        if (this.field_11863 != null) {
            class_2680 above = this.field_11863.method_8320(this.field_11867.method_10084());
            return class_259.method_1074((class_265)GRILLING_AREA, (class_265)above.method_26218((class_1922)this.field_11863, this.field_11867.method_10084()), (class_247)class_247.field_16896);
        }
        return false;
    }

    public class_241 getStoveItemOffset(int index) {
        float X_OFFSET = 0.3f;
        float Y_OFFSET = 0.2f;
        class_241[] OFFSETS = new class_241[]{new class_241(0.3f, 0.2f), new class_241(0.0f, 0.2f), new class_241(-0.3f, 0.2f), new class_241(0.3f, -0.2f), new class_241(0.0f, -0.2f), new class_241(-0.3f, -0.2f)};
        return OFFSETS[index];
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag;
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), FarmersDelight.LOGGER);){
            class_11362 tagValueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)registries);
            this.writeItems((class_11372)tagValueOutput);
            tag = tagValueOutput.method_71475();
        }
        return tag;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(this, 6){

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

