/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.class_1937;
import net.pitan76.mcpitanlib.api.util.LoggerUtil;
import net.pitan76.mcpitanlib.api.util.PlatformUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.client.ClientUtil;

public class Logger {
    public String name = "";
    public boolean usingPrefix = true;
    private final org.apache.logging.log4j.Logger logger;

    public Logger(String name) {
        this.name = name;
        this.logger = LoggerUtil.getLogger(name);
    }

    public Logger() {
        this.logger = LoggerUtil.getLogger();
    }

    public Logger(Class<?> clazz) {
        this.logger = LoggerUtil.getLogger(clazz);
    }

    public Logger(String name, boolean usePrefix) {
        this(name);
        this.usePrefix(usePrefix);
    }

    public org.apache.logging.log4j.Logger getLogger() {
        return this.logger;
    }

    public void info(String message) {
        LoggerUtil.info(this.logger, message);
    }

    public void warn(String message) {
        LoggerUtil.warn(this.logger, message);
    }

    public void error(String message) {
        LoggerUtil.error(this.logger, message);
    }

    public void debug(String message) {
        LoggerUtil.debug(this.logger, message);
    }

    public void infoIfDev(String message) {
        if (!PlatformUtil.isDevelopmentEnvironment()) {
            return;
        }
        LoggerUtil.debug(this.logger, message);
    }

    public void trace(String message) {
        LoggerUtil.trace(this.logger, message);
    }

    public void error(Exception e) {
        this.error(e.getMessage());
    }

    public void initializeMessage() {
        this.info(this.prefix() + "Initializing...");
    }

    public void initializedMessage() {
        this.info(this.prefix() + "Initialized");
    }

    public String prefix() {
        if (this.name.isEmpty() || !this.isUsingPrefix()) {
            return "";
        }
        return "[" + this.name + "] ";
    }

    public void usePrefix(boolean use) {
        this.usingPrefix = use;
    }

    public boolean isUsingPrefix() {
        return this.usingPrefix;
    }

    public void log(String message, boolean isDebug) {
        if (isDebug) {
            this.debug(message);
            return;
        }
        this.info(message);
    }

    public void log_onClientTick(int tick, String message, boolean isDebug) {
        if (!PlatformUtil.isClient()) {
            return;
        }
        long time = ClientUtil.getRenderTime();
        if (time % (long)tick != 0L) {
            return;
        }
        this.log(message, isDebug);
    }

    public void log_onWorldTick(int tick, String message, class_1937 world, boolean isDebug) {
        long time = WorldUtil.getTime(world);
        if (time % (long)tick != 0L) {
            return;
        }
        this.log(message, isDebug);
    }

    public void log_onSystemTick(int tick, String message, boolean isDebug) {
        long millis = System.currentTimeMillis();
        long time = millis / 1000L * 60L;
        if (time % (long)tick != 0L) {
            return;
        }
        this.log(message, isDebug);
    }

    public void log_onClientTick(int tick, String message) {
        this.log_onClientTick(tick, message, false);
    }

    public void log_onWorldTick(int tick, String message, class_1937 world) {
        this.log_onWorldTick(tick, message, world, false);
    }

    public void log_onSystemTick(int tick, String message) {
        this.log_onSystemTick(tick, message, false);
    }

    public void log_onClientTick(String message, boolean isDebug) {
        this.log_onClientTick(60, message, isDebug);
    }

    public void log_onWorldTick(String message, class_1937 world, boolean isDebug) {
        this.log_onWorldTick(60, message, world, isDebug);
    }

    public void log_onSystemTick(String message, boolean isDebug) {
        this.log_onSystemTick(60, message, isDebug);
    }

    public void log_onClientTick(String message) {
        this.log_onClientTick(message, false);
    }

    public void log_onWorldTick(String message, class_1937 world) {
        this.log_onWorldTick(message, world, false);
    }

    public void log_onSystemTick(String message) {
        this.log_onSystemTick(message, false);
    }
}

