/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Locale;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.class_10584;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7995;
import net.minecraft.class_8046;
import net.minecraft.class_8567;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class MutantSkeletonBodyPart
extends class_1297
implements class_8046 {
    static final String TAG_BODY_PART = "BodyPart";
    static final String TAG_DESPAWN_TIMER = "DespawnTimer";
    private static final class_2940<BodyPart> DATA_BODY_PART = class_2945.method_12791(MutantSkeletonBodyPart.class, (class_2941)((class_2941)ModRegistry.BODY_PART_ENTITY_DATA_SERIALIZER.comp_349()));
    private final class_10584 interpolation = new class_10584((class_1297)this);
    private final boolean yawPositive;
    private final boolean pitchPositive;
    @Nullable
    private class_1308 owner;
    private int despawnTimer;

    public MutantSkeletonBodyPart(class_1299<? extends MutantSkeletonBodyPart> type, class_1937 level) {
        super(type, level);
        this.method_36456(this.field_5974.method_43057() * 360.0f);
        this.field_5982 = this.method_36454();
        this.method_36457(this.field_5974.method_43057() * 360.0f);
        this.field_6004 = this.method_36455();
        this.yawPositive = this.field_5974.method_43056();
        this.pitchPositive = this.field_5974.method_43056();
    }

    public MutantSkeletonBodyPart(class_1937 level, class_1308 owner, BodyPart bodyPart) {
        this((class_1299<? extends MutantSkeletonBodyPart>)((class_1299)ModEntityTypes.BODY_PART_ENTITY_TYPE.comp_349()), level);
        this.owner = owner;
        this.setBodyPart(bodyPart);
        this.method_5814(owner.method_23317(), owner.method_23318() + (double)(3.2f * (0.25f + this.field_5974.method_43057() * 0.5f)), owner.method_23321());
        this.method_20803(owner.method_20802());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_BODY_PART, (Object)BodyPart.PELVIS);
    }

    public BodyPart getBodyPart() {
        return (BodyPart)((Object)this.field_6011.method_12789(DATA_BODY_PART));
    }

    private void setBodyPart(BodyPart bodyPart) {
        this.field_6011.method_12778(DATA_BODY_PART, (Object)bodyPart);
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)this.getLegacyItemByPart());
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    public boolean method_64397(class_3218 level, class_1282 damageSource, float amount) {
        return false;
    }

    public boolean method_5863() {
        return this.method_5805();
    }

    public class_10584 method_66233() {
        return this.interpolation;
    }

    public void method_5878(class_1297 entity) {
        super.method_5878(entity);
        if (entity instanceof MutantSkeletonBodyPart) {
            MutantSkeletonBodyPart mutantSkeletonBodyPart = (MutantSkeletonBodyPart)entity;
            this.owner = mutantSkeletonBodyPart.owner;
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1023(0.0, 0.045, 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_18799(this.method_18798().method_1021(0.96));
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_1021(0.7));
        }
        if (!this.method_24828() && this.field_17046 == class_243.field_1353) {
            this.method_36456(this.method_36454() + 10.0f * (float)(this.yawPositive ? 1 : -1));
            this.method_36457(this.method_36455() + 15.0f * (float)(this.pitchPositive ? 1 : -1));
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                for (class_1297 entity : serverLevel.method_8333((class_1297)this, this.method_5829(), this::canHarm)) {
                    float damageAmount;
                    class_1282 damageSource;
                    if (!entity.method_64397(serverLevel, damageSource = serverLevel.method_48963().method_48811((class_1297)this, (class_1297)(this.owner != null ? this.owner : this)), damageAmount = 4.0f + (float)this.field_5974.method_43048(4))) continue;
                    entity.method_5639((float)this.method_20802() / 20.0f);
                }
            }
            if (this.despawnTimer > 0) {
                --this.despawnTimer;
            }
        } else {
            ++this.despawnTimer;
        }
        if (!this.method_37908().field_9236 && this.despawnTimer >= this.getMaxAge()) {
            this.method_31472();
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_3218 serverLevel;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (serverLevel = (class_3218)class_19372).method_64395().method_8355(class_1928.field_19393)) {
            class_5321<class_52> resourceKey = this.getItemPartLootTableId();
            class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(resourceKey);
            class_8567 lootParams = new class_8567.class_8568(serverLevel).method_51874(class_181.field_1226, (Object)this).method_51875(ModRegistry.BODY_PART_LOOT_CONTEXT_PARAM_SET);
            ObjectArrayList list = lootTable.method_51878(lootParams);
            for (class_1799 item : list) {
                if (item.method_7960()) continue;
                this.method_5775(serverLevel, item).method_6975();
            }
        }
        this.method_31472();
        return InteractionResultHelper.sidedSuccess((boolean)this.method_37908().field_9236);
    }

    private boolean canHarm(class_1297 entity) {
        return entity.method_5863() && entity.method_5864() != ModEntityTypes.MUTANT_SKELETON_ENTITY_TYPE.comp_349();
    }

    protected class_2561 method_23315() {
        return class_2561.method_43471((String)this.getLegacyItemByPart().method_7876());
    }

    private class_1792 getLegacyItemByPart() {
        return (class_1792)this.getBodyPart().group.item.get().comp_349();
    }

    private class_5321<class_52> getItemPartLootTableId() {
        return this.getBodyPart().group.lootTable.get();
    }

    public int getMaxAge() {
        return 6000;
    }

    protected void method_5652(class_11372 valueOutput) {
        valueOutput.method_71468(TAG_BODY_PART, BodyPart.CODEC, (Object)this.getBodyPart());
        valueOutput.method_71465(TAG_DESPAWN_TIMER, this.despawnTimer);
    }

    protected void method_5749(class_11368 valueInput) {
        valueInput.method_71426(TAG_BODY_PART, BodyPart.CODEC).ifPresent(this::setBodyPart);
        this.despawnTimer = valueInput.method_71424(TAG_DESPAWN_TIMER, 0);
    }

    @Nullable
    public class_1297 method_24921() {
        return this.owner;
    }

    public static enum BodyPart implements class_3542
    {
        PELVIS(BodyPartGroup.PELVIS),
        LEFT_UPPER_RIB(BodyPartGroup.RIB),
        RIGHT_UPPER_RIB(BodyPartGroup.RIB),
        LEFT_MIDDLE_RIB(BodyPartGroup.RIB),
        RIGHT_MIDDLE_RIB(BodyPartGroup.RIB),
        LEFT_LOWER_RIB(BodyPartGroup.RIB),
        RIGHT_LOWER_RIB(BodyPartGroup.RIB),
        HEAD(BodyPartGroup.SKULL),
        LEFT_ARM(BodyPartGroup.LIMB),
        RIGHT_ARM(BodyPartGroup.LIMB),
        LEFT_FORE_ARM(BodyPartGroup.LIMB),
        RIGHT_FORE_ARM(BodyPartGroup.LIMB),
        LEFT_LEG(BodyPartGroup.LIMB),
        RIGHT_LEG(BodyPartGroup.LIMB),
        LEFT_FORE_LEG(BodyPartGroup.LIMB),
        RIGHT_FORE_LEG(BodyPartGroup.LIMB),
        LEFT_SHOULDER(BodyPartGroup.SHOULDER),
        RIGHT_SHOULDER(BodyPartGroup.SHOULDER);

        private static final BodyPart[] VALUES;
        public static final class_3542.class_8808<BodyPart> CODEC;
        public static final IntFunction<BodyPart> BY_ID;
        public static final class_9139<ByteBuf, BodyPart> STREAM_CODEC;
        public final BodyPartGroup group;

        private BodyPart(BodyPartGroup group) {
            this.group = group;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = BodyPart.values();
            CODEC = class_3542.method_28140(() -> VALUES);
            BY_ID = class_7995.method_47914(Enum::ordinal, (Object[])VALUES, (class_7995.class_7996)class_7995.class_7996.field_41664);
            STREAM_CODEC = class_9135.method_56375(BY_ID, Enum::ordinal);
        }
    }

    public static enum BodyPartGroup {
        PELVIS(() -> ModItems.MUTANT_SKELETON_PELVIS_ITEM, () -> ModRegistry.MUTANT_SKELETON_PELVIS_LOOT_TABLE),
        RIB(() -> ModItems.MUTANT_SKELETON_RIB_ITEM, () -> ModRegistry.MUTANT_SKELETON_RIB_LOOT_TABLE),
        SKULL(() -> ModItems.MUTANT_SKELETON_SKULL_ITEM, () -> ModRegistry.MUTANT_SKELETON_SKULL_LOOT_TABLE),
        LIMB(() -> ModItems.MUTANT_SKELETON_LIMB_ITEM, () -> ModRegistry.MUTANT_SKELETON_LIMB_LOOT_TABLE),
        SHOULDER(() -> ModItems.MUTANT_SKELETON_SHOULDER_PAD_ITEM, () -> ModRegistry.MUTANT_SKELETON_SHOULDER_PAD_LOOT_TABLE);

        public final Supplier<class_6880.class_6883<class_1792>> item;
        public final Supplier<class_5321<class_52>> lootTable;

        private BodyPartGroup(Supplier<class_6880.class_6883<class_1792>> item, Supplier<class_5321<class_52>> lootTable) {
            this.item = item;
            this.lootTable = lootTable;
        }
    }
}

