/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.MutantSkeletonBodyPart;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.animation.AnimatedEntity;
import fuzs.mutantmonsters.world.entity.animation.EntityAnimation;
import fuzs.mutantmonsters.world.entity.mutant.MutantMonster;
import fuzs.mutantmonsters.world.entity.projectile.MutantArrow;
import fuzs.puzzleslib.api.util.v1.DamageHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1493;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8109;

public class MutantSkeleton
extends MutantMonster
implements AnimatedEntity {
    public static final EntityAnimation MELEE_ANIMATION = new EntityAnimation("mutant_skeleton_melee", 14);
    public static final EntityAnimation CONSTRICT_RIBS_ANIMATION = new EntityAnimation("mutant_skeleton_constrict_ribs", 20);
    public static final EntityAnimation SHOOT_ANIMATION = new EntityAnimation("mutant_skeleton_shoot", 32);
    public static final EntityAnimation MULTI_SHOT_ANIMATION = new EntityAnimation("mutant_skeleton_multi_shot", 30);
    private static final EntityAnimation[] ANIMATIONS = new EntityAnimation[]{MELEE_ANIMATION, CONSTRICT_RIBS_ANIMATION, SHOOT_ANIMATION, MULTI_SHOT_ANIMATION};
    private EntityAnimation animation = EntityAnimation.NONE;
    private int animationTick;

    public MutantSkeleton(class_1299<? extends MutantSkeleton> type, class_1937 worldIn) {
        super(type, worldIn);
        this.field_6194 = 20;
    }

    public static class_5132.class_5133 createAttributes() {
        return MutantSkeleton.method_26918().method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23717, 48.0).method_26868(class_5134.field_23719, 0.27).method_26868(class_5134.field_23718, 0.75).method_26868(class_5134.field_47761, 1.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new MeleeGoal(this));
        this.field_6201.method_6277(0, (class_1352)new ShootGoal(this));
        this.field_6201.method_6277(0, (class_1352)new MultiShotGoal(this));
        this.field_6201.method_6277(0, (class_1352)new ConstrictRibsGoal(this));
        this.field_6201.method_6277(1, (class_1352)new MutantMeleeAttackGoal((class_1314)this, 1.1).setMaxAttackTick(5));
        this.field_6201.method_6277(2, (class_1352)new AvoidDamageGoal((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new HurtByNearestTargetGoal((class_1314)this, class_1528.class));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true).method_6330(300));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1493.class, true));
    }

    public int method_5945() {
        return 1;
    }

    protected void method_16827() {
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.method_37908().method_23886() && this.field_6012 % 100 == 0 && this.method_5805() && this.method_6032() < this.method_6063()) {
            this.method_6025(2.0f);
        }
    }

    public boolean method_6121(class_3218 serverLevel, class_1297 entity) {
        if (!this.isAnimationPlaying()) {
            this.animation = this.field_5974.method_43048(4) != 0 ? MELEE_ANIMATION : CONSTRICT_RIBS_ANIMATION;
        }
        return true;
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float damageAmount) {
        return !(damageSource.method_5529() instanceof MutantSkeleton) && super.method_64397(serverLevel, damageSource, damageAmount);
    }

    protected boolean method_5860(class_1297 entityIn) {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected void method_6060(class_1309 livingEntity) {
        livingEntity.field_6037 = true;
    }

    @Override
    public EntityAnimation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(EntityAnimation animation) {
        this.animation = animation;
    }

    @Override
    public EntityAnimation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            for (class_1309 livingEntity : serverLevel.method_18467(class_1309.class, this.method_5829().method_1009(3.0, 2.0, 3.0))) {
                class_1282 damageSource = DamageHelper.damageSource((class_4538)serverLevel, ModRegistry.MUTANT_SKELETON_SHATTER_DAMAGE_TYPE, (class_1297)this);
                livingEntity.method_64397(serverLevel, damageSource, 7.0f);
            }
            for (MutantSkeletonBodyPart.BodyPart bodyPart : MutantSkeletonBodyPart.BodyPart.values()) {
                MutantSkeletonBodyPart mutantSkeletonBodyPart = new MutantSkeletonBodyPart((class_1937)serverLevel, (class_1308)this, bodyPart);
                mutantSkeletonBodyPart.method_18799(mutantSkeletonBodyPart.method_18798().method_1031((double)(this.field_5974.method_43057() * 0.8f * 2.0f - 0.8f), (double)(this.field_5974.method_43057() * 0.25f + 0.1f), (double)(this.field_5974.method_43057() * 0.8f * 2.0f - 0.8f)));
                serverLevel.method_8649((class_1297)mutantSkeletonBodyPart);
            }
        }
        this.field_6213 = 19;
    }

    protected class_3414 method_5994() {
        return (class_3414)ModSoundEvents.ENTITY_MUTANT_SKELETON_AMBIENT_SOUND_EVENT.comp_349();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModSoundEvents.ENTITY_MUTANT_SKELETON_HURT_SOUND_EVENT.comp_349();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModSoundEvents.ENTITY_MUTANT_SKELETON_DEATH_SOUND_EVENT.comp_349();
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
        this.method_5783((class_3414)ModSoundEvents.ENTITY_MUTANT_SKELETON_STEP_SOUND_EVENT.comp_349(), 0.15f, 1.0f);
    }

    static class MeleeGoal
    extends AnimationGoal<MutantSkeleton> {
        public MeleeGoal(MutantSkeleton mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return MELEE_ANIMATION;
        }

        public void method_6268() {
            ((MutantSkeleton)this.mob).method_5942().method_6340();
            class_1309 target = ((MutantSkeleton)this.mob).method_5968();
            if (target != null && target.method_5805()) {
                ((MutantSkeleton)this.mob).field_6206.method_6226((class_1297)target, 30.0f, 30.0f);
            }
            if (((MutantSkeleton)this.mob).animationTick == 3) {
                float attackDamage = (float)((MutantSkeleton)this.mob).method_45325(class_5134.field_23721);
                for (class_1309 livingEntity : ((MutantSkeleton)this.mob).method_37908().method_18467(class_1309.class, ((MutantSkeleton)this.mob).method_5829().method_1014(4.0))) {
                    if (livingEntity instanceof MutantSkeleton) continue;
                    double dist = ((MutantSkeleton)this.mob).method_5739((class_1297)livingEntity);
                    double x = ((MutantSkeleton)this.mob).method_23317() - livingEntity.method_23317();
                    double z = ((MutantSkeleton)this.mob).method_23321() - livingEntity.method_23321();
                    if (!(dist <= 3.0) || !(EntityUtil.getHeadAngle((class_1309)this.mob, x, z) < 60.0f)) continue;
                    float power = 1.8f + (float)((MutantSkeleton)this.mob).field_5974.method_43048(5) * 0.15f;
                    livingEntity.method_64419(((MutantSkeleton)this.mob).method_37908().method_48963().method_48812((class_1309)this.mob), attackDamage > 0.0f ? attackDamage + (float)((MutantSkeleton)this.mob).field_5974.method_43048(2) : 0.0f);
                    livingEntity.method_18800(-x / dist * (double)power, Math.max((double)0.28f, livingEntity.method_18798().field_1351), -z / dist * (double)power);
                    EntityUtil.sendPlayerVelocityPacket((class_1297)livingEntity);
                }
                ((MutantSkeleton)this.mob).method_5783(class_3417.field_14999, 1.0f, 1.0f / (((MutantSkeleton)this.mob).field_5974.method_43057() * 0.4f + 1.2f));
            }
        }
    }

    static class ShootGoal
    extends AnimationGoal<MutantSkeleton> {
        public ShootGoal(MutantSkeleton mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return SHOOT_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            class_1309 target = ((MutantSkeleton)this.mob).method_5968();
            return target != null && !((MutantSkeleton)this.mob).isAnimationPlaying() && ((MutantSkeleton)this.mob).field_5974.method_43048(12) == 0 && ((MutantSkeleton)this.mob).method_5858((class_1297)target) > 4.0 && ((MutantSkeleton)this.mob).method_6057((class_1297)target);
        }

        public void method_6268() {
            class_1309 target = ((MutantSkeleton)this.mob).method_5968();
            if (target != null) {
                ((MutantSkeleton)this.mob).method_5942().method_6340();
                ((MutantSkeleton)this.mob).field_6206.method_6226((class_1297)target, 30.0f, 30.0f);
                if (((MutantSkeleton)this.mob).animationTick == 5) {
                    ((MutantSkeleton)this.mob).method_5783((class_3414)class_3417.field_14916.comp_349(), 1.0f, 1.0f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 20) {
                    ((MutantSkeleton)this.mob).method_5783((class_3414)class_3417.field_14626.comp_349(), 1.0f, 1.0f / (((MutantSkeleton)this.mob).field_5974.method_43057() * 0.5f + 1.0f) + 0.2f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 26 && target.method_5805()) {
                    float randomization = (float)((MutantSkeleton)this.mob).field_6235 / 2.0f;
                    if (((MutantSkeleton)this.mob).field_6235 > 0 && ((MutantSkeleton)this.mob).field_6253 > 0.0f && ((MutantSkeleton)this.mob).method_6081() != null && ((MutantSkeleton)this.mob).method_6081().method_5529() != null) {
                        randomization = (float)((MutantSkeleton)this.mob).field_6235 / 2.0f;
                    } else if (!((MutantSkeleton)this.mob).method_6057((class_1297)target)) {
                        randomization = 0.5f + ((MutantSkeleton)this.mob).field_5974.method_43057();
                    }
                    MutantArrow mutantArrow = new MutantArrow(((MutantSkeleton)this.mob).method_37908(), (class_1309)this.mob);
                    mutantArrow.shoot(target, 2.4f, randomization);
                    if (((MutantSkeleton)this.mob).field_5974.method_43048(4) == 0) {
                        mutantArrow.method_7463(new class_1293(class_1294.field_5899, 80 + ((MutantSkeleton)this.mob).field_5974.method_43048(60), 0));
                    }
                    if (((MutantSkeleton)this.mob).field_5974.method_43048(4) == 0) {
                        mutantArrow.method_7463(new class_1293(class_1294.field_5903, 120 + ((MutantSkeleton)this.mob).field_5974.method_43048(60), 1));
                    }
                    if (((MutantSkeleton)this.mob).field_5974.method_43048(4) == 0) {
                        mutantArrow.method_7463(new class_1293(class_1294.field_5909, 120 + ((MutantSkeleton)this.mob).field_5974.method_43048(60), 1));
                    }
                    ((MutantSkeleton)this.mob).method_37908().method_8649((class_1297)mutantArrow);
                    ((MutantSkeleton)this.mob).method_5783(class_3417.field_15187, 1.0f, 1.0f / (((MutantSkeleton)this.mob).field_5974.method_43057() * 0.4f + 1.2f) + 0.25f);
                }
            }
        }
    }

    static class MultiShotGoal
    extends AnimationGoal<MutantSkeleton> {
        private final List<MutantArrow> shots = new ArrayList<MutantArrow>();

        public MultiShotGoal(MutantSkeleton mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return MULTI_SHOT_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            class_1309 target = ((MutantSkeleton)this.mob).method_5968();
            return target != null && ((MutantSkeleton)this.mob).field_6012 % 3 == 0 && !((MutantSkeleton)this.mob).isAnimationPlaying() && (((MutantSkeleton)this.mob).method_24828() && ((MutantSkeleton)this.mob).field_5974.method_43048(26) == 0 && ((MutantSkeleton)this.mob).method_6057((class_1297)target) || ((MutantSkeleton)this.mob).method_5854() == target);
        }

        public void method_6268() {
            class_1309 target = ((MutantSkeleton)this.mob).method_5968();
            if (target != null) {
                ((MutantSkeleton)this.mob).method_5942().method_6340();
                ((MutantSkeleton)this.mob).field_6206.method_6226((class_1297)target, 30.0f, 30.0f);
                if (((MutantSkeleton)this.mob).animationTick == 10) {
                    ((MutantSkeleton)this.mob).method_5848();
                    double x = target.method_23317() - ((MutantSkeleton)this.mob).method_23317();
                    double z = target.method_23321() - ((MutantSkeleton)this.mob).method_23321();
                    float scale = 0.06f + ((MutantSkeleton)this.mob).field_5974.method_43057() * 0.03f;
                    if (((MutantSkeleton)this.mob).method_5858((class_1297)target) < 16.0) {
                        x *= -1.0;
                        z *= -1.0;
                        scale = (float)((double)scale * 5.0);
                    }
                    ((MutantSkeleton)this.mob).field_17046 = class_243.field_1353;
                    ((MutantSkeleton)this.mob).method_18800(x * (double)scale, 1.1 * (double)((MutantSkeleton)this.mob).method_23313(), z * (double)scale);
                }
                if (((MutantSkeleton)this.mob).animationTick == 15) {
                    ((MutantSkeleton)this.mob).method_5783((class_3414)class_3417.field_15089.comp_349(), 1.0f, 1.0f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 20) {
                    ((MutantSkeleton)this.mob).method_5783((class_3414)class_3417.field_14626.comp_349(), 1.0f, 1.0f / (((MutantSkeleton)this.mob).field_5974.method_43057() * 0.5f + 1.0f) + 0.2f);
                }
                if (((MutantSkeleton)this.mob).animationTick >= 24 && ((MutantSkeleton)this.mob).animationTick < 28) {
                    if (!this.shots.isEmpty()) {
                        for (MutantArrow arrowEntity : this.shots) {
                            ((MutantSkeleton)this.mob).method_37908().method_8649((class_1297)arrowEntity);
                        }
                        this.shots.clear();
                    }
                    for (int i = 0; i < 6; ++i) {
                        MutantArrow mutantArrow = new MutantArrow(((MutantSkeleton)this.mob).method_37908(), (class_1309)this.mob);
                        mutantArrow.shoot(target, 2.0f - ((MutantSkeleton)this.mob).field_5974.method_43057() * 0.1f, 3.0f);
                        this.shots.add(mutantArrow);
                    }
                    ((MutantSkeleton)this.mob).method_5783(class_3417.field_15187, 1.0f, 1.0f / (((MutantSkeleton)this.mob).field_5974.method_43057() * 0.4f + 1.2f) + 0.25f);
                }
            }
        }

        @Override
        public void method_6270() {
            super.method_6270();
            this.shots.clear();
        }
    }

    static class ConstrictRibsGoal
    extends AnimationGoal<MutantSkeleton> {
        public ConstrictRibsGoal(MutantSkeleton mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return CONSTRICT_RIBS_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            return ((MutantSkeleton)this.mob).method_5968() != null && super.method_6264();
        }

        public void method_6268() {
            class_1309 target = ((MutantSkeleton)this.mob).method_5968();
            if (target != null) {
                ((MutantSkeleton)this.mob).method_5942().method_6340();
                if (((MutantSkeleton)this.mob).animationTick < 6) {
                    ((MutantSkeleton)this.mob).field_6206.method_6226((class_1297)target, 30.0f, 30.0f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 5) {
                    target.method_5848();
                }
                if (((MutantSkeleton)this.mob).animationTick == 6) {
                    float attackDamage = (float)((MutantSkeleton)this.mob).method_45325(class_5134.field_23721);
                    class_8109 damageSources = ((MutantSkeleton)this.mob).method_37908().method_48963();
                    if (!target.method_64397((class_3218)((MutantSkeleton)this.mob).method_37908(), damageSources.method_48812((class_1309)this.mob), attackDamage > 0.0f ? attackDamage + 6.0f : 0.0f)) {
                        EntityUtil.disableShield(target, 100);
                    }
                    double motionX = (double)(1.0f + ((MutantSkeleton)this.mob).field_5974.method_43057() * 0.4f) * (double)(((MutantSkeleton)this.mob).field_5974.method_43056() ? 1 : -1);
                    double motionY = 0.4f + ((MutantSkeleton)this.mob).field_5974.method_43057() * 0.8f;
                    double motionZ = (double)(1.0f + ((MutantSkeleton)this.mob).field_5974.method_43057() * 0.4f) * (double)(((MutantSkeleton)this.mob).field_5974.method_43056() ? 1 : -1);
                    target.method_18800(motionX, motionY, motionZ);
                    EntityUtil.sendPlayerVelocityPacket((class_1297)target);
                    ((MutantSkeleton)this.mob).method_5783((class_3414)class_3417.field_15152.comp_349(), 0.5f, 0.8f + ((MutantSkeleton)this.mob).field_5974.method_43057() * 0.4f);
                }
            }
        }
    }
}

