/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.config.ChannelMode;
import nx.pingwheel.common.config.ServerConfig;
import nx.pingwheel.common.integration.TeamContextHandler;
import nx.pingwheel.common.network.PingLocationC2SPacket;
import nx.pingwheel.common.network.PingLocationS2CPacket;
import nx.pingwheel.common.network.UpdateChannelC2SPacket;
import nx.pingwheel.common.platform.IPlatformNetworkService;
import nx.pingwheel.common.util.RateLimiter;

public class ServerCore {
    private static final ServerConfig SERVER_CONFIG = ServerConfig.HANDLER.getConfig();
    private static final HashMap<UUID, String> PLAYER_CHANNELS = new HashMap();
    private static final HashMap<UUID, RateLimiter> PLAYER_RATES = new HashMap();

    private ServerCore() {
    }

    public static void init() {
        RateLimiter.setRates(SERVER_CONFIG.getMsToRegenerate(), SERVER_CONFIG.getRateLimit());
    }

    public static void onPlayerDisconnect(class_3222 player) {
        PLAYER_CHANNELS.remove(player.method_5667());
        PLAYER_RATES.remove(player.method_5667());
    }

    public static void onChannelUpdate(class_3222 player, UpdateChannelC2SPacket packet) {
        if (packet.isCorrupt()) {
            Global.LOGGER.warn(() -> "invalid channel update from %s (%s)".formatted(player.method_7334().getName(), player.method_5667()));
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a78[Ping-Wheel] \u00a7cChannel couldn't be updated\n\u00a7fMake sure your version matches the server's version: \u00a7d" + Global.MOD_VERSION)), false);
            return;
        }
        ServerCore.updatePlayerChannel(player, packet.channel());
    }

    public static void onPingLocation(MinecraftServer server, class_3222 player, PingLocationC2SPacket packet) {
        if (packet.isCorrupt()) {
            Global.LOGGER.warn(() -> "invalid ping location from %s (%s)".formatted(player.method_7334().getName(), player.method_5667()));
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a78[Ping-Wheel] \u00a7cUnable to send ping\n\u00a7fMake sure your version matches the server's version: \u00a7d" + Global.MOD_VERSION)), false);
            return;
        }
        PLAYER_RATES.putIfAbsent(player.method_5667(), new RateLimiter());
        RateLimiter rateLimiter = PLAYER_RATES.get(player.method_5667());
        if (SERVER_CONFIG.getRateLimit() > 0 && rateLimiter.checkExceeded()) {
            return;
        }
        String channel = packet.channel();
        ChannelMode defaultChannelMode = SERVER_CONFIG.getDefaultChannelMode();
        if (channel.isEmpty() && defaultChannelMode == ChannelMode.DISABLED) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a78[Ping-Wheel] \u00a7eMust be in a channel to ping location\n\u00a7fUse \u00a7a/pingwheel channel\u00a7f to switch"), false);
            return;
        }
        if (channel.isEmpty() && defaultChannelMode == ChannelMode.TEAM_ONLY && !TeamContextHandler.hasTeam((class_1657)player)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a78[Ping-Wheel] \u00a7eMust be in a team or channel to ping location\n\u00a7fUse \u00a7a/pingwheel channel\u00a7f to switch"), false);
            return;
        }
        if (!channel.equals(PLAYER_CHANNELS.getOrDefault(player.method_5667(), ""))) {
            ServerCore.updatePlayerChannel(player, channel);
        }
        class_3324 playerList = server.method_3760();
        PingLocationS2CPacket packetOut = !SERVER_CONFIG.isPlayerTrackingEnabled() && ServerCore.targetEntityIsPlayer(packet, playerList) ? new PingLocationS2CPacket(packet.channel(), packet.pos(), null, packet.sequence(), packet.dimension(), player.method_5667()) : PingLocationS2CPacket.fromClientPacket(packet, player.method_5667());
        for (class_3222 p : playerList.method_14571()) {
            if (!channel.equals(PLAYER_CHANNELS.getOrDefault(p.method_5667(), "")) || channel.isEmpty() && defaultChannelMode != ChannelMode.GLOBAL && !TeamContextHandler.inSameContext((class_1657)player, (class_1657)p)) continue;
            IPlatformNetworkService.INSTANCE.sendToClient(packetOut, p);
        }
    }

    private static boolean targetEntityIsPlayer(PingLocationC2SPacket packet, class_3324 playerList) {
        UUID playerUUID = packet.entity();
        if (playerUUID == null) {
            return false;
        }
        return playerList.method_14602(playerUUID) != null;
    }

    private static void updatePlayerChannel(class_3222 player, String channel) {
        if (channel.isEmpty()) {
            PLAYER_CHANNELS.remove(player.method_5667());
            Global.LOGGER.info(() -> "Channel update: %s -> default".formatted(player.method_7334().getName()));
        } else {
            PLAYER_CHANNELS.put(player.method_5667(), channel);
            Global.LOGGER.info(() -> "Channel update: %s -> \"%s\"".formatted(player.method_7334().getName(), channel));
        }
    }
}

