/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.configuration;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.network.ConfigurationMessageContext;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import com.mrcrayfish.framework.network.FrameworkCodecs;
import com.mrcrayfish.framework.network.message.ConfigurationMessage;
import java.util.concurrent.CountDownLatch;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

public record S2CConfigData(class_2960 key, byte[] data) {
    public static final class_9139<class_2540, S2CConfigData> STREAM_CODEC = class_9139.method_56435((class_9139)class_2960.field_48267, S2CConfigData::key, FrameworkCodecs.BYTE_ARRAY, S2CConfigData::data, S2CConfigData::new);

    public static void encode(S2CConfigData message, class_2540 buffer) {
        buffer.method_10812(message.key);
        buffer.method_10813(message.data);
    }

    public static S2CConfigData decode(class_2540 buffer) {
        class_2960 key = buffer.method_10810();
        byte[] data = buffer.method_10795();
        return new S2CConfigData(key, data);
    }

    public static void handle(S2CConfigData message, ConfigurationMessageContext context) {
        Constants.LOG.debug(ConfigurationMessage.MARKER, "Receiving config data from server: '{}'", (Object)message.key());
        boolean[] failed = new boolean[1];
        CountDownLatch block = new CountDownLatch(1);
        context.execute(() -> {
            try {
                if (!FrameworkConfigManager.getInstance().processConfigData(message)) {
                    failed[0] = true;
                }
            }
            catch (Exception e) {
                failed[0] = true;
                Constants.LOG.error(ConfigurationMessage.MARKER, "Fatal error when trying to process sync config", (Throwable)e);
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException ignored) {
            failed[0] = true;
        }
        if (failed[0]) {
            context.disconnect((class_2561)class_2561.method_43471((String)"framework.gui.sync_config_failed"));
        }
    }
}

