/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gl.sync;

import java.nio.IntBuffer;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;

public class GlFence {
    private final long id;
    private boolean disposed;

    public GlFence(long id) {
        this.id = id;
    }

    public boolean isCompleted() {
        int result;
        this.checkDisposed();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer count = stack.callocInt(1);
            result = GL32C.glGetSynci((long)this.id, (int)37140, (IntBuffer)count);
            if (count.get(0) != 1) {
                throw new RuntimeException("glGetSync returned more than one value");
            }
        }
        return result == 37145;
    }

    public void sync() {
        this.checkDisposed();
        this.sync(Long.MAX_VALUE);
    }

    public void sync(long timeout) {
        this.checkDisposed();
        GL32C.glClientWaitSync((long)this.id, (int)1, (long)timeout);
    }

    public void delete() {
        GL32C.glDeleteSync((long)this.id);
        this.disposed = true;
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Fence object has been disposed");
        }
    }
}

