/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.ui;

import com.google.common.base.Objects;
import net.minecraft.class_8021;

public class Rect2f {
    private float xPos;
    private float yPos;
    private float width;
    private float height;

    public Rect2f() {
    }

    public Rect2f(float x, float y, float width, float height) {
        this.xPos = x;
        this.yPos = y;
        this.width = width;
        this.height = height;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rect2f rect2f = (Rect2f)o;
        return Float.compare(this.xPos, rect2f.xPos) == 0 && Float.compare(this.yPos, rect2f.yPos) == 0 && Float.compare(this.width, rect2f.width) == 0 && Float.compare(this.height, rect2f.height) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.xPos), Float.valueOf(this.yPos), Float.valueOf(this.width), Float.valueOf(this.height)});
    }

    public static Rect2f of(class_8021 element) {
        return new Rect2f(element.method_46426(), element.method_46427(), element.method_25368(), element.method_25364());
    }

    public boolean intersects(Rect2f otherRect) {
        return this.xPos < otherRect.getX() + otherRect.getWidth() && this.xPos + this.width > otherRect.getX() && this.yPos < otherRect.getY() + otherRect.getHeight() && this.yPos + this.height > otherRect.getY();
    }

    public Rect2f intersect(Rect2f otherRect) {
        float x1 = this.xPos;
        float y1 = this.yPos;
        float x2 = this.xPos + this.width;
        float y2 = this.yPos + this.height;
        float otherX1 = otherRect.getX();
        float otherY1 = otherRect.getY();
        float otherX2 = otherX1 + otherRect.getWidth();
        float otherY2 = otherY1 + otherRect.getHeight();
        this.xPos = Math.max(x1, otherX1);
        this.yPos = Math.max(y1, otherY1);
        this.width = Math.max(0.0f, Math.min(x2, otherX2) - this.xPos);
        this.height = Math.max(0.0f, Math.min(y2, otherY2) - this.yPos);
        return this;
    }

    public float getX() {
        return this.xPos;
    }

    public float getY() {
        return this.yPos;
    }

    public void setX(float x) {
        this.xPos = x;
    }

    public void setY(float y) {
        this.yPos = y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setPosition(float x, float y) {
        this.xPos = x;
        this.yPos = y;
    }

    public boolean contains(float x, float y) {
        return x >= this.xPos && x <= this.xPos + this.width && y >= this.yPos && y <= this.yPos + this.height;
    }

    public Rect2f copy() {
        return new Rect2f(this.xPos, this.yPos, this.width, this.height);
    }

    public void copy(Rect2f src) {
        this.xPos = src.xPos;
        this.yPos = src.yPos;
        this.width = src.width;
        this.height = src.height;
    }

    public float getRight() {
        return this.xPos + this.width;
    }

    public float getBottom() {
        return this.yPos + this.height;
    }
}

