/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.gui.screens.inventory.tooltip;

import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.component.TooltipComponent;
import fuzs.helditemtooltips.config.TooltipComponentConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5244;
import net.minecraft.class_7417;
import net.minecraft.class_8828;

public final class TooltipComponentHolder {
    private final TooltipComponent component;
    private final TooltipComponentConfig settings;
    private List<class_2561> lines;
    private int maxLines = -1;

    public TooltipComponentHolder(TooltipComponent component, TooltipComponentConfig settings) {
        this.component = component;
        this.settings = settings;
    }

    public boolean include() {
        return this.settings.include;
    }

    public int ordering() {
        return this.settings.ordering;
    }

    public int priority() {
        return this.settings.priority;
    }

    public void clear() {
        this.lines = null;
    }

    public void rebuildIfNecessary(class_1799 itemStack, class_1792.class_9635 tooltipContext) {
        if (this.lines == null || this.component.alwaysUpdate()) {
            ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>(List.of(class_5244.field_39003));
            class_1836.class_1837 tooltipFlag = this.settings.advancedTooltips ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
            this.component.addToTooltip(itemStack, tooltipContext, tooltipLines::add, (class_1836)tooltipFlag);
            ListIterator<class_2561> iterator = tooltipLines.listIterator();
            while (iterator.hasNext()) {
                class_8828 contents;
                class_2561 component2 = (class_2561)iterator.next();
                class_7417 class_74172 = component2.method_10851();
                if (!(class_74172 instanceof class_8828) || !(contents = (class_8828)class_74172).comp_737().isBlank()) continue;
                if (!component2.method_10855().isEmpty()) {
                    iterator.set((class_2561)component2.method_10855().getFirst());
                    continue;
                }
                iterator.remove();
            }
            class_2583 style = this.settings.getStyle();
            if (style != class_2583.field_24360) {
                tooltipLines.replaceAll(component -> component.method_27661().method_27694(arg_0 -> ((class_2583)style).method_27702(arg_0)));
            }
            this.lines = Collections.unmodifiableList(tooltipLines);
        }
    }

    public int subtractLines(int maxLines) {
        this.maxLines = Math.min(this.size(), Math.max(maxLines, 0));
        return maxLines - this.size();
    }

    public List<class_2561> getLines() {
        return this.getLinesOrThrow().subList(0, this.maxLines);
    }

    public int size() {
        return this.getLinesOrThrow().size();
    }

    private List<class_2561> getLinesOrThrow() {
        Objects.requireNonNull(this.lines, "lines is null");
        return this.lines;
    }
}

