/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.config;

import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import org.jetbrains.annotations.Nullable;

public class TooltipComponentConfig
implements ConfigCore {
    @Config(description={"Should this tooltip component be included when rendering held item tooltips."})
    public boolean include;
    @Config(description={"The order in which this tooltip component appears in relation to other components. Smaller values appear first."})
    public int ordering;
    @Config(description={"Priority for rendering this tooltip. When not enough lines are available (like an item with enchantments), components with a low priority will be skipped."})
    public int priority;
    @Config(description={"Represent information for this component as if advanced tooltips were enabled independently of the actual setting."})
    public boolean advancedTooltips;
    @Config(description={"Text formatting settings for this component's text appearance."})
    private final FormattingConfig formatting;

    private TooltipComponentConfig(boolean defaultValue, int ordering, int priority, boolean advancedTooltips, @Nullable class_124 textColor) {
        this.include = defaultValue;
        this.ordering = ordering;
        this.priority = priority;
        this.advancedTooltips = advancedTooltips;
        this.formatting = new FormattingConfig(textColor);
    }

    public static TooltipComponentConfig simple(boolean defaultValue, int ordering, int priority) {
        return new TooltipComponentConfig(defaultValue, ordering, priority, false, null);
    }

    public static TooltipComponentConfig advanced(boolean defaultValue, int ordering, int priority) {
        return new TooltipComponentConfig(defaultValue, ordering, priority, true, null);
    }

    public class_2583 getStyle() {
        return this.formatting.getStyle();
    }

    private static class FormattingConfig
    implements ConfigCore {
        static final String DEFAULT_FORMATTING = "default";
        @Config(name="text_color", description={"The color of this component's text."})
        @Config.AllowedValues(values={"default", "black", "dark_blue", "dark_green", "dark_aqua", "dark_red", "dark_purple", "gold", "gray", "dark_gray", "blue", "green", "aqua", "red", "light_purple", "yellow", "white"})
        String textColorRaw;
        @Config(description={"Should the text in this component be replaced by random characters."})
        public boolean obfuscated;
        @Config(description={"Should the text in this component appear bold."})
        public boolean bold;
        @Config(description={"Should the text in this component appear struck-through."})
        public boolean strikethrough;
        @Config(description={"Should the text in this component appear with an underline."})
        public boolean underline;
        @Config(description={"Should the text in this component appear italic."})
        public boolean italic;
        @Nullable
        public class_124 textColor;

        public FormattingConfig(@Nullable class_124 textColor) {
            this.textColorRaw = textColor == null ? DEFAULT_FORMATTING : textColor.method_15434();
        }

        public void afterConfigReload() {
            this.textColor = class_124.method_533((String)this.textColorRaw);
        }

        class_2583 getStyle() {
            class_2583 style = class_2583.field_24360;
            if (this.textColor != null) {
                style = style.method_10977(this.textColor);
            }
            if (this.obfuscated) {
                style = style.method_36141(Boolean.valueOf(true));
            }
            if (this.bold) {
                style = style.method_10982(Boolean.valueOf(true));
            }
            if (this.strikethrough) {
                style = style.method_36140(Boolean.valueOf(true));
            }
            if (this.underline) {
                style = style.method_30938(Boolean.valueOf(true));
            }
            if (this.italic) {
                style = style.method_10978(Boolean.valueOf(true));
            }
            return style;
        }
    }
}

